/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.IntFieldType;

public class IntFieldPanel
extends FieldPanel {
    private IntFieldType fieldType;
    private SpinnerNumberModel spinnerModel;
    private JSpinner spinner;
    private JTextField textField;

    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        this.updateSpinner();
        return this.spinnerModel.getNumber();
    }

    private void updateSpinner() {
        try {
            this.spinner.commitEdit();
        }
        catch (ParseException e) {
            this.spinner.setValue(this.spinnerModel.getValue());
        }
    }

    @Override
    public void setValue(Object o) {
        int val = (Integer)o;
        Integer max = this.fieldType.getMaxValue();
        Integer min = this.fieldType.getMinValue();
        if (min != null && val < min) {
            val = min;
        } else if (max != null && val > max) {
            val = max;
        }
        this.spinner.setValue(new Integer(val));
    }

    public void setFieldType(FieldType fType) {
        this.fieldType = (IntFieldType)fType;
        Integer minObj = this.fieldType.getMinValue();
        Integer maxObj = this.fieldType.getMaxValue();
        Integer defObj = this.fieldType.getDefaultValue();
        int min = minObj != null ? minObj : Integer.MIN_VALUE;
        int max = maxObj != null ? maxObj : Integer.MAX_VALUE;
        int def = defObj != null ? defObj : 0;
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        if (this.spinner != null) {
            innerPanel.remove(this.spinner);
        }
        this.spinnerModel = new SpinnerNumberModel(def, min, max, 1);
        this.spinner = new JSpinner(this.spinnerModel);
        this.spinner.setPreferredSize(new Dimension(70, 20));
        JSpinner.NumberEditor editor = (JSpinner.NumberEditor)this.spinner.getEditor();
        this.textField = editor.getTextField();
        this.textField.addFocusListener(new FieldPanel.InnerPrimaryFocusListener());
        innerPanel.add(this.spinner);
        this.add((Component)innerPanel, "North");
        this.getPrimaryComponent().addKeyListener(new FieldPanel.ControlKeyListener());
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.textField;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.spinner.setEnabled(b);
    }

    public JSpinner getSpinner() {
        return this.spinner;
    }
}

