/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import au.com.ordermate.util.Assert;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import officemate.adminkit.ObjectEditorPanel;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.ObjectSelectorPanel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.dialogs.ObjectEditorDialog;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.ObjectManagerFieldPanel;
import officemate.adminkit.search.SearchDialog;
import officemate.adminkit.search.SearchPanel;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.ObjectRefFieldType;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ObjectRefFieldPanel
extends ObjectManagerFieldPanel {
    private ObjectRefFieldType fieldType;
    private ObjectTemplate template;
    private ObjectSelectorPanel selectorView;
    private JButton newButton;
    private JButton editButton;
    private JButton searchButton;
    public static final ImageIcon NEW_ICON = new ImageIcon(ObjectRefFieldPanel.class.getResource("/ordermate/images/new_icon16.png"));
    public static final ImageIcon EDIT_ICON = new ImageIcon(ObjectRefFieldPanel.class.getResource("/ordermate/images/edit_icon16.png"));
    public static final ImageIcon SEARCH_ICON = new ImageIcon(ObjectRefFieldPanel.class.getResource("/ordermate/images/search16.png"));
    public final Signal search = Signals.createSignal();

    public ObjectRefFieldPanel(ObjectManager manager) {
        super(manager);
        Assert.isTrue((manager != null ? 1 : 0) != 0, (String)"ObjectManager may not be null.");
    }

    protected void gotObjectSelected(Object obj) {
        if (this.editButton != null) {
            this.editButton.setEnabled(obj != null);
        }
    }

    protected void gotObjectSelected(Object obj, ObjectSelectorPanel selectedFrom) {
        this.gotObjectSelected(obj);
    }

    public ObjectSelectorPanel getObjectSelector() {
        return this.selectorView;
    }

    public void setObjectSelector(ObjectSelectorPanel selector) {
        this.selectorView = selector;
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        Object obj = this.selectorView.getSelectedObject();
        if (obj instanceof String) {
            if (((String)obj).equalsIgnoreCase("")) {
                return null;
            }
            return obj;
        }
        return obj;
    }

    @Override
    public void setValue(Object toSelect) {
        this.selectorView.setSelectedObject(toSelect);
        if (this.editButton != null) {
            this.editButton.setEnabled(toSelect != null);
        }
    }

    @Override
    public void setFieldType(FieldType fType) {
        this.fieldType = (ObjectRefFieldType)fType;
        InnerActionListener al = new InnerActionListener();
        this.template = this.getObjectManager().getTemplate(this.fieldType.getJavaClass());
        if (this.template == null) {
            throw new IllegalArgumentException("No template found for type " + this.fieldType.getJavaClass().getName());
        }
        if (this.selectorView == null) {
            this.selectorView = this.template.getNewSelectPanel(this.fieldType.isNullAllowed(), this.fieldType.isSingleObject());
        }
        this.add(this.selectorView);
        this.selectorView.objectSelected.connect((Object)this, "gotObjectSelected");
        this.selectorView.getPrimaryComponent().addFocusListener(new FieldPanel.InnerPrimaryFocusListener());
        if (this.fieldType.isNewAllowed()) {
            this.newButton = new JButton(NEW_ICON);
            this.newButton.setToolTipText("New...");
            this.newButton.addActionListener(al);
            this.add(this.newButton);
            this.newButton.setFocusable(false);
        }
        if (this.fieldType.isEditAllowed()) {
            this.editButton = new JButton(EDIT_ICON);
            this.editButton.setToolTipText("Edit...");
            this.editButton.addActionListener(al);
            this.add(this.editButton);
            this.editButton.setFocusable(false);
        }
        if (this.fieldType.isSearchAllowed()) {
            this.searchButton = new JButton(SEARCH_ICON);
            this.searchButton.setToolTipText("Search...");
            this.searchButton.addActionListener(al);
            this.add(this.searchButton);
            this.searchButton.setFocusable(false);
        }
        this.getPrimaryComponent().addKeyListener(new FieldPanel.ControlKeyListener());
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.selectorView.setToolTipText(text);
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.selectorView.setEnabled(b);
        if (this.newButton != null) {
            this.newButton.setEnabled(b);
        }
        if (this.editButton != null) {
            this.editButton.setEnabled(b);
        }
        if (this.searchButton != null) {
            this.searchButton.setEnabled(b);
        }
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.selectorView.getPrimaryComponent();
    }

    private class InnerActionListener
    implements ActionListener {
        private InnerActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (ObjectRefFieldPanel.this.newButton != null && source == ObjectRefFieldPanel.this.newButton) {
                ObjectEditorPanel editorView = ObjectRefFieldPanel.this.template.getNewEditPanel(null);
                if (ObjectEditorDialog.doDialog(null, editorView) == 0) {
                    editorView.saveObject();
                    Object createdObject = editorView.getEditedObject();
                    ObjectRefFieldPanel.this.template.getManager().saveObject(createdObject, ObjectRefFieldPanel.this.template);
                    ObjectRefFieldPanel.this.selectorView.updateView();
                    ObjectRefFieldPanel.this.selectorView.setSelectedObject(createdObject);
                } else {
                    editorView.cancelObject();
                }
                ObjectRefFieldPanel.this.revalidate();
            } else if (ObjectRefFieldPanel.this.editButton != null && source == ObjectRefFieldPanel.this.editButton) {
                ObjectEditorPanel editorView;
                Object myObject = ObjectRefFieldPanel.this.getValue();
                if (myObject != null && ObjectEditorDialog.doDialog(null, editorView = ObjectRefFieldPanel.this.template.getNewEditPanel(myObject)) == 0) {
                    editorView.saveObject();
                    ObjectRefFieldPanel.this.template.getManager().saveObject(editorView.getEditedObject(), ObjectRefFieldPanel.this.template);
                    ObjectRefFieldPanel.this.selectorView.updateView();
                    ObjectRefFieldPanel.this.selectorView.setSelectedObject(myObject);
                    ObjectRefFieldPanel.this.revalidate();
                }
            } else if (ObjectRefFieldPanel.this.searchButton != null && source == ObjectRefFieldPanel.this.searchButton) {
                SearchPanel panel = ObjectRefFieldPanel.this.fieldType.getSearchPanel();
                if (panel != null) {
                    Long selectedID = SearchDialog.search(null, panel, "Search for " + ObjectRefFieldPanel.this.template.getName());
                    Object selObject = panel.getSelectedObject(selectedID);
                    if (selObject != null) {
                        ObjectRefFieldPanel.this.selectorView.setSelectedObject(selObject);
                    }
                    ObjectRefFieldPanel.this.revalidate();
                } else {
                    ObjectRefFieldPanel.this.search.emit();
                }
            }
        }
    }
}

