/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import au.com.ordermate.util.Pair;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.ObjectManagerFieldPanel;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.KVPairFieldType;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class PairListFieldPanel
extends ObjectManagerFieldPanel {
    public Signal removeObject = Signals.createSignal(Object.class, (String)"removedObject");
    private KVPairFieldType fieldType;
    protected JTable table;
    private PairFieldTableModel tableModel;
    private JScrollPane scroller;
    protected JPanel buttonPanel;
    protected JButton addButton;
    protected JButton removeButton;
    protected JButton removeAllButton;
    protected ButtonListener bl = new ButtonListener();
    protected static final int KEY = 0;
    protected static final int VALUE = 1;

    public PairListFieldPanel(ObjectManager manager) {
        super(manager);
        this.setPreferredSize(new Dimension(270, 100));
    }

    protected int getObjectCount() {
        return this.tableModel.getRowCount();
    }

    @Override
    public void setFieldType(FieldType fType) {
        this.fieldType = (KVPairFieldType)fType;
        FieldType keyType = this.fieldType.getKeyType();
        FieldType valueType = this.fieldType.getValueType();
        this.tableModel = new PairFieldTableModel(0, this.fieldType.getKeyName(), this.fieldType.getValueName(), this.fieldType.allowEditKey(), this.fieldType.allowEditValue());
        this.table = new JTable(this.tableModel);
        this.table.setSelectionMode(0);
        TableColumn keyColumn = this.table.getColumnModel().getColumn(0);
        TableColumn valueColumn = this.table.getColumnModel().getColumn(1);
        keyColumn.setCellEditor(keyType.getCellEditor(this.getObjectManager().getObjectList(keyType.getJavaClass())));
        valueColumn.setCellEditor(valueType.getCellEditor(this.getObjectManager().getObjectList(valueType.getJavaClass())));
        this.scroller = new JScrollPane(this.table, 20, 31);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 1));
        this.addButton = new JButton(IconLoader.get((String)"/ordermate/images/new_icon22.png"));
        this.removeButton = new JButton(IconLoader.get((String)"/ordermate/images/delete_icon22.png"));
        this.removeAllButton = new JButton(IconLoader.get((String)"/ordermate/images/deleteall_icon22.png"));
        this.addButton.setToolTipText("Add");
        this.removeButton.setToolTipText("Remove");
        this.removeAllButton.setToolTipText("Remove All");
        this.addButton.addActionListener(this.bl);
        this.removeButton.addActionListener(this.bl);
        this.removeAllButton.addActionListener(this.bl);
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.removeButton);
        this.buttonPanel.add(this.removeAllButton);
        this.setLayout(new BorderLayout());
        this.add((Component)this.buttonPanel, "East");
        this.add((Component)this.scroller, "Center");
    }

    protected void updateButtonStates() {
        this.removeButton.setEnabled(this.table.getSelectedRow() != -1);
    }

    @Override
    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        int selRow = this.table.getSelectedRow();
        int selCol = this.table.getSelectedColumn();
        if (selRow != -1 && selCol != -1) {
            this.table.getCellEditor(selRow, selCol).stopCellEditing();
        }
        int numPairs = this.tableModel.getRowCount();
        ArrayList<Pair> pairList = new ArrayList<Pair>(numPairs);
        for (int i = 0; i < numPairs; ++i) {
            Object key = this.table.getValueAt(i, 0);
            Object val = this.table.getValueAt(i, 1);
            if (val != null && val.equals("")) {
                val = null;
            }
            pairList.add(new Pair(key, val));
        }
        return pairList;
    }

    public Object getSelectedObject() {
        int rowCount = this.table.getRowCount();
        if (rowCount == 0) {
            return null;
        }
        int selectedRow = this.table.getSelectedRow();
        if (selectedRow < 0) {
            selectedRow = this.table.getRowCount() - 1;
        }
        return this.table.getValueAt(selectedRow, 0);
    }

    @Override
    public void setValue(Object o) {
        List pairList = (List)o;
        if (pairList == null) {
            pairList = Collections.EMPTY_LIST;
        }
        this.tableModel.setRowCount(pairList.size());
        for (int i = 0; i < pairList.size(); ++i) {
            Pair pair = (Pair)pairList.get(i);
            this.tableModel.setValueAt(pair.getKey(), i, 0);
            Object val = pair.getValue();
            val = val == null ? "" : val;
            this.tableModel.setValueAt(pair.getValue(), i, 1);
        }
        this.table.setModel(this.tableModel);
        this.table.revalidate();
        this.repaint();
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.table;
    }

    public int getNumPairs() {
        return this.table != null ? this.table.getRowCount() : 0;
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == PairListFieldPanel.this.addButton) {
                PairListFieldPanel.this.tableModel.addRow(new Object[]{PairListFieldPanel.this.fieldType.getKeyType().getDefaultInitValue(), PairListFieldPanel.this.fieldType.getValueType().getDefaultInitValue()});
                if (PairListFieldPanel.this.tableModel.getRowCount() == 1) {
                    PairListFieldPanel.this.table.setRowSelectionInterval(0, 0);
                }
                PairListFieldPanel.this.updateButtonStates();
                PairListFieldPanel.this.table.revalidate();
                PairListFieldPanel.this.repaint();
            } else if (e.getSource() == PairListFieldPanel.this.removeButton) {
                TableCellEditor editor = PairListFieldPanel.this.table.getCellEditor();
                if (editor != null) {
                    editor.stopCellEditing();
                }
                Object removedObject = PairListFieldPanel.this.getSelectedObject();
                int currentRow = PairListFieldPanel.this.table.getSelectedRow();
                if (currentRow < 0) {
                    currentRow = PairListFieldPanel.this.table.getRowCount() - 1;
                }
                if (currentRow < 0) {
                    PairListFieldPanel.this.updateButtonStates();
                }
                PairListFieldPanel.this.tableModel.removeRow(currentRow);
                int numRows = PairListFieldPanel.this.tableModel.getRowCount();
                if (currentRow >= 0 && currentRow < numRows) {
                    PairListFieldPanel.this.table.setRowSelectionInterval(currentRow, currentRow);
                } else if (numRows > 0) {
                    PairListFieldPanel.this.table.setRowSelectionInterval(numRows - 1, numRows - 1);
                } else {
                    PairListFieldPanel.this.table.clearSelection();
                }
                if (removedObject != null) {
                    PairListFieldPanel.this.removeObject.emit(removedObject);
                }
                PairListFieldPanel.this.updateButtonStates();
                PairListFieldPanel.this.table.revalidate();
                PairListFieldPanel.this.repaint();
            } else if (e.getSource() == PairListFieldPanel.this.removeAllButton) {
                PairListFieldPanel.this.setValue(new ArrayList());
                PairListFieldPanel.this.updateButtonStates();
                PairListFieldPanel.this.table.revalidate();
                PairListFieldPanel.this.repaint();
            }
        }
    }

    private static class PairFieldTableModel
    extends DefaultTableModel {
        private String keyColName;
        private String valColName;
        private boolean editKey;
        private boolean editValue;

        PairFieldTableModel(int numRows, String keyCol, String valCol, boolean allowEditKey, boolean allowEditValue) {
            super(numRows, 2);
            this.keyColName = keyCol;
            this.valColName = valCol;
            this.editKey = allowEditKey;
            this.editValue = allowEditValue;
        }

        @Override
        public String getColumnName(int column) {
            return column == 0 ? this.keyColName : this.valColName;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0 ? this.editKey : this.editValue;
        }
    }
}

