/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusListener;
import java.text.ParseException;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeListener;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.types.QuantityFieldType;
import ordermate.database.config.MeasureUnit;
import ordermate.database.config.MeasureUnitContainer;
import ordermate.database.config.MeasureUnitHelper;
import ordermate.database.config.Quantity;

public class QuantityFieldPanel
extends FieldPanel<QuantityFieldType> {
    public static final String SUFFIX_LABEL_NAME = "suffixLabel";
    private QuantityFieldType fieldType;
    private SpinnerNumberModel spinnerModel;
    private JSpinner spinner;
    private JTextField textField;
    private JLabel suffixLabel;
    private MeasureUnitContainer measureUnitContainer;
    private Quantity value;

    public QuantityFieldPanel() {
        this.setLayout(new BorderLayout());
    }

    @Override
    public QuantityFieldType getFieldType() {
        return this.fieldType;
    }

    public Quantity getValue() {
        this.updateSpinner();
        return this.value;
    }

    public MeasureUnitContainer getCurrentMeasureUnitContainer() {
        return this.measureUnitContainer;
    }

    private void updateSpinner() {
        try {
            this.spinner.commitEdit();
            this.value = new Quantity(this.measureUnitContainer, this.spinnerModel.getNumber().doubleValue(), false);
        }
        catch (ParseException e) {
            this.spinner.setValue(this.spinnerModel.getValue());
        }
    }

    @Override
    public void setValue(Object o) {
        this.value = (Quantity)o;
        double val = 0.0;
        if (this.value != null) {
            val = this.value.doubleValue();
            this.measureUnitContainer = new MeasureUnitContainer((MeasureUnit)this.value.getMeasureUnit(), this.value.getMeasureContainer(), this.value.getQtyPerContainer());
            this.suffixLabel.setText(this.value.getSuffix());
        }
        Quantity max = this.fieldType.getMaxValue();
        Quantity min = this.fieldType.getMinValue();
        if (min != null && val < min.doubleValue()) {
            val = min.doubleValue();
        } else if (max != null && val > max.doubleValue()) {
            val = max.doubleValue();
        }
        this.spinner.setValue(new Double(val));
    }

    @Override
    public void setFieldType(QuantityFieldType fType) {
        this.fieldType = fType;
        Quantity minObj = this.fieldType.getMinValue();
        Quantity maxObj = this.fieldType.getMaxValue();
        Quantity defObj = this.fieldType.getDefaultValue();
        this.measureUnitContainer = defObj != null ? new MeasureUnitContainer((MeasureUnit)defObj.getMeasureUnit(), defObj.getMeasureContainer(), defObj.getQtyPerContainer()) : new MeasureUnitContainer(MeasureUnitHelper.getMeasureUnitForName((String)"units"));
        double min = minObj != null ? minObj.doubleValue() : -1.0E7;
        double max = maxObj != null ? maxObj.doubleValue() : 1.0E7;
        double def = defObj != null ? defObj.doubleValue() : 0.0;
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        if (this.spinner != null) {
            innerPanel.remove(this.spinner);
        }
        this.spinnerModel = new SpinnerNumberModel(def, min, max, 1.0);
        this.spinner = new JSpinner(this.spinnerModel);
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.spinner.getEditor();
        this.textField = editor.getTextField();
        this.textField.setColumns(20);
        this.textField.addFocusListener(new FieldPanel.InnerPrimaryFocusListener());
        JPanel northPanel = new JPanel(new BorderLayout());
        this.suffixLabel = new JLabel(this.value != null ? this.value.getSuffix() : "");
        this.suffixLabel.setName(SUFFIX_LABEL_NAME);
        this.spinner.setPreferredSize(new Dimension(70, 20));
        northPanel.add((Component)this.suffixLabel, "East");
        northPanel.add((Component)this.spinner, "Center");
        innerPanel.add((Component)northPanel, "North");
        this.add((Component)innerPanel, "North");
        this.getPrimaryComponent().addKeyListener(new FieldPanel.ControlKeyListener());
    }

    @Override
    public JComponent getPrimaryComponent() {
        return this.textField;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.spinner.setEnabled(b);
        this.textField.setEnabled(b);
        this.suffixLabel.setEnabled(b);
    }

    public void addChangeListenerToComponent(ChangeListener cl) {
        this.spinner.addChangeListener(cl);
    }

    public void addFocusListenerToComponent(FocusListener fl) {
        this.textField.addFocusListener(fl);
    }

    public JComponent getSpinnerComponent() {
        return this.spinner;
    }
}

