/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.fieldpanels;

import java.sql.Time;
import java.util.Date;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import officemate.adminkit.ObjectManager;
import officemate.adminkit.fieldpanels.FieldPanel;
import officemate.adminkit.fieldpanels.TimeSpinnerFactory;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.TimeFieldType;

public class TimeFieldPanel
extends FieldPanel {
    private JSpinner timeSpinner = TimeSpinnerFactory.create();
    private TimeFieldType fieldType;

    public TimeFieldPanel(ObjectManager manager) {
        ((JSpinner.DateEditor)this.timeSpinner.getEditor()).getTextField().addKeyListener(new FieldPanel.ControlKeyListener());
        this.add(this.timeSpinner);
    }

    public FieldType getFieldType() {
        return this.fieldType;
    }

    @Override
    public Object getValue() {
        return new Time(((Date)this.timeSpinner.getValue()).getTime());
    }

    @Override
    public void setValue(Object obj) {
        Object value = obj;
        if (value == null) {
            value = new Time(System.currentTimeMillis());
        }
        if (value instanceof Date) {
            value = new Time(((Date)value).getTime());
        }
        assert (value instanceof Time) : "Expecting java.sql.Time, found " + value.getClass().getName();
        this.timeSpinner.setValue(value);
    }

    public void setFieldType(FieldType fType) {
        this.fieldType = (TimeFieldType)fType;
        this.setValue(this.fieldType.getDefaultInitValue());
    }

    @Override
    public JComponent getPrimaryComponent() {
        JSpinner.DateEditor editor = (JSpinner.DateEditor)this.timeSpinner.getEditor();
        return editor.getTextField();
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.timeSpinner.setToolTipText(text);
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.timeSpinner.setEnabled(enabled);
    }
}

