/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.navigation;

import au.com.ordermate.application.ApplicationBlueprintArchitecture;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicComboPopup;
import officemate.adminkit.navigation.ArchitectureSuggestor;
import officemate.adminkit.navigation.FlatComboBoxUI;
import officemate.adminkit.navigation.FlatScrollBarUI;
import officemate.adminkit.navigation.OfficeMateTheme;
import officemate.adminkit.state.statebuilder.OfficeMateBlueprint;
import ordermate.gui.autosuggestor.DynamicSuggestionComboHandler;
import ordermate.gui.autosuggestor.Suggestor;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class ApplicationStructureSearcherGui
extends JPanel {
    private final Color BACK_1 = OfficeMateTheme.STATE_SELECTION_BG;
    private final Color BACK_2 = OfficeMateTheme.STATE_SELECTION_LIGHT;
    private final Color HIGHLIGHT = OfficeMateTheme.STATE_HIGHLIGHT;
    Signal<ApplicationStateBlueprint, ?, ?, ?, ?> goTo = Signals.createSignal(ApplicationStateBlueprint.class, (String)"selection");
    private JComboBox textComboBox;
    private ComboBoxModel model;
    private ArchitectureSuggestor suggestor = new ArchitectureSuggestor();
    private DynamicSuggestionComboHandler comboHandler;

    ApplicationStructureSearcherGui() {
        super(new BorderLayout());
        this.setupComponents();
    }

    private void setupComponents() {
        this.model = new EventComboBoxModel(this.suggestor.getSuggestions());
        this.textComboBox = new JComboBox(this.model){

            @Override
            public Dimension getSize() {
                return this.getPreferredSize();
            }
        };
        this.textComboBox.setForeground(Color.RED);
        FlatComboBoxUI UI = new FlatComboBoxUI(OfficeMateTheme.STATE_SELECTION_BG, OfficeMateTheme.STATE_LOWLIGHT);
        this.textComboBox.setUI(UI);
        this.textComboBox.setEditable(true);
        this.textComboBox.setOpaque(false);
        this.textComboBox.setRenderer(new OfficeMateStateComboRenderer());
        this.textComboBox.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.textComboBox.setName("applicationSearcher");
        this.textComboBox.setPreferredSize(new Dimension(400, 40));
        BasicComboPopup popup = (BasicComboPopup)this.textComboBox.getUI().getAccessibleChild(this.textComboBox, 0);
        popup.setOpaque(false);
        JScrollPane scrolly = (JScrollPane)popup.getUI().getAccessibleChild(popup, 0);
        scrolly.getVerticalScrollBar().setUI(new FlatScrollBarUI());
        scrolly.getVerticalScrollBar().setBackground(this.BACK_2);
        scrolly.setOpaque(false);
        scrolly.getViewport().setOpaque(false);
        scrolly.setHorizontalScrollBarPolicy(31);
        this.textComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("comboBoxEdited".equals(e.getActionCommand())) {
                    ApplicationStructureSearcherGui.this.closeOff();
                }
            }
        });
        this.comboHandler = new DynamicSuggestionComboHandler((Suggestor)this.suggestor, this.textComboBox, false);
        this.comboHandler.selectionMade.connect((Object)this, "gotSelectionMade");
        this.add((Component)this.textComboBox, "Center");
        JLabel magnifyingGlass = new JLabel(IconLoader.get((String)"/officemate/images/search.png"));
        magnifyingGlass.setBorder(new EmptyBorder(0, 0, 0, 10));
        this.add((Component)magnifyingGlass, "West");
        this.setBorder(new EmptyBorder(10, 20, 10, 20));
    }

    public void gotSelectionMade(Object value) {
        if (value != null && value instanceof OfficeMateBlueprint) {
            this.goTo.emit((Object)((ApplicationStateBlueprint)value));
        }
        this.closeOff();
    }

    public void setArchitecture(ApplicationBlueprintArchitecture architecture) {
        this.suggestor.setArchitecture(architecture);
    }

    public void closeOff() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ApplicationStructureSearcherGui.this.textComboBox.isPopupVisible()) {
                    ApplicationStructureSearcherGui.this.textComboBox.hidePopup();
                }
            }
        });
    }

    public void reset() {
        this.textComboBox.setSelectedItem(null);
    }

    private class OfficeMateStateComboRenderer
    extends JLabel
    implements ListCellRenderer {
        OfficeMateStateComboRenderer() {
            this.setOpaque(true);
            this.setPreferredSize(new Dimension(300, 40));
            this.setBorder(new EmptyBorder(0, 10, 0, 0));
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (isSelected) {
                this.setBackground(ApplicationStructureSearcherGui.this.HIGHLIGHT);
                this.setForeground(ApplicationStructureSearcherGui.this.BACK_1);
            } else {
                if (index % 2 == 0) {
                    this.setBackground(ApplicationStructureSearcherGui.this.BACK_1);
                } else {
                    this.setBackground(ApplicationStructureSearcherGui.this.BACK_2);
                }
                this.setForeground(ApplicationStructureSearcherGui.this.HIGHLIGHT);
            }
            ApplicationStateBlueprint bp = (ApplicationStateBlueprint)value;
            this.setText(bp.toString());
            return this;
        }
    }
}

