/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.navigation;

import au.com.ordermate.application.ApplicationSecurity;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.ApplicationStructure;
import au.com.ordermate.application.StateBuildCondition;
import au.com.ordermate.gui.DragScrollListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import officemate.adminkit.navigation.FlatScrollBarUI;
import officemate.adminkit.navigation.FlatTreeUI;
import officemate.adminkit.navigation.OfficeMateStateRenderer;
import officemate.adminkit.navigation.OfficeMateTheme;
import officemate.adminkit.navigation.OnReleaseMouseListener;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

class ApplicationStructureSelector
implements TreeSelectionListener {
    private JLabel rootLabel;
    private JPanel holder;
    private JTree tree;
    private TreeModel treeModel;
    private final ApplicationStructure structure;
    private ApplicationStateBlueprint rootBlueprint;
    private ApplicationSecurity security;
    Signal stateSelected = Signals.createSignal(ApplicationStateBlueprint.class, (String)"Selected");
    private boolean selecting = false;

    ApplicationStructureSelector(ApplicationStructure structure, ApplicationStateBlueprint rootBlueprint, ApplicationSecurity security) {
        this.structure = structure;
        this.rootBlueprint = rootBlueprint;
        this.security = security;
        this.setupComponents();
    }

    public JComponent getGui() {
        return this.holder;
    }

    public void reload() {
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(this.rootBlueprint, true);
        this.addAllChildren(rootNode);
        this.treeModel = new DefaultTreeModel(rootNode);
        this.tree.setModel(this.treeModel);
    }

    private void addAllChildren(DefaultMutableTreeNode node) {
        for (String nextChildKey : ((ApplicationStateBlueprint)node.getUserObject()).getChildStateKeys()) {
            ApplicationStateBlueprint childBlueprint = this.structure.getArchitecture().getBlueprint(nextChildKey);
            boolean stateConditionsMet = true;
            for (StateBuildCondition condition : childBlueprint.getStateConditions()) {
                stateConditionsMet = stateConditionsMet && condition.checkBuildCondition();
            }
            if (!stateConditionsMet || !this.security.stateIsAccessable(childBlueprint.getKey(), this.security.getUser())) continue;
            List childKeys = childBlueprint.getChildStateKeys();
            DefaultMutableTreeNode nextChild = new DefaultMutableTreeNode(childBlueprint, !childKeys.isEmpty());
            node.add(nextChild);
            if (childBlueprint.isSelfContained() || childKeys.isEmpty()) continue;
            this.addAllChildren(nextChild);
        }
    }

    private void setupComponents() {
        MouseListener[] listeners;
        this.tree = new JTree();
        this.reload();
        this.tree.setRootVisible(false);
        this.tree.setBackground(OfficeMateTheme.STATE_SELECTION_BG);
        this.tree.setBorder(new EmptyBorder(0, 20, 0, 0));
        this.tree.setCellRenderer(new OfficeMateStateRenderer());
        this.tree.setToggleClickCount(1);
        FlatTreeUI ui = new FlatTreeUI();
        this.tree.setUI(ui);
        ui.setRightChildIndent(10);
        this.tree.addTreeSelectionListener(this);
        this.holder = new JPanel(new BorderLayout());
        this.holder.setOpaque(false);
        this.rootLabel = new JLabel(this.rootBlueprint.getStateTitle());
        this.rootLabel.setFont(this.rootLabel.getFont().deriveFont(0, 18.0f));
        this.rootLabel.setForeground(OfficeMateTheme.STATE_HIGHLIGHT);
        this.rootLabel.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.holder.add((Component)this.rootLabel, "North");
        JScrollPane scrolly = new JScrollPane(this.tree);
        scrolly.setBorder(null);
        scrolly.setHorizontalScrollBarPolicy(31);
        scrolly.setVerticalScrollBarPolicy(22);
        scrolly.getVerticalScrollBar().setUI(new FlatScrollBarUI());
        scrolly.getVerticalScrollBar().setBackground(this.tree.getBackground());
        for (MouseListener listener : listeners = this.tree.getMouseListeners()) {
            this.tree.removeMouseListener(listener);
        }
        OnReleaseMouseListener onReleaseListener = new OnReleaseMouseListener(listeners);
        this.tree.addMouseListener(onReleaseListener);
        this.tree.addMouseMotionListener(onReleaseListener);
        DragScrollListener dsl = new DragScrollListener((Component)this.tree);
        dsl.setDraggableElements(2);
        this.tree.addMouseListener((MouseListener)dsl);
        this.tree.addMouseMotionListener((MouseMotionListener)dsl);
        scrolly.setOpaque(false);
        scrolly.getViewport().setOpaque(false);
        this.holder.add((Component)scrolly, "Center");
    }

    @Override
    public void valueChanged(TreeSelectionEvent event) {
        DefaultMutableTreeNode node;
        if (this.selecting) {
            return;
        }
        TreePath oldPath = event.getOldLeadSelectionPath();
        TreePath newPath = event.getNewLeadSelectionPath();
        this.showInTree(oldPath, newPath);
        if (newPath != null && newPath.getLastPathComponent() != null && !newPath.equals(oldPath) && (node = (DefaultMutableTreeNode)newPath.getLastPathComponent()).isLeaf()) {
            this.selecting = true;
            this.stateSelected.emit(node.getUserObject());
            this.selecting = false;
        }
    }

    private void showInTree(TreePath oldPath, TreePath newPath) {
        while (oldPath != null && !oldPath.isDescendant(newPath)) {
            this.tree.collapsePath(oldPath);
            oldPath = oldPath.getParentPath();
        }
        if (newPath != null && !newPath.equals(this.tree.getSelectionPath())) {
            this.tree.setSelectionPath(newPath);
        }
    }

    public void setSelectedState(ApplicationStateBlueprint blueprint) {
        TreePath oldPath = this.tree.getSelectionPath();
        Stack<ApplicationStateBlueprint> bps = new Stack<ApplicationStateBlueprint>();
        ApplicationStateBlueprint nextBp = blueprint;
        while (nextBp.getParentStateKey() != null) {
            bps.push(nextBp);
            nextBp = this.structure.getArchitecture().getBlueprint(nextBp.getParentStateKey());
        }
        TreeModel model = this.tree.getModel();
        ArrayList<DefaultMutableTreeNode> path = new ArrayList<DefaultMutableTreeNode>(bps.size() + 1);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)model.getRoot();
        path.add(node);
        block1: while (!bps.isEmpty()) {
            ApplicationStateBlueprint next = (ApplicationStateBlueprint)bps.pop();
            for (int i = 0; i < node.getChildCount(); ++i) {
                if (((DefaultMutableTreeNode)node.getChildAt(i)).getUserObject() != next) continue;
                node = (DefaultMutableTreeNode)node.getChildAt(i);
                path.add(node);
                continue block1;
            }
        }
        TreePath newPath = new TreePath(path.toArray());
        this.showInTree(oldPath, newPath);
    }
}

