/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.navigation;

import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import officemate.adminkit.navigation.OfficeMateTheme;

class OfficeMateStateRenderer
implements TreeCellRenderer {
    private JLabel topLevel;
    private JLabel midLevel;
    private JLabel lowerLevel;
    private Color HIGHLIGHT = OfficeMateTheme.STATE_HIGHLIGHT;
    private Color SELECTED = new Color(233, 238, 234);
    private Color COLOR_UNSELECTED = new Color(153, 169, 182);

    OfficeMateStateRenderer() {
        Dimension dim = new Dimension(300, 30);
        this.topLevel = new JLabel();
        this.topLevel.setPreferredSize(dim);
        this.topLevel.setMinimumSize(dim);
        this.midLevel = new JLabel(IconLoader.get((String)"/officemate/images/indent.png"));
        this.midLevel.setHorizontalTextPosition(4);
        this.midLevel.setHorizontalAlignment(2);
        this.midLevel.setPreferredSize(dim);
        this.midLevel.setMinimumSize(dim);
        this.midLevel.setIconTextGap(6);
        this.lowerLevel = new JLabel(IconLoader.get((String)"/officemate/images/indent2.png"));
        this.lowerLevel.setHorizontalTextPosition(4);
        this.lowerLevel.setHorizontalAlignment(2);
        this.lowerLevel.setPreferredSize(dim);
        this.lowerLevel.setMinimumSize(dim);
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        ApplicationStateBlueprint blueprint = (ApplicationStateBlueprint)node.getUserObject();
        JLabel renderer = node.getUserObjectPath().length == 2 ? this.topLevel : (node.getUserObjectPath().length == 3 ? this.midLevel : this.lowerLevel);
        renderer.setText(blueprint.getStateTitle());
        if (selected && leaf) {
            renderer.setForeground(this.SELECTED);
            renderer.setFont(renderer.getFont().deriveFont(1));
        } else {
            renderer.setForeground(expanded ? this.HIGHLIGHT : this.COLOR_UNSELECTED);
            renderer.setFont(renderer.getFont().deriveFont(0));
        }
        return renderer;
    }
}

