/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.navigation;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.application.ApplicationBlueprintArchitecture;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.ApplicationStructure;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.DummyGUIHandler;
import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.persistence.Executable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import officemate.adminkit.navigation.ApplicationStructureSearcher;
import officemate.adminkit.navigation.ApplicationStructureSelector;
import officemate.adminkit.navigation.FlatButtonUI;
import officemate.adminkit.navigation.OfficeMateTheme;
import officemate.adminkit.navigation.OnlineSyncDialog;
import officemate.adminkit.navigation.PointyToolTip;
import officemate.screens.integration.OfficeMateOnlineOrdersGuiUtils;
import ordermate.OrderMate;
import ordermate.integration.humpy.HumpBackSync;
import ordermate.integration.onlinesales.OnlineOrderIntegrator;
import ordermate.services.misc.CallMethodOnClassExecutable;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class OfficemateNavigation
implements ActionListener {
    private static final int ROOT_WIDTH = 60;
    private static final int STATE_WIDTH = 250;
    private static final int HEIGHT = 768;
    public final Signal<ApplicationStateBlueprint, ?, ?, ?, ?> stateSelected = Signals.createSignal(ApplicationStateBlueprint.class, (String)"print");
    public static final Signal navigationRootClicked = Signals.createSignal();
    private JPanel navigationPanel;
    private JPanel rootsPanel;
    private JPanel secondLevelPanel;
    private ApplicationStructureSelector stateSelector;
    private ApplicationStructureSearcher structureSearcher;
    private final ApplicationStructure structure;
    private FlatButtonUI rootUI;
    private List<JButton> rootButtons;
    private JButton lastRoot;
    private JButton onlineMenuSync;
    private static final Semaphore syncLatch = new Semaphore(1);
    private static final int REFRESH_TIME_HH_IMPORT_ICON = 300000;
    private static final int INITAL_DELAY_HH_IMPORT = 5000;
    public static final String ONLINE_MENU_SYNC_BUTTON_NAME = "onlineMenuSync";
    private static final int REFRESH_TIME_HH_IMPORT_TOOLTIP = 900000;
    private boolean hungryHungryOrderExist = false;
    private ApplicationStateBlueprint lastState;

    public OfficemateNavigation(ApplicationStructure structure) {
        this.structure = structure;
        this.setupComponents();
    }

    private void setupComponents() {
        this.navigationPanel = new JPanel();
        this.navigationPanel.setLayout(new BorderLayout());
        this.rootsPanel = new JPanel();
        this.rootsPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.rootsPanel.setLayout(new BoxLayout(this.rootsPanel, 1));
        this.rootsPanel.setBackground(OfficeMateTheme.ROOT_BG);
        this.navigationPanel.add((Component)this.rootsPanel, "West");
        this.secondLevelPanel = new JPanel(new BorderLayout());
        this.secondLevelPanel.setBackground(OfficeMateTheme.STATE_SELECTION_BG);
        this.secondLevelPanel.setPreferredSize(new Dimension(250, 768));
        this.navigationPanel.add((Component)this.secondLevelPanel, "Center");
        this.navigationPanel.setPreferredSize(new Dimension(310, 768));
        this.navigationPanel.setMinimumSize(new Dimension(310, 768));
        this.structureSearcher = new ApplicationStructureSearcher(this.structure.getArchitecture());
        this.secondLevelPanel.add((Component)this.structureSearcher.getGui(), "North");
        this.structureSearcher.getGui().setBackground(OfficeMateTheme.STATE_SELECTION_BG);
        this.structureSearcher.stateSelected.connect((Object)this, "gotStateSelected");
        this.rootButtons = new ArrayList<JButton>();
        this.rootUI = new FlatButtonUI();
        this.setupRoots();
    }

    private void setupRoots() {
        int offset = 0;
        ApplicationBlueprintArchitecture architecture = this.structure.getArchitecture();
        for (Object rootKey : architecture.getRootBlueprintKeys()) {
            this.rootsPanel.add(Box.createVerticalStrut(10));
            ApplicationStateBlueprint blueprint = architecture.getBlueprint((String)rootKey);
            if (offset == architecture.getRootBlueprintKeys().size() - 2) {
                this.rootsPanel.add(Box.createVerticalGlue());
                if (OnlineOrderIntegrator.getInstance().isHungryHungryIntegrationEnabled() || OnlineOrderIntegrator.getInstance().isThirdPartyOnlineOrderingEnabled()) {
                    this.createOnlineMenuSyncButton();
                }
            }
            ImageIcon icon = blueprint.getStateIcon();
            String tooltip = blueprint.getStateTitle() + (blueprint.getStateTooltip() == null ? "" : ": " + blueprint.getStateTooltip());
            JButton rootButton = this.setupRootButton(icon, tooltip, blueprint, true);
            this.rootsPanel.add(rootButton);
            this.rootButtons.add(rootButton);
            ++offset;
        }
    }

    private void createOnlineMenuSyncButton() {
        this.onlineMenuSync = this.setupRootButton(OfficeMateOnlineOrdersGuiUtils.getStandardOnlineMenuSyncIcon(), OfficeMateOnlineOrdersGuiUtils.getTooltipForOnlineMenuSyncIcon(), null, false);
        this.onlineMenuSync.setName(ONLINE_MENU_SYNC_BUTTON_NAME);
        this.onlineMenuSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new OnlineSyncDialog().start((2 & e.getModifiers()) == 2);
                OfficemateNavigation.this.refreshSyncIcon(true);
            }
        });
        this.rootsPanel.add(this.onlineMenuSync);
        this.createTimerToRefreshOnlineMenuSync();
        this.createTimerForOnlineMenuSyncTipText();
    }

    private void createTimerToRefreshOnlineMenuSync() {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                OfficemateNavigation.this.refreshSyncIcon(false);
            }
        }, 5000L, 300000L);
    }

    private void createTimerForOnlineMenuSyncTipText() {
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                OfficemateNavigation.this.refreshHungryHungryTooltipText();
            }
        }, 5000L, 900000L);
    }

    private void refreshSyncIcon(boolean omitMenuRevisionChange) {
        if (syncLatch.tryAcquire()) {
            try {
                if (this.isRecentHungryHungryOrderExist() || OnlineOrderIntegrator.getInstance().isThirdPartyOnlineOrderingEnabled()) {
                    final boolean menuRevisionChanged = omitMenuRevisionChange ? true : OnlineOrderIntegrator.getInstance().isRevisionChanged();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String text = null;
                            if (menuRevisionChanged) {
                                Long millis = OnlineOrderIntegrator.getInstance().timeLeft();
                                if (millis != null) {
                                    if (millis > 0L) {
                                        text = millis / 60000L + " min";
                                        OfficemateNavigation.this.onlineMenuSync.setText(text);
                                        OfficemateNavigation.this.onlineMenuSync.setIcon(OfficeMateOnlineOrdersGuiUtils.getOnlineMenuSyncIcon(true));
                                    } else {
                                        OnlineOrderIntegrator.getInstance().syncThirdPartyOnlineMenu((GuiHandler)new DummyGUIHandler(), true, true, true);
                                        OfficemateNavigation.this.onlineMenuSync.setText(null);
                                        OfficemateNavigation.this.onlineMenuSync.setIcon(OfficeMateOnlineOrdersGuiUtils.getOnlineMenuSyncIcon(false));
                                    }
                                }
                            } else {
                                OfficemateNavigation.this.onlineMenuSync.setText(text);
                                OfficemateNavigation.this.onlineMenuSync.setIcon(OfficeMateOnlineOrdersGuiUtils.getOnlineMenuSyncIcon(menuRevisionChanged));
                            }
                            OfficemateNavigation.this.onlineMenuSync.validate();
                            OfficemateNavigation.this.onlineMenuSync.repaint();
                        }
                    });
                }
            }
            catch (Exception ex) {
                OrderMate.LOG.warn("Cannot set the HH icon", (Throwable)ex);
            }
            finally {
                syncLatch.release();
            }
        }
    }

    private void refreshHungryHungryTooltipText() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OfficemateNavigation.this.onlineMenuSync.setToolTipText(OfficeMateOnlineOrdersGuiUtils.getTooltipForOnlineMenuSyncIcon());
            }
        });
    }

    private boolean isRecentHungryHungryOrderExist() {
        if (!this.hungryHungryOrderExist) {
            this.hungryHungryOrderExist = OnlineOrderIntegrator.getInstance().hasRecentHungryHungryOrder();
        }
        return this.hungryHungryOrderExist;
    }

    private void syncMenuWithHumpy() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                CallMethodOnClassExecutable humpySyncExecutable = new CallMethodOnClassExecutable(HumpBackSync.class.getCanonicalName(), new String[]{"getInstance", "performSync"});
                Boolean result = (Boolean)PersistenceManager.getServerConnection().runSync((Executable)humpySyncExecutable);
                if (result == null || Boolean.FALSE.equals(result)) {
                    OrderMateLog.LOG.error("Humpy Sync is NOT performed,please check ServerMate logs!");
                } else {
                    OrderMateLog.LOG.info("Humpy Sync request is successful sent!");
                }
            }
        }).start();
    }

    private JButton setupRootButton(ImageIcon icon, String tooltip, ApplicationStateBlueprint blueprint, boolean makeGrey) {
        JButton rootButton = new JButton(makeGrey ? this.makeGrey(icon) : icon){

            @Override
            public JToolTip createToolTip() {
                PointyToolTip tip = new PointyToolTip();
                tip.setComponent(this);
                return tip;
            }

            @Override
            public Point getToolTipLocation(MouseEvent e) {
                return new Point(this.getWidth(), 20);
            }
        };
        rootButton.setUI(this.rootUI);
        rootButton.setBorderPainted(false);
        rootButton.setForeground(Color.LIGHT_GRAY);
        rootButton.setToolTipText(tooltip);
        rootButton.setBackground(Color.RED);
        rootButton.setOpaque(false);
        rootButton.setFocusPainted(false);
        rootButton.setHorizontalAlignment(0);
        rootButton.setHorizontalTextPosition(0);
        rootButton.setPreferredSize(new Dimension(60, 60));
        rootButton.setMinimumSize(new Dimension(60, 60));
        rootButton.setMaximumSize(new Dimension(60, 60));
        if (blueprint != null) {
            rootButton.setActionCommand(blueprint.getKey());
            rootButton.addActionListener(this);
            rootButton.setName(blueprint.getStateTitle());
        }
        return rootButton;
    }

    public void rootClicked(ApplicationStateBlueprint blueprint) {
        if (this.stateSelector != null) {
            this.stateSelector.stateSelected.disconnect((Object)this);
            this.secondLevelPanel.remove(this.stateSelector.getGui());
        }
        if (blueprint.getChildStateKeys().isEmpty()) {
            this.secondLevelPanel.validate();
            this.secondLevelPanel.repaint();
            this.gotStateSelected(blueprint);
            return;
        }
        this.stateSelector = new ApplicationStructureSelector(this.structure, blueprint, GuiApp.getAppComplex().getApplicationSecurity());
        this.secondLevelPanel.add((Component)this.stateSelector.getGui(), "Center");
        this.secondLevelPanel.validate();
        this.secondLevelPanel.repaint();
        this.stateSelector.stateSelected.connect((Object)this, "gotStateSelected");
    }

    public void gotStateSelected(ApplicationStateBlueprint blueprint) {
        if (blueprint != null && (blueprint.isSelfContained() || blueprint.getChildStateKeys().isEmpty()) || blueprint != null && blueprint.getKey().equals("Favourites")) {
            this.ensureHighlightedInUI(blueprint);
            if (this.lastState != blueprint) {
                this.lastState = blueprint;
                if ("Logout".equals(blueprint.getKey()) && OnlineOrderIntegrator.getInstance().shouldWarnForHHMenuImport()) {
                    OfficeMateOnlineOrdersGuiUtils.warnForOnlineMenuSync();
                }
                this.stateSelected.emit((Object)blueprint);
            }
        }
    }

    private void ensureHighlightedInUI(ApplicationStateBlueprint blueprint) {
        ApplicationBlueprintArchitecture architecture = this.structure.getArchitecture();
        ApplicationStateBlueprint parent = architecture.getBlueprint(blueprint.getKey());
        while (parent.getParentStateKey() != null) {
            parent = architecture.getBlueprint(parent.getParentStateKey());
        }
        for (JButton button : this.rootButtons) {
            if (!parent.getKey().equals(button.getActionCommand())) continue;
            boolean rootChange = this.lastRoot != button;
            this.setSelectedRootButton(button);
            if (!rootChange) break;
            this.rootClicked(parent);
            break;
        }
        if (parent != blueprint) {
            this.stateSelector.setSelectedState(blueprint);
        }
    }

    public void gotUserChanged() {
        if (this.structureSearcher != null) {
            this.structureSearcher.reload();
        }
        if (this.stateSelector != null) {
            this.stateSelector.reload();
        }
    }

    public Component getComponent() {
        return this.navigationPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton rootButton = (JButton)e.getSource();
        ApplicationStateBlueprint blueprint = this.setSelectedRootButton(rootButton);
        this.rootClicked(blueprint);
        this.rootsPanel.validate();
        this.rootsPanel.repaint();
        navigationRootClicked.emit();
    }

    private ApplicationStateBlueprint setSelectedRootButton(JButton rootButton) {
        if (this.lastRoot != null) {
            ImageIcon rootIcon = this.structure.getArchitecture().getBlueprint(this.lastRoot.getActionCommand()).getStateIcon();
            this.lastRoot.setIcon(this.makeGrey(rootIcon));
        }
        this.lastRoot = rootButton;
        for (JButton root : this.rootButtons) {
            root.setOpaque(false);
        }
        rootButton.setOpaque(true);
        ApplicationStateBlueprint blueprint = this.structure.getArchitecture().getBlueprint(rootButton.getActionCommand());
        rootButton.setIcon(blueprint.getStateIcon());
        return blueprint;
    }

    private Icon makeGrey(ImageIcon icon) {
        return new ImageIcon(new ImageHelper().tintImage(icon.getImage(), Color.LIGHT_GRAY, 1.0f));
    }

    public void setSelectedObject(ApplicationStateBlueprint stateToSelect) {
        this.gotStateSelected(stateToSelect);
    }

    public int getPreferredWidth() {
        return 310;
    }

    public void reloadSubstates() {
        if (this.stateSelector != null) {
            this.stateSelector.reload();
        }
    }
}

