/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.navigation;

import au.com.ordermate.gui.GuiHandler;
import au.com.ordermate.guicore.task.AbstractGuiTask;
import au.com.ordermate.guicore.task.AbstractTask;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OfficeMateGuiHandler;
import ordermate.integration.onlinesales.OnlineOrderIntegrator;

class OnlineSyncDialog
implements ActionListener {
    private boolean usesHH = OnlineOrderIntegrator.getInstance().isHungryHungryIntegrationEnabled();
    private boolean usesOorby = OnlineOrderIntegrator.getInstance().isThirdPartyOnlineOrderingEnabled();
    private JCheckBox menuCheck;
    private JCheckBox tablesCheck;
    private JCheckBox siteCheck;
    private JButton sendButton;
    private JLabel descLabel;
    private JButton hungryHungryButton;
    private JPanel panel;
    boolean advanced = false;

    OnlineSyncDialog() {
    }

    public void start(boolean advanced) {
        this.advanced = advanced;
        if (this.usesHH && !this.usesOorby) {
            OnlineOrderIntegrator.getInstance().browseHHMenuImportURL();
            OnlineOrderIntegrator.getInstance().updateRevisionCount();
            return;
        }
        this.panel = new JPanel();
        this.panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        if (advanced) {
            this.panel.setLayout(new GridLayout(7, 1));
        } else {
            this.panel.setLayout(new GridLayout(4, 1));
        }
        this.panel.getInsets().set(5, 5, 5, 5);
        this.panel.setAlignmentY(0.5f);
        this.descLabel = new JLabel("<html>This will send any recent changes to Online<br>Integrations such as Doshii and Deliverect</html>");
        this.panel.add(this.descLabel);
        if (this.usesOorby) {
            this.menuCheck = this.makeCheckBox("Send Menu - Items, options, sections, etc");
            this.tablesCheck = this.makeCheckBox("Send Tables - Table sections and tables");
            this.siteCheck = this.makeCheckBox("Send Site - Terminals, Users and price adjustments");
            this.sendButton = new JButton("Send to Online Platforms Now");
            this.sendButton.addActionListener(this);
            this.panel.add(this.sendButton);
            if (this.usesHH) {
                this.panel.add(new JSeparator(0));
            }
        }
        if (this.usesHH) {
            this.hungryHungryButton = new JButton("Visit HungryHungry to Update your menu");
            this.hungryHungryButton.addActionListener(this);
            OnlineOrderIntegrator.getInstance().updateRevisionCount();
            this.panel.add(this.hungryHungryButton);
        }
        Dialogs.getOkCancelDialogBuilder(this.panel).setTitle("Send Menu to Online Platforms").doPack().hideCancel().doShow();
    }

    private JCheckBox makeCheckBox(String title) {
        JCheckBox checkbox = new JCheckBox(title);
        if (this.advanced) {
            this.panel.add(checkbox);
        }
        checkbox.setSelected(true);
        return checkbox;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.sendButton == e.getSource()) {
            Dialogs.showProgressDialog((AbstractTask)new AbstractGuiTask(){

                protected void doGuiTask() throws Exception {
                    OnlineOrderIntegrator.getInstance().syncThirdPartyOnlineMenu((GuiHandler)new OfficeMateGuiHandler(), OnlineSyncDialog.this.menuCheck.isSelected(), OnlineSyncDialog.this.tablesCheck.isSelected(), OnlineSyncDialog.this.siteCheck.isSelected());
                    this.emitProgress();
                }

                public String getName() {
                    return "Sending...";
                }

                protected int getTotalSubTasks() {
                    return 1;
                }
            });
        } else if (this.hungryHungryButton == e.getSource()) {
            OnlineOrderIntegrator.getInstance().browseHHMenuImportURL();
            OnlineOrderIntegrator.getInstance().updateRevisionCount();
        }
    }
}

