/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.print;

import au.com.ordermate.util.Assert;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import officemate.adminkit.print.AbstractTableReportPrintable;
import officemate.adminkit.print.ReportPrintParams;
import ordermate.database.stock.StockSupplier;

public class JTableReportPrintable
extends AbstractTableReportPrintable
implements Printable {
    JTable table;
    TableColumnModel colModel;
    int numRows;
    int numColumns;
    int totalColWidth;
    int maxRow;
    int minRow;
    int spaceForRowsP1;
    int spaceForRows;
    int numRowsPerPage;
    int numRowsPerPageP1;
    private Object[] colTotals;

    public JTableReportPrintable(JTable theTable, String theTitle, String theSubTitle, int theFontPtSize) {
        this(theTable, theTitle, theSubTitle, theFontPtSize, null, false);
    }

    public JTableReportPrintable(JTable theTable, String theTitle, String theSubTitle, int theFontPtSize, Object[] theColTotals, boolean showLogo) {
        super(new ReportPrintParams().setTitle(theTitle).setSubtitle(theSubTitle).setFontSize(theFontPtSize), showLogo);
        this.table = theTable;
        this.colTotals = theColTotals;
    }

    public JTableReportPrintable(JTable theTable, String theTitle, String theSubTitle, int theFontPtSize, Object[] theColTotals, StockSupplier theSupplier, boolean showLogo) {
        super(new ReportPrintParams().setTitle(theTitle).setSubtitle(theSubTitle).setFontSize(theFontPtSize), showLogo);
        this.table = theTable;
        this.supplier = theSupplier;
        this.colTotals = theColTotals;
    }

    @Override
    protected boolean setupVariables(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        super.setupVariables(graphics, pageFormat, pageIndex);
        this.colModel = this.table.getColumnModel();
        this.numColumns = this.colModel.getColumnCount();
        this.numRows = this.table.getRowCount();
        this.totalColWidth = this.colModel.getTotalColumnWidth();
        this.spaceForRowsP1 = this.imageableHeight - this.headerHeight - this.footerHeight;
        this.spaceForRows = this.imageableHeight - this.footerHeight;
        this.numRowsPerPageP1 = this.spaceForRowsP1 / this.rowHeight;
        this.numRowsPerPage = this.spaceForRows / this.rowHeight;
        if (this.numRows <= this.numRowsPerPageP1) {
            this.numPages = 1;
        } else {
            int nonP1Rows = this.numRows - this.numRowsPerPageP1;
            this.numPages = 1 + nonP1Rows / this.numRowsPerPage;
            if (nonP1Rows % this.numRowsPerPage != 0) {
                ++this.numPages;
            }
        }
        if (pageIndex == 0) {
            this.minRow = 0;
            this.maxRow = this.numRowsPerPageP1;
        } else {
            this.minRow = this.numRowsPerPageP1 + (pageIndex - 1) * this.numRowsPerPage;
            this.maxRow = this.numRowsPerPageP1 + pageIndex * this.numRowsPerPage;
        }
        if (this.minRow >= this.numRows) {
            return false;
        }
        if (this.maxRow > this.numRows) {
            this.maxRow = this.numRows;
        }
        return true;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
        if (!this.setupVariables(graphics, pageFormat, pageIndex)) {
            return 1;
        }
        if (pageIndex == 0) {
            this.printTitle(this.getTitle());
            this.printSubTitle(this.getSubtitle());
            this.printLine();
            this.printBusinessHeader();
            if (this.showLogo) {
                this.printLogo();
            }
        }
        this.printLine();
        this.printColumnHeaders();
        this.printLine();
        this.printRows(this.minRow, this.maxRow);
        if (this.colTotals != null && pageIndex == this.numPages - 1) {
            this.printLine();
            this.printColumnTotals();
            this.printLine();
        }
        this.printPageNumber(pageIndex);
        return 0;
    }

    private void printColumnHeaders() {
        this.yPos += this.colHeadHeight + 3;
        this.g.setFont(this.colHeadFont);
        for (int i = 0; i < this.numColumns; ++i) {
            TableColumn col = this.colModel.getColumn(i);
            int colWidth = col.getWidth();
            double colPercent = (double)colWidth / (double)this.totalColWidth;
            String str = col.getHeaderValue().toString();
            str = this.clipString(str, colWidth, this.g.getFontMetrics());
            this.g.drawString(str, this.xPos, this.yPos);
            this.xPos += (int)((double)this.imageableWidth * colPercent);
        }
        this.xPos = 0;
    }

    private void printColumnTotals() {
        Assert.isEqual((int)this.numColumns, (int)this.colTotals.length, (String)"Unexpected number of columns in the report");
        this.yPos += this.colHeadHeight + 3;
        this.xPos = 0;
        this.g.setFont(this.colHeadFont);
        for (int i = 0; i < this.numColumns; ++i) {
            TableColumn col = this.colModel.getColumn(i);
            int colWidth = col.getWidth();
            double colPercent = (double)colWidth / (double)this.totalColWidth;
            String totalVal = this.colTotals[i] != null ? String.valueOf(this.colTotals[i]) : "";
            this.g.drawString(totalVal, this.xPos, this.yPos);
            this.xPos += (int)((double)this.imageableWidth * colPercent);
        }
    }

    private void printRows(int theMinRow, int theMaxRow) {
        this.g.setFont(this.normalFont);
        this.yPos += this.rowHeight;
        for (int i = theMinRow; i < theMaxRow; ++i) {
            this.printRow(i);
        }
    }

    private void printRow(int row) {
        TableColumnModel theColModel = this.table.getColumnModel();
        int theTotalColWidth = theColModel.getTotalColumnWidth();
        TableModel tableModel = this.table.getModel();
        this.xPos = 0;
        int numOfColumns = theColModel.getColumnCount();
        for (int col = 0; col < numOfColumns; ++col) {
            MatteBorder matteBorder;
            JComponent jCell;
            Border cellBorder;
            TableColumn column = theColModel.getColumn(col);
            int colWidth = column.getWidth();
            double colPercent = (double)colWidth / (double)theTotalColWidth;
            Object value = tableModel.getValueAt(row, col);
            Font cellFont = this.table.getCellRenderer(row, col).getTableCellRendererComponent(this.table, value, false, false, row, col).getFont();
            Font fontToUse = new Font(cellFont.getName(), cellFont.getStyle(), this.normalFont.getSize());
            this.g.setFont(fontToUse);
            String str = value != null ? value.toString() : "";
            Component cell = this.table.getCellRenderer(row, col).getTableCellRendererComponent(this.table, value, false, false, row, col);
            if (cell instanceof JLabel) {
                str = ((JLabel)cell).getText();
            }
            str = this.clipString(str, colWidth, this.g.getFontMetrics());
            if (cell instanceof JComponent && (cellBorder = (jCell = (JComponent)cell).getBorder()) instanceof MatteBorder && (matteBorder = (MatteBorder)cellBorder).getMatteColor().equals(Color.black)) {
                Color old = this.g.getColor();
                this.g.setColor(Color.BLACK);
                this.g.drawLine(this.xPos, this.yPos - this.rowHeight + 3, this.xPos + colWidth, this.yPos - this.rowHeight + 3);
                this.g.setColor(old);
            }
            this.g.drawString(str, this.xPos, this.yPos);
            this.xPos += (int)((double)this.imageableWidth * colPercent);
        }
        this.yPos += this.rowHeight;
    }

    private String clipString(String theString, int pixWidth, FontMetrics metrics) {
        String str = theString;
        int strWidth = metrics.stringWidth(str);
        int strLen = str.length();
        boolean tooWide = false;
        while (strWidth > pixWidth) {
            tooWide = true;
            str = str.substring(0, --strLen);
            strWidth = metrics.stringWidth(str);
        }
        if (tooWide) {
            str = strLen >= 3 ? str.substring(0, strLen - 3) : "";
            str = str + "...";
        }
        return str;
    }
}

