/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.print;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import javax.swing.JComponent;
import javax.swing.RepaintManager;
import officemate.adminkit.print.AbstractTableReportPrintable;
import officemate.adminkit.print.ReportPrintParams;
import ordermate.OrderMate;
import org.jdesktop.swingx.JXTable;

public class JXTableReportPrintable
extends AbstractTableReportPrintable
implements Printable {
    private JXTable table;
    private JComponent controlPanel;
    private int rowsPrinted = 0;
    private double firstPageHeight = 0.0;

    public JXTableReportPrintable(JXTable theTable, JComponent theControlPanel, ReportPrintParams theParams) {
        super(theParams, true);
        this.table = theTable;
        this.controlPanel = theControlPanel;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        this.setupVariables(graphics, pageFormat, pageIndex);
        if (pageIndex == 0) {
            this.printTitle(this.getTitle());
            this.printSubTitle(this.getSubtitle());
            this.printLine();
            this.printBusinessHeader();
            if (this.showLogo) {
                this.printLogo();
            }
            this.printControlPanel();
        }
        this.printLine();
        int response = this.printTable(pageIndex);
        return response;
    }

    private int printTable(int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)this.g;
        Dimension d = this.table.getSize();
        double panelWidth = d.width;
        double tableHeight = d.height;
        double pageWidth = this.format.getImageableWidth();
        double scale = pageWidth / panelWidth;
        double scaledRowHeight = (double)this.table.getRowHeight() * scale;
        int pageHeight = (int)this.format.getImageableHeight();
        int response = 0;
        try {
            double scaledHeaderHeight = (double)this.table.getTableHeader().getHeight() * scale;
            if (pageIndex == 0) {
                double proportionOfPageHeader = (double)this.yPos / (double)pageHeight;
                this.numPages = (int)Math.ceil(proportionOfPageHeader + scale * tableHeight / (double)pageHeight);
                g2.translate(this.xPos, this.yPos);
                g2.scale(scale, scale);
                this.table.getTableHeader().print(g2);
                this.firstPageHeight = this.yPos;
                g2.translate(this.xPos, this.table.getTableHeader().getHeight());
                JXTableReportPrintable.enableDoubleBuffering((Component)this.table, false);
                int remainder = (pageHeight - this.yPos - (int)scaledHeaderHeight) % (int)scaledRowHeight;
                this.rowsPrinted = (int)Math.floor((double)(pageHeight - this.yPos) / scaledRowHeight);
                OrderMate.LOG.info("rows printed : " + this.rowsPrinted + "  yPos " + this.yPos + "  pageHeight " + pageHeight + " rowHeight " + this.table.getRowHeight());
                Rectangle clip = g2.getClipRect();
                g2.setClip(new Rectangle(clip.x, clip.y, clip.width, clip.height - remainder));
                this.firstPageHeight += (double)remainder;
                this.table.print((Graphics)g2);
            } else if (pageIndex >= this.numPages) {
                JXTableReportPrintable.enableDoubleBuffering((Component)this.table, true);
                response = 1;
            } else {
                this.rowsPrinted = 0;
                g2 = (Graphics2D)this.g.create();
                double y = (double)(-pageHeight * pageIndex) + this.firstPageHeight + (double)(this.table.getTableHeader().getHeight() * (pageIndex + 1));
                g2.translate(0.0, y);
                g2.scale(scale, scale);
                this.rowsPrinted = (int)Math.floor((double)pageHeight / scaledRowHeight);
                JXTableReportPrintable.enableDoubleBuffering((Component)this.table, false);
                this.table.print((Graphics)g2);
                g2 = (Graphics2D)this.g.create();
                g2.scale(scale, scale);
                this.table.getTableHeader().print(g2);
                this.rowsPrinted += (int)Math.floor((double)pageHeight / scaledRowHeight);
            }
        }
        catch (Exception ex) {
            JXTableReportPrintable.enableDoubleBuffering((Component)this.table, true);
            OrderMate.LOG.warn("An error occured whilst printing", (Throwable)ex);
            throw new PrinterException(ex.getMessage());
        }
        return response;
    }

    private void printControlPanel() throws PrinterException {
        if (this.controlPanel == null) {
            return;
        }
        Dimension d = this.controlPanel.getSize();
        double panelWidth = d.width;
        double pageWidth = this.format.getImageableWidth() - 3.0;
        double scale = pageWidth / panelWidth;
        Graphics2D g2D = (Graphics2D)this.g.create();
        g2D.setBackground(Color.WHITE);
        g2D.translate(this.xPos, this.yPos);
        try {
            JXTableReportPrintable.enableDoubleBuffering(this.controlPanel, false);
            if (scale < 1.0) {
                g2D.scale(scale, scale);
            }
            g2D.clearRect(0, 0, this.controlPanel.getWidth(), this.controlPanel.getHeight());
            this.controlPanel.paint(g2D);
            this.yPos = (int)((double)this.yPos + (double)this.controlPanel.getHeight() * scale);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("An error occured printing the control panel", (Throwable)ex);
            throw new PrinterException(ex.getMessage());
        }
        finally {
            JXTableReportPrintable.enableDoubleBuffering(this.controlPanel, true);
            if (this.controlPanel.getParent() != null) {
                this.controlPanel.getParent().validate();
            }
        }
    }

    public static void enableDoubleBuffering(Component c, boolean enableIt) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(enableIt);
    }
}

