/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.search;

import au.com.ordermate.gui.renderer.JCheckBoxCellRenderer;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.sql.queries.SelectQuery;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.migrationkit.swing.TextFilterList;
import ca.odell.glazedlists.swing.EventListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public abstract class SearchPanelList<T extends PersistentObject>
extends JPanel {
    private static final String DEFAULT_ID_FIELD = "ID";
    private static final String DEFAULT_NAME_FIELD = "Name";
    public final Signal valueSelected = Signals.createSignal(Long.class, (String)"selectedID");
    public final Signal cancel = Signals.createSignal();
    public final Signal gotSelection = Signals.createSignal();
    private JTextField textField;
    private JScrollPane scroller;
    private List<T> resultList = new ArrayList<T>();
    private EventListModel<T> tableListModel;
    private JList tableList;
    private JCheckBoxCellRenderer renderer;
    private TextFilterList filteredtableListModel;
    private SelectQuery query;
    private String idField;
    private String nameField;

    public SearchPanelList() {
        this(DEFAULT_ID_FIELD, DEFAULT_NAME_FIELD);
    }

    public SearchPanelList(boolean delayConstruction) {
        if (!delayConstruction) {
            this.construct(DEFAULT_ID_FIELD, DEFAULT_NAME_FIELD);
        }
    }

    public SearchPanelList(String dbIDField, String dbNameField) {
        this.construct(dbIDField, dbNameField);
    }

    protected final void construct(String dbIDField, String dbNameField) {
        this.setLayout(new BorderLayout());
        EnterListener enterListener = new EnterListener();
        this.textField = new JTextField();
        JLabel searchLabel = new JLabel("Filter List for: ");
        searchLabel.setLabelFor(this.textField);
        this.textField.addActionListener(enterListener);
        this.textField.addKeyListener(enterListener);
        JPanel textPanel = new JPanel(new BorderLayout());
        textPanel.add((Component)searchLabel, "West");
        textPanel.add((Component)this.textField, "Center");
        this.idField = dbIDField;
        this.nameField = dbNameField;
        this.query = this.createQuery();
        EventList eventList = GlazedLists.eventList(this.getResultListByQuery());
        this.filteredtableListModel = new TextFilterList(eventList, new TextFilterator(){

            public void getFilterStrings(List baseList, Object element) {
                List<PropertiedObject.Property> allSearchFields = SearchPanelList.this.getAllPropertiesForSearchFilter();
                for (PropertiedObject.Property prop : allSearchFields) {
                    PersistentObject object = (PersistentObject)element;
                    baseList.add(object.getPropertyValue(prop));
                }
            }
        }, this.textField);
        this.tableListModel = new EventListModel((EventList)this.filteredtableListModel);
        this.tableList = new JList<T>(this.tableListModel);
        this.renderer = JCheckBoxCellRenderer.install((JList)this.tableList);
        this.renderer.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                System.out.println("test");
            }
        });
        this.tableList.addKeyListener(enterListener);
        this.setMinimumSize(new Dimension(300, 500));
        this.scroller = new JScrollPane(this.tableList);
        this.scroller.setSize(350, 600);
        this.add((Component)textPanel, "North");
        this.add((Component)this.scroller, "Center");
        this.textField.requestFocus();
    }

    public void clearSelection() {
        if (this.tableList != null) {
            this.tableList.clearSelection();
            this.renderer = JCheckBoxCellRenderer.install((JList)this.tableList);
        }
    }

    private List<T> getResultListByQuery() {
        this.resultList = PersistenceManager.getObjectList(this.getSearchClass(), (String)this.query.toString());
        return this.resultList;
    }

    public abstract T getSelectedObject(Long var1);

    public abstract Class<T> getSearchClass();

    protected abstract SelectQuery createQuery();

    protected String getIDField() {
        return this.idField;
    }

    protected String getNameField() {
        return this.nameField;
    }

    public List<T> getSelectedObjects() {
        ArrayList results = new ArrayList();
        GlazedLists.syncEventListToList((EventList)this.renderer.getSelectionEventList(), results);
        return results;
    }

    public T[] getSelectedObjectsArray() {
        return (PersistentObject[])this.getSelectedObjects().toArray();
    }

    public abstract List<PropertiedObject.Property> getAllPropertiesForSearchFilter();

    private class EnterListener
    extends KeyAdapter
    implements ActionListener,
    MouseListener {
        private EnterListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            SearchPanelList.this.gotSelection.emit();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            int key = e.getKeyCode();
            if (key == 27) {
                SearchPanelList.this.cancel.emit();
            } else if (e.getSource() == SearchPanelList.this.tableList) {
                if (key == 9) {
                    SearchPanelList.this.textField.requestFocus();
                    e.consume();
                }
            } else if (e.getSource() == SearchPanelList.this.textField && (key == 38 || key == 40)) {
                SearchPanelList.this.tableList.requestFocus();
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

