/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.searchpanels;

import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import officemate.adminkit.searchpanels.AbstractAdminSearchPanel;
import ordermate.database.inventory.InventoryProfile;
import ordermate.database.inventory.combos.InventoryCombo;

public class InventoryComboSearchPanel
extends AbstractAdminSearchPanel<InventoryCombo> {
    private final InventoryProfile profile;

    public InventoryComboSearchPanel(InventoryProfile profile) {
        super(true, InventoryCombo.class);
        this.profile = profile;
        this.construct("inventory_combo.ID", "inventory_combo.name");
    }

    @Override
    protected SelectQuery createQuery() {
        SelectQuery query = new SelectQuery("inventory_combo");
        query.addSelectValue(this.getIDField());
        query.addSelectValue(this.getNameField());
        return query;
    }

    @Override
    protected void addWheresToQuery(SelectQuery searchQuery, String typedText) {
        searchQuery.addWhere(SQL.isActive((String)"inventory_combo"));
        searchQuery.addWhere("inventory_combo.FK_inventory_profile = " + this.profile.getID());
        if (typedText != null && !typedText.isEmpty()) {
            searchQuery.addWhere("inventory_combo.label LIKE '%" + typedText + "%'");
        }
        searchQuery.addOrderBy(this.getNameField());
    }
}

