/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.searchpanels;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import officemate.adminkit.searchpanels.InventoryGroupSearchPanel;
import ordermate.database.inventory.InventoryGroup;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.InventoryItemSize;
import ordermate.database.inventory.InventoryProfile;

public class InventoryGroupSizesSearchPanel
extends InventoryGroupSearchPanel
implements ListSelectionListener {
    private JList sizesList;
    private DefaultListModel model;
    private InventoryGroup lastGroup;
    private Map groupSizesMap = new HashMap();
    private Map sizePanelsMap = new HashMap();

    public InventoryGroupSizesSearchPanel(InventoryProfile theProfile) {
        super(theProfile);
        this.gotSelection.connect((Object)this, "updateSizeList");
        this.model = new DefaultListModel();
        this.sizesList = new JList<Object>(new Object[0]);
        this.sizesList.setPreferredSize(new Dimension(100, 200));
        this.sizesList.setModel(this.model);
        this.sizesList.setCellRenderer(new SizeSelectionRenderer());
        this.sizesList.addListSelectionListener(this);
        this.add((Component)this.sizesList, "East");
        this.setMinimumSize(new Dimension(200, 200));
        for (InventoryItemSize size : InventoryItemSize.getAllSizes()) {
            this.sizePanelsMap.put(size, new SizeSelectionPanel(size));
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.model != null) {
            this.updateSizeList();
        }
    }

    public List getSelectedSizes() {
        ArrayList<InventoryItemSize> sizes = new ArrayList<InventoryItemSize>();
        Object[] sizePanels = this.model.toArray();
        for (int i = 0; i < sizePanels.length; ++i) {
            SizeSelectionPanel panel = (SizeSelectionPanel)sizePanels[i];
            if (!panel.isSelected()) continue;
            sizes.add(panel.getItemSize());
        }
        return sizes;
    }

    void updateSizeList() {
        InventoryGroup group = (InventoryGroup)this.getSelectedObject();
        if (group == null) {
            this.model.clear();
        } else if (!group.equals((Object)this.lastGroup)) {
            this.model.clear();
            List sizePanels = new ArrayList();
            if (this.groupSizesMap.containsKey(group)) {
                sizePanels = (List)this.groupSizesMap.get(group);
            } else {
                HashSet sizes = new HashSet();
                for (InventoryItem item : group.getRecursiveItems()) {
                    sizes.addAll(item.getSizes());
                }
                for (Object size : sizes) {
                    if (!this.sizePanelsMap.containsKey(size)) continue;
                    sizePanels.add(this.sizePanelsMap.get(size));
                }
                this.groupSizesMap.put(group, sizePanels);
            }
            Collections.sort(sizePanels, new Comparator(){

                public int compare(Object obj1, Object obj2) {
                    SizeSelectionPanel p1 = (SizeSelectionPanel)obj1;
                    SizeSelectionPanel p2 = (SizeSelectionPanel)obj2;
                    if (p1.size.getSequence() == null && p2.size.getSequence() == null) {
                        return p1.size.getShortName().compareTo(p2.size.getShortName());
                    }
                    if (p1.size.getSequence() == null) {
                        return -1;
                    }
                    if (p2.size.getSequence() == null) {
                        return 1;
                    }
                    return p1.size.getSequence().compareTo(p2.size.getSequence());
                }
            });
            Iterator sizeit = sizePanels.iterator();
            while (sizeit.hasNext()) {
                this.model.addElement(sizeit.next());
            }
        }
        this.lastGroup = group;
        this.revalidate();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        JList theList = (JList)e.getSource();
        SizeSelectionPanel panel = (SizeSelectionPanel)theList.getSelectedValue();
        if (panel != null && !e.getValueIsAdjusting()) {
            panel.toggleSelected();
        }
    }

    private static class SizeSelectionPanel
    extends JPanel {
        JCheckBox checkBox;
        InventoryItemSize size;

        public SizeSelectionPanel(Object value) {
            this.size = (InventoryItemSize)value;
            this.setLayout(new FlowLayout(0, 0, 0));
            this.checkBox = new JCheckBox(value.toString(), true);
            this.add(this.checkBox);
        }

        public InventoryItemSize getValue() {
            return this.size;
        }

        public boolean isSelected() {
            return this.checkBox.isSelected();
        }

        public void toggleSelected() {
            if (this.checkBox.isSelected()) {
                this.checkBox.setSelected(false);
            } else {
                this.checkBox.setSelected(true);
            }
        }

        public InventoryItemSize getItemSize() {
            return this.size;
        }
    }

    private static class SizeSelectionRenderer
    implements ListCellRenderer {
        private SizeSelectionRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return (SizeSelectionPanel)value;
        }
    }
}

