/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.searchpanels;

import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import officemate.adminkit.searchpanels.AbstractAdminSearchPanel;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryProfile;

public class InventoryItemSearchPanel
extends AbstractAdminSearchPanel<InventoryItemUnit> {
    private InventoryProfile profile;
    private boolean doShowUnits;

    public InventoryItemSearchPanel(InventoryProfile theProfile) {
        this(theProfile, false);
    }

    public InventoryItemSearchPanel(InventoryProfile theProfile, boolean showUnits) {
        super(true, InventoryItemUnit.class);
        this.profile = theProfile;
        this.doShowUnits = showUnits;
        this.construct("inventory_item_unit.ID", "theName");
    }

    @Override
    protected SelectQuery createQuery() {
        SelectQuery query = new SelectQuery(new String[]{"inventory_group", "inventory_item", "inventory_item_unit", "inventory_size"});
        query.addSelectValue(this.getIDField());
        if (this.doShowUnits) {
            query.addSelectValue("CONCAT_WS(' ', inventory_item.Name, IF(inventory_item_unit.FK_inventory_portion = 2, 'Half-Half', null),inventory_size.Name) AS theName");
        } else {
            query.addSelectValue("inventory_item.Name AS theName");
        }
        return query;
    }

    @Override
    protected void addWheresToQuery(SelectQuery query, String typedText) {
        query.addWhere(SQL.isActive((String)"inventory_item_unit"));
        query.addWhere(SQL.isActive((String)"inventory_item"));
        query.addWhere(SQL.isActive((String)"inventory_group"));
        query.addWhere(SQL.join((String)"inventory_item_unit", (String)"inventory_item", (String)"inventory_group"));
        query.addWhere(SQL.join((String)"inventory_item_unit", (String)"inventory_size"));
        query.addWhere("inventory_group.FK_inventory_profile = " + this.profile.getID());
        if (typedText != null && !typedText.equalsIgnoreCase("")) {
            query.addWhere("inventory_item.Name LIKE '%" + typedText + "%'");
            query.addOrderBy("(inventory_item.Name NOT LIKE '" + typedText + "%')", true);
        }
        query.addOrderBy(this.getNameField());
        if (!this.doShowUnits) {
            query.addGroupBy("inventory_item.ID");
        }
    }
}

