/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.searchpanels;

import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.SelectQuery;
import officemate.adminkit.searchpanels.AbstractAdminSearchPanel;
import ordermate.database.inventory.InventoryOption;

public class InventoryOptionSearchPanel
extends AbstractAdminSearchPanel<InventoryOption> {
    public InventoryOptionSearchPanel() {
        super("inventory_option.ID", "inventory_option.Name", InventoryOption.class);
    }

    public InventoryOptionSearchPanel(boolean showGroupName) {
        super("inventory_option.ID", "CONCAT(inventory_option_group.Name, ' - ', inventory_option.Name)", InventoryOption.class);
    }

    @Override
    protected SelectQuery createQuery() {
        SelectQuery query = new SelectQuery(new String[]{"inventory_option", "inventory_option_group"});
        query.addSelectValue(this.getIDField());
        query.addSelectValue(this.getNameField());
        return query;
    }

    @Override
    protected void addWheresToQuery(SelectQuery query, String typedText) {
        query.addWhere(SQL.join((String)"inventory_option", (String)"inventory_option_group"));
        query.addWhere(SQL.isActive((String)"inventory_option_group"));
        query.addWhere(SQL.isActive((String)"inventory_option"));
        if (typedText != null && !typedText.equalsIgnoreCase("")) {
            query.addWhere("(inventory_option_group.Name LIKE '%" + typedText + "%' OR inventory_option.Name LIKE '%" + typedText + "%')");
        }
        query.addOrderBy("inventory_option_group.Name", true);
        query.addOrderBy("inventory_option.Name", true);
    }
}

