/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.searchpanels;

import au.com.ordermate.sql.SQL;
import au.com.ordermate.sql.queries.Literal;
import au.com.ordermate.sql.queries.Operator;
import au.com.ordermate.sql.queries.SQLColumn;
import au.com.ordermate.sql.queries.SelectQuery;
import au.com.ordermate.sql.queries.Value;
import officemate.adminkit.searchpanels.AbstractAdminSearchPanel;
import officemate.adminkit.table.QueryTableModel;
import ordermate.database.DBConnectionInterface;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.maps.inventory.triggers.AbstractTriggerMap;

public class TriggerSearchPanel
extends AbstractAdminSearchPanel<AbstractTrigger> {
    protected static final String NAME_COL = AbstractTriggerMap.instance().getColumn(AbstractTrigger.Properties.LABEL);
    protected static final String ID_COL = AbstractTriggerMap.instance().getColumn(AbstractTrigger.Properties.ID);
    protected static final String SYSTEM_STATE_COL = AbstractTriggerMap.instance().getColumn(AbstractTrigger.Properties.SYSTEM_STATE);

    public TriggerSearchPanel() {
        super(ID_COL, NAME_COL, AbstractTrigger.class);
    }

    @Override
    protected void addWheresToQuery(SelectQuery searchQuery, String typedText) {
        if (typedText != null && !typedText.equalsIgnoreCase("")) {
            searchQuery.addWhere(new SQLColumn("inventory_trigger", NAME_COL), Operator.LIKE, (Value)Literal.getAddQuotes((String)(typedText + '%')));
        }
        searchQuery.addWhere(new SQLColumn("inventory_trigger", SYSTEM_STATE_COL), Operator.NOT_EQUALS, (Value)Literal.getAddQuotes((String)"DELETED"));
        searchQuery.addOrderBy(NAME_COL);
    }

    @Override
    protected SelectQuery createQuery() {
        SelectQuery query = SQL.createQuery((String)"inventory_trigger");
        query.addSelectValue(ID_COL);
        query.addSelectValue(NAME_COL);
        return query;
    }

    @Override
    protected QueryTableModel createTableModel(SelectQuery searchQuery, String dbIDField, String dbNameField, DBConnectionInterface newControl) {
        return new QueryTableModel(searchQuery, newControl, dbIDField, new String[]{dbNameField}, new String[]{"Name"});
    }
}

