/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state;

import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.ApplicationStructure;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.task.GUIStateI;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyVetoException;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import officemate.OfficeMate;
import officemate.adminkit.navigation.FlatSplitUI;
import officemate.adminkit.navigation.OfficeMateTheme;
import officemate.adminkit.navigation.OfficemateNavigation;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.OfficeMateToolBar;
import officemate.adminkit.state.login.LoginState;
import officemate.adminkit.state.statebuilder.OfficeMateBlueprintArchitecture;
import officemate.adminkit.state.welcome.BaseInternalApplicationFrame;
import officemate.adminkit.state.welcome.FloatingButtonFrame;
import officemate.adminkit.state.welcome.WelcomeState;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class ApplicationPanel
extends JPanel {
    public final Signal<ApplicationStateBlueprint, ?, ?, ?, ?> stateSelected = Signals.createSignal(ApplicationStateBlueprint.class, (String)"key");
    public final Signal logOut;
    public final Signal exit;
    private JDesktopPane desktopPane;
    private BaseInternalApplicationFrame baseFrame;
    private FloatingButtonFrame floatingFrame;
    private JSplitPane split;
    private OfficemateNavigation navigation;
    private ApplicationStructure structure;
    private JComponent statePanel;
    private JPanel stateHolder;
    private Stack<ApplicationStateBlueprint> lastSelectedStates = new Stack();
    private OfficeMateToolBar toolBar;
    private boolean stateSelectSignalAllowed = true;
    private BackAction backAction = new BackAction();
    private static final int BASE_FRAME_LAYER = 10;
    private static final int FLOATING_FRAME_LAYER = 100;
    private static final int DIVIDER_INDENT = 11;
    private static final int DIVIDER_INDENT_EXPANDED = 13;
    public static final int LEFT_END_DIVIDER_LOCATION = 60;
    public static final int FLOATING_FRAME_LEFT_LOCATION = 50;
    private static final int FLOATING_FRAME_Y_INDENT = 45;
    private static final int SPLIT_DIVIDER_SIZE = 10;
    public static final int INITIAL_EXPANDED_LOCATION = 310;
    private int lastDividerLocation = 310;
    private static final int BUTTON_ACTION_OPEN = 1;
    private static final int BUTTON_ACTION_TOGGLE = 2;

    public ApplicationPanel(OfficeMateBlueprintArchitecture officeMateBlueprintArchitecture, Signal logoutSignal, Signal exitSignal) {
        this.exit = exitSignal;
        this.logOut = logoutSignal;
        this.structure = GuiApp.getAppComplex().getApplicationStructure();
        this.setLayout(new BorderLayout());
        this.toolBar = new OfficeMateToolBar();
        this.setupNavigation(this.structure);
        this.stateHolder = new JPanel(new BorderLayout());
        this.desktopPane = new JDesktopPane();
        this.baseFrame = new BaseInternalApplicationFrame();
        this.floatingFrame = new FloatingButtonFrame((Action)((Object)new SplitPaneAction()));
        this.baseFrame.getContentPane().setLayout(new BorderLayout());
        this.baseFrame.setSize(GuiApp.getAppComplex().getApplicationFrame().getFrame().getSize());
        this.baseFrame.setVisible(true);
        this.desktopPane.add((Component)this.baseFrame, 10);
        this.desktopPane.add((Component)this.floatingFrame, 100);
        this.floatingFrame.setVisible(false);
        this.add(this.desktopPane);
        this.desktopPane.moveToFront(this.baseFrame);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                if (ApplicationPanel.this.split != null) {
                    ApplicationPanel.this.setFloatingFrameLocation(ApplicationPanel.this.split.getDividerLocation() - 11);
                }
            }
        });
        OfficemateNavigation.navigationRootClicked.connect((Object)this, "navigationRootClicked");
    }

    private void navigationRootClicked() {
        this.showSearchPanel(1);
    }

    private void showSearchPanel(int buttonAction) {
        switch (buttonAction) {
            case 1: {
                if (this.lastDividerLocation == 60) {
                    this.lastDividerLocation = 310;
                }
                this.setDividerLocationAndFrameLocation();
                break;
            }
            case 2: {
                if (this.split.getDividerLocation() == 60) {
                    this.setDividerLocationAndFrameLocation();
                    break;
                }
                this.lastDividerLocation = this.split.getDividerLocation();
                this.split.setDividerLocation(60);
                this.setFloatingFrameLocation(50);
            }
        }
    }

    private void setDividerLocationAndFrameLocation() {
        this.split.setDividerLocation(this.lastDividerLocation);
        this.setFloatingFrameLocation(this.lastDividerLocation - 13);
        this.lastDividerLocation = this.split.getDividerLocation();
    }

    private void setFloatingFrameLocation(int x) {
        if (this.floatingFrame != null) {
            this.floatingFrame.setLocation(x, this.getHeight() - 45);
        }
    }

    public void selectStateInTreePanel(ApplicationStateBlueprint stateToSelect) {
        this.stateSelectSignalAllowed = false;
        this.navigation.setSelectedObject(stateToSelect);
        this.stateSelectSignalAllowed = true;
    }

    public void showSelectedState(ApplicationStateBlueprint stateBlueprints, boolean fullScreen) {
        this.backAction.validate();
        if (this.lastSelectedStates.isEmpty() || !this.lastSelectedStates.peek().equals(stateBlueprints)) {
            this.lastSelectedStates.push(stateBlueprints);
        }
        this.selectStateInTreePanel(stateBlueprints);
        if (this.statePanel != null) {
            this.statePanel.getParent().remove(this.statePanel);
        }
        GUIStateI toShow = this.structure.getState(stateBlueprints.getKey());
        this.statePanel = toShow.getScreenPanel();
        if (fullScreen) {
            this.setMaxBaseFrame();
            this.baseFrame.getContentPane().removeAll();
            this.baseFrame.getContentPane().add((Component)this.statePanel, "Center");
            if (this.toolBar.getParent() != null) {
                this.remove(this.toolBar.getParent());
            }
        } else {
            this.baseFrame.getContentPane().removeAll();
            if (this.split == null) {
                this.split = new JSplitPane(1, true, this.navigation.getComponent(), this.stateHolder);
                this.split.setDividerLocation(this.navigation.getPreferredWidth());
                this.split.setName("SearchSplitPane");
                this.split.setDividerSize(10);
                this.split.setOneTouchExpandable(true);
                this.split.setResizeWeight(0.0);
                this.split.setBackground(OfficeMateTheme.STATE_LOWLIGHT);
                FlatSplitUI flatSplitUI = new FlatSplitUI(OfficeMateTheme.STATE_SELECTION_BG, OfficeMateTheme.STATE_HIGHLIGHT);
                this.split.setUI(flatSplitUI);
                flatSplitUI.mouseSignal.connect((Object)this, "gotDividerSizeChanged");
            }
            if (this.split.getParent() == null) {
                this.baseFrame.getContentPane().add((Component)this.split, "Center");
                this.lastDividerLocation = this.split.getDividerLocation();
                this.setFloatingFrameLocation(this.split.getDividerLocation() - 11);
                FloatingButtonFrame.showFloatingFrame(true);
                this.floatingFrame.getLayeredPane().setLayer(this.floatingFrame, JLayeredPane.POPUP_LAYER);
            }
            this.showStatesToolbar(stateBlueprints);
            this.stateHolder.removeAll();
            this.stateHolder.add((Component)this.toolBar, "North");
            this.stateHolder.add((Component)this.statePanel, "Center");
        }
        this.baseFrame.revalidate();
        this.baseFrame.repaint();
        this.revalidate();
        this.repaint();
        toShow.refresh();
    }

    public void gotDividerSizeChanged(Integer size) {
        if (size > 0) {
            this.lastDividerLocation = size;
            this.setFloatingFrameLocation(size - 13);
        }
    }

    private void setMaxBaseFrame() {
        try {
            this.baseFrame.setMaximum(true);
        }
        catch (PropertyVetoException e) {
            OfficeMate.LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private void showStatesToolbar(ApplicationStateBlueprint stateBlueprint) {
        this.toolBar = new OfficeMateToolBar();
        GUIStateI state = this.structure.getState(stateBlueprint.getKey());
        if (state instanceof BasicOfficeMateState) {
            BasicOfficeMateState officeMateState = (BasicOfficeMateState)state;
            this.toolBar.createDefaultButtonsToolbar((Action)((Object)this.backAction), officeMateState.getName(), officeMateState.getDefaultActions());
            this.toolBar.createStateSpecificToolbar(officeMateState.getStateSpecificActions());
            if (officeMateState instanceof WelcomeState) {
                this.toolBar.setVisible(false);
            }
        }
    }

    public void updateForNewUser() {
        this.refreshNavMenus();
        this.navigation.gotUserChanged();
    }

    public void refreshNavMenus() {
    }

    public void refreshFavourites() {
        this.navigation.reloadSubstates();
    }

    private void setupNavigation(ApplicationStructure structure) {
        this.navigation = new OfficemateNavigation(structure);
        this.navigation.stateSelected.connect((Object)this, "gotStateSelected");
    }

    void gotStateSelected(ApplicationStateBlueprint blueprint) {
        if (this.stateSelectSignalAllowed) {
            this.stateSelected.emit((Object)blueprint);
        }
    }

    void gotStateDenied() {
        if (!this.lastSelectedStates.isEmpty()) {
            this.selectStateInTreePanel(this.lastSelectedStates.peek());
        }
    }

    public OfficemateNavigation getNavigation() {
        return this.navigation;
    }

    class SplitPaneAction
    extends BasicAction {
        SplitPaneAction() {
        }

        public void actionPerformed(ActionEvent e) {
            ApplicationPanel.this.showSearchPanel(2);
        }
    }

    public static final class ExitAction
    extends BasicAction {
        private final Signal exit;

        public ExitAction(Signal exitSignal) {
            super("Exit");
            this.setLargeIcon(IconLoader.get((String)"/officemate/images/exit.png"));
            this.setSmallIcon(IconLoader.get((String)"/ordermate/images/exit_icon16.png"));
            this.setToolTipText("Exit OfficeMate");
            this.exit = exitSignal;
        }

        public void actionPerformed(ActionEvent e) {
            this.exit.emit();
        }
    }

    public static final class LogoutAction
    extends BasicAction {
        private final Signal logout;

        public LogoutAction(Signal logOut) {
            super("Log Out");
            this.setLargeIcon(IconLoader.get((String)"/officemate/images/exit.png"));
            this.setSmallIcon(IconLoader.get((String)"/ordermate/images/logout_icon16.png"));
            this.setToolTipText("Log out of OfficeMate");
            this.logout = logOut;
        }

        public void actionPerformed(ActionEvent e) {
            FloatingButtonFrame.showFloatingFrame(false);
            this.logout.emit();
        }
    }

    private final class BackAction
    extends BasicAction {
        private BackAction() {
            super("Back", (Icon)IconLoader.get((String)"/officemate/images/back.png"), "Back to the previous screen");
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent e) {
            if (this.hasValidState()) {
                ApplicationStateBlueprint state = (ApplicationStateBlueprint)ApplicationPanel.this.lastSelectedStates.pop();
                if (this.hasValidState() && (state = (ApplicationStateBlueprint)ApplicationPanel.this.lastSelectedStates.pop()) != null && !LoginState.class.equals((Object)state.getStateClazz())) {
                    ApplicationPanel.this.stateSelected.emit((Object)state);
                }
            }
            this.validate();
        }

        public void validate() {
            this.setEnabled(this.hasValidState());
        }

        private boolean hasValidState() {
            return !ApplicationPanel.this.lastSelectedStates.isEmpty() && !((ApplicationStateBlueprint)ApplicationPanel.this.lastSelectedStates.peek()).getStateClazz().equals(LoginState.class);
        }
    }
}

