/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state;

import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.image.IconLoader;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Color;
import java.awt.Dimension;
import java.util.HashMap;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.EmptyBorder;
import officemate.adminkit.navigation.OfficeMateTheme;
import officemate.adminkit.state.OfficeMateToolBarButton;

public class BasicOfficeMateActionRenderer {
    private static final int BUTTON_BUFFER = 20;
    private final float butFontSize = 10.0f;
    private HashMap<String, ImageIcon> iconMapping;
    private HashMap<String, Color> foregroundColorMapping;

    public BasicOfficeMateActionRenderer() {
        this.initializeIconMapping();
        this.initializeColorMapping();
    }

    private void initializeIconMapping() {
        this.iconMapping = new HashMap();
        this.iconMapping.put("Back", this.tintIt(IconLoader.get((String)"/officemate/images/back.png"), OfficeMateTheme.BACK));
        this.iconMapping.put("Search", this.tintIt(IconLoader.get((String)"/officemate/images/search.png"), OfficeMateTheme.SEARCH));
        this.iconMapping.put("Refresh", this.tintIt(IconLoader.get((String)"/officemate/images/refresh_new.png"), OfficeMateTheme.REFRESH));
        this.iconMapping.put("Print", this.tintIt(IconLoader.get((String)"/officemate/images/print_new.png"), OfficeMateTheme.PRINT));
        this.iconMapping.put("New", this.tintIt(IconLoader.get((String)"/officemate/images/new.png"), OfficeMateTheme.NEW));
        this.iconMapping.put("Edit", this.tintIt(IconLoader.get((String)"/officemate/images/edit_new.png"), OfficeMateTheme.EDIT));
        this.iconMapping.put("Delete", this.tintIt(IconLoader.get((String)"/officemate/images/delete_new.png"), OfficeMateTheme.DELETE));
        this.iconMapping.put("Save", this.tintIt(IconLoader.get((String)"/officemate/images/save_new.png"), OfficeMateTheme.SAVE));
        this.iconMapping.put("Cancel", this.tintIt(IconLoader.get((String)"/officemate/images/cancel_new.png"), OfficeMateTheme.CANCEL));
    }

    private void initializeColorMapping() {
        this.foregroundColorMapping = new HashMap();
        this.foregroundColorMapping.put("Back", OfficeMateTheme.BACK.darker());
        this.foregroundColorMapping.put("Search", OfficeMateTheme.SEARCH.darker());
        this.foregroundColorMapping.put("Refresh", OfficeMateTheme.REFRESH.darker());
        this.foregroundColorMapping.put("Print", OfficeMateTheme.PRINT.darker());
        this.foregroundColorMapping.put("New", OfficeMateTheme.NEW.darker());
        this.foregroundColorMapping.put("Edit", OfficeMateTheme.EDIT.darker());
        this.foregroundColorMapping.put("Delete", OfficeMateTheme.DELETE.darker());
        this.foregroundColorMapping.put("Save", OfficeMateTheme.SAVE.darker());
        this.foregroundColorMapping.put("Cancel", OfficeMateTheme.CANCEL.darker());
    }

    public ImageIcon tintIt(ImageIcon toTint, Color tint) {
        return new ImageIcon(new ImageHelper().tintImage(toTint.getImage(), tint, 0.75f));
    }

    public JButton renderDefaultToolbarButton(BasicAction action) {
        int MAX_HEIGHT = 50;
        int PREFERRED_WIDTH = 50;
        JButton newButton = new JButton((Action)action);
        newButton.setFont(newButton.getFont().deriveFont(10.0f));
        newButton.setFocusPainted(false);
        newButton.getInsets().set(0, 0, 0, 0);
        newButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        newButton.setHideActionText(false);
        newButton.setMaximumSize(new Dimension(50, 50));
        newButton.setPreferredSize(new Dimension(50, 50));
        newButton.setContentAreaFilled(false);
        newButton.setHorizontalTextPosition(0);
        newButton.setVerticalTextPosition(3);
        String actionText = action.getText();
        newButton.setIcon(this.iconMapping.get(actionText));
        newButton.setForeground(this.foregroundColorMapping.get(actionText));
        newButton.setName(actionText + " button");
        return newButton;
    }

    public JButton renderStateSpecificButton(Action action) {
        int MAX_HEIGHT = 50;
        OfficeMateToolBarButton newButton = new OfficeMateToolBarButton(action);
        newButton.setPreferredSize(new Dimension((int)newButton.getPreferredSize().getWidth() + 20, 25));
        newButton.setMaximumSize(new Dimension((int)newButton.getPreferredSize().getWidth() + 20, 50));
        newButton.setIcon(null);
        return newButton;
    }
}

