/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state;

import au.com.ordermate.application.ApplicationNavigator;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.guicore.favourite.Favourite;
import au.com.ordermate.guicore.task.GUIStateI;
import au.com.ordermate.util.image.IconLoader;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import officemate.adminkit.state.statebuilder.OfficeMateBlueprintArchitecture;
import officemate.screens.DefaultApplicationFrame;
import officemate.screens.favorites.FavoritesState;
import ordermate.OrderMate;
import ordermate.database.gui.FavouriteEntryHelper;
import ordermate.database.gui.FavouritesEntry;
import ordermate.database.users.User;

public class FavoritesManager {
    private static final FavoritesManager instance = FavoritesManager.getNewInstance();
    private FavoritesState favState = null;
    private ApplicationStateBlueprint favBlue = null;

    FavoritesManager() {
    }

    static FavoritesManager getNewInstance() {
        return new FavoritesManager();
    }

    public static FavoritesManager getInstance() {
        return instance;
    }

    public void setupFavourites(FavoritesState state) {
        this.favState = state;
        this.favBlue = this.getBlueprint(this.favState.getStateKey());
        this.updateFavourites();
    }

    public void updateFavourites() {
        User currentUser = this.getCurrentUser();
        if (currentUser == null) {
            this.removeFavoritesNotIn(this.favState, Collections.EMPTY_SET);
            return;
        }
        this.clearFavourites();
        this.addFavourites(this.favState, FavouriteEntryHelper.getFavourites((User)currentUser));
        this.refreshFavourites();
    }

    private void clearFavourites() {
        for (Favourite favourite : new ArrayList<Favourite>(this.favState.getSubStates())) {
            this.favState.removeSubState((GUIStateI)favourite);
            this.getFavoritesBlueprint().removeChildStateKeys(new String[]{favourite.getStateKey()});
            if (favourite.getFavoritesData() == null) continue;
            favourite.getFavoritesData().setDisplayingAsFavorite(false);
        }
    }

    protected User getCurrentUser() {
        return GuiApp.getAppComplex().getApplicationSecurity().getUser();
    }

    protected void refreshFavourites() {
        ((DefaultApplicationFrame)GuiApp.getAppComplex().getApplicationFrame()).refreshFavourites();
    }

    private void addFavourites(FavoritesState state, List<FavouritesEntry> newFavourites) {
        for (FavouritesEntry entry : newFavourites) {
            GUIStateI entryState = this.getState(entry.getFavouritesID());
            if (entryState == null) {
                OrderMate.LOG.warn("gui_officemate_favourites entry of key " + entry.getFavouritesID() + " does not match an existing state!");
                continue;
            }
            this.configureGUIState(state, entryState);
            this.configureTree(state, entry);
        }
    }

    void configureTree(FavoritesState state, FavouritesEntry entry) {
        this.getFavoritesBlueprint().addChildStateKeys(new String[]{entry.getFavouritesID()});
    }

    private void configureGUIState(FavoritesState state, GUIStateI entryState) {
        if (entryState instanceof Favourite) {
            state.addSubState(entryState);
            if (((Favourite)entryState).getFavoritesData() != null) {
                ((Favourite)entryState).getFavoritesData().setDisplayingAsFavorite(true);
            }
        } else {
            OrderMate.LOG.warn("gui_officemate_favourites entry of key " + entryState.getStateKey() + "matches a state which is not a Favourite");
        }
    }

    private void removeFavoritesNotIn(FavoritesState state, Set<FavouritesEntry> newFavourites) {
        for (Favourite favourite : new ArrayList<Favourite>(state.getSubStates())) {
            boolean found = false;
            for (FavouritesEntry entry : newFavourites) {
                Favourite keyState = (Favourite)this.getState(entry.getFavouritesID());
                if (!favourite.equals(keyState)) continue;
                found = true;
                break;
            }
            if (found) continue;
            state.removeSubState((GUIStateI)favourite);
            this.getFavoritesBlueprint().removeChildStateKeys(new String[]{favourite.getStateKey()});
            if (favourite.getFavoritesData() == null) continue;
            favourite.getFavoritesData().setDisplayingAsFavorite(false);
        }
    }

    GUIStateI getState(String stateKey) {
        ApplicationNavigator nav = GuiApp.getAppComplex().getApplicationNavigator();
        if (nav != null) {
            return nav.getState(stateKey);
        }
        return null;
    }

    ApplicationStateBlueprint getBlueprint(String stateKey) {
        OfficeMateBlueprintArchitecture architecture = (OfficeMateBlueprintArchitecture)GuiApp.getAppComplex().getApplicationStructure().getArchitecture();
        if (architecture != null) {
            return architecture.getBlueprint(stateKey);
        }
        return null;
    }

    private void gotNewFavorite(Favourite favorite) {
        FavouritesEntry entry = new FavouritesEntry(favorite.getFavoritesData().getFavoriteIdentifierString(), GuiApp.getAppComplex().getApplicationSecurity().getUser());
        entry.save();
        favorite.getFavoritesData().setDisplayingAsFavorite(true);
        this.addFavourites(this.favState, Arrays.asList(entry));
        this.refreshFavourites();
    }

    protected void gotRemoveFromFavorites(Favourite fav) {
        fav.getFavoritesData().deleteFavourite();
        this.favState.setActiveSubState(null);
        this.favState.removeSubState((GUIStateI)fav);
        this.getFavoritesBlueprint().removeChildStateKeys(new String[]{fav.getStateKey()});
        fav.getFavoritesData().setDisplayingAsFavorite(false);
        this.refreshFavourites();
    }

    public ApplicationStateBlueprint getFavoritesBlueprint() {
        return this.favBlue;
    }

    public FavouritesAction createFavouritesAction(Favourite fav) {
        return new FavouritesAction(fav);
    }

    public class FavouritesAction
    extends BasicAction {
        private Favourite favoriteState;
        protected static final String ADD_TO_BUTTON_TEXT = "Favourite";
        protected static final String REMOVE_FROM_BUTTON_TEXT = "Unfavourite";

        public FavouritesAction(Favourite fav) {
            super(ADD_TO_BUTTON_TEXT, (Icon)IconLoader.get((String)"/officemate/images/bookmark_add.png"));
            this.favoriteState = fav;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.favoriteState.getFavoritesData().isDisplayingAsFavorite()) {
                FavoritesManager.this.gotRemoveFromFavorites(this.favoriteState);
            } else {
                FavoritesManager.this.gotNewFavorite(this.favoriteState);
            }
        }

        public void setupAction() {
            if (this.favoriteState.getFavoritesData().isDisplayingAsFavorite()) {
                this.setupRemoveAction();
            } else {
                this.setupAddAction();
            }
        }

        private void setupRemoveAction() {
            this.setText(REMOVE_FROM_BUTTON_TEXT);
        }

        private void setupAddAction() {
            this.setText(ADD_TO_BUTTON_TEXT);
        }
    }
}

