/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state;

import au.com.ordermate.gui.actions.BasicAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.Arrays;
import java.util.List;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import officemate.adminkit.navigation.OfficeMateTheme;
import officemate.adminkit.state.BasicOfficeMateActionRenderer;
import officemate.components.controls.RectangleRoundedBorder;
import ordermate.internationalization.Internationalization;

public class OfficeMateToolBar
extends JPanel {
    private static final String NEW_TEXT = Internationalization.getLiteralFor((String)"BUTTON_NEW");
    private static final String EDIT_TEXT = Internationalization.getLiteralFor((String)"BUTTON_EDIT");
    private static final String DELETE_TEXT = Internationalization.getLiteralFor((String)"BUTTON_DELETE");
    private static final String SAVE_TEXT = Internationalization.getLiteralFor((String)"BUTTON_SAVE");
    private static final String CANCEL_TEXT = Internationalization.getLiteralFor((String)"BUTTON_CANCEL");
    private static final List<String> CRUD_ACTION_NAMES = Arrays.asList(NEW_TEXT, EDIT_TEXT, DELETE_TEXT, SAVE_TEXT, CANCEL_TEXT);
    private BasicOfficeMateActionRenderer buttonRenderer = new BasicOfficeMateActionRenderer();
    private JPanel defaultButtonsToolbar;
    private JLabel title;
    private JPanel backHolder;
    private JPanel buttonsHolder;
    private JPanel crudButtons;
    private JPanel stateSpecificToolbar;
    private static final int VERTICAL_GAP = 5;
    private static final int HORIZONTAL_GAP = 15;
    private final float FONT_SIZE = 16.0f;

    public OfficeMateToolBar() {
        super(new BorderLayout());
        this.initialiseDefaultButtonsToolbar();
    }

    private void initialiseDefaultButtonsToolbar() {
        this.removeAll();
        this.defaultButtonsToolbar = new JPanel(new BorderLayout());
        this.buttonsHolder = new JPanel(new FlowLayout(2));
        this.crudButtons = new JPanel(new FlowLayout());
        this.crudButtons.setBorder(new RectangleRoundedBorder(Color.WHITE, 0, 5));
        this.crudButtons.setBackground(OfficeMateTheme.SPLIT_BORDER_COLOR);
    }

    public void createDefaultButtonsToolbar(Action backAction, String stateTitle, List<Action> defaultActions) {
        this.title = new JLabel(stateTitle);
        Font biggerDefaultFont = this.getFont().deriveFont(16.0f);
        this.title.setFont(biggerDefaultFont);
        this.title.setForeground(OfficeMateTheme.BACK);
        JButton backButton = this.buttonRenderer.renderDefaultToolbarButton((BasicAction)backAction);
        backButton.setName("back");
        backButton.setBorderPainted(true);
        backButton.setHideActionText(true);
        this.backHolder = new JPanel();
        this.backHolder.setLayout(new BoxLayout(this.backHolder, 0));
        this.backHolder.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.backHolder.add(backButton);
        this.backHolder.add(this.title);
        this.backHolder.setOpaque(false);
        for (Action action : defaultActions) {
            JButton createdButton = this.buttonRenderer.renderDefaultToolbarButton((BasicAction)action);
            if (CRUD_ACTION_NAMES.contains(((BasicAction)action).getText())) {
                this.crudButtons.add(createdButton);
                continue;
            }
            this.buttonsHolder.add(createdButton);
        }
        this.buttonsHolder.add(this.crudButtons);
        this.add((Component)this.defaultButtonsToolbar, "Center");
        this.defaultButtonsToolbar.add((Component)this.backHolder, "Center");
        this.defaultButtonsToolbar.add((Component)this.buttonsHolder, "East");
    }

    public void createStateSpecificToolbar(List<Action> stateSpecificActions) {
        if (stateSpecificActions == null || stateSpecificActions.isEmpty()) {
            return;
        }
        this.stateSpecificToolbar = new JPanel(new FlowLayout(1, 15, 5));
        for (Action action : stateSpecificActions) {
            this.stateSpecificToolbar.add(this.buttonRenderer.renderStateSpecificButton(action));
        }
        this.add((Component)this.stateSpecificToolbar, "South");
    }
}

