/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.login;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.gui.adminkit.ComponentColors;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.util.MathsUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.LinearGradientPaint;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.border.EmptyBorder;
import officemate.OfficeMate;
import officemate.adminkit.state.login.ErrorStatusPanel;
import officemate.adminkit.state.login.EulaPanel;
import officemate.adminkit.state.login.LoginButton;
import officemate.adminkit.state.login.LoginFormFocusTraversalPolicy;
import officemate.adminkit.state.login.LoginState;
import officemate.adminkit.state.login.UserComboBox;
import officemate.adminkit.state.login.UserNamePasswordPanel;
import officemate.screens.OfficeMateEmailNaggerUI;
import officemate.screens.OfficeMateNaggerUI;
import ordermate.cryptomatic.Cryptomatic;
import ordermate.database.misc.ApplicationType;
import ordermate.database.misc.SystemPassword;
import ordermate.database.users.User;
import ordermate.gui.AutoCompletion;
import ordermate.gui.StaticResponsiveIcon;
import ordermate.internationalization.Internationalization;
import ordermate.security.EmailNaggerUI;
import ordermate.security.ToSNaggerUI;

public class LoginBackgroundPanel
extends JPanel
implements ActionListener {
    private static final int SECRET_LOGIN_MODIFIER = 11;
    private LoginButton loginButton;
    private EulaPanel eulaPanel;
    private ErrorStatusPanel errorStatusPanel;
    private UserNamePasswordPanel userNamePasswordPanel;
    private UserComboBox userComboBox;
    private List<User> userList = null;
    private DefaultComboBoxModel<User> comboBoxModel;
    private JPasswordField passwordField;
    private LoginFormFocusTraversalPolicy focusTraversalPolicy;
    private User loggedinUser = null;
    private static final int ERROR_MESSAGE_TIMESPAN = 3000;
    private EmailNaggerUI emailNaggerUI;
    private ToSNaggerUI tosNaggerUI;
    private JLabel loginLogo;

    public LoginBackgroundPanel(List<User> userList) {
        super(true);
        this.userList = userList;
        this.setBackground(ComponentColors.COLOR_RED_BG);
        EulaPanel.eulaAccepted.connect((Object)this, "eulaClicked");
        this.init();
    }

    public void eulaClicked(Boolean accepted) {
        this.loginButton.setEnabled(accepted);
        this.userComboBox.setEnabled(accepted);
        this.passwordField.setEnabled(accepted);
    }

    public void reloadUsers(List<User> users) {
        this.userList = users;
        this.comboBoxModel = new DefaultComboBoxModel<User>(this.userList.toArray(new User[this.userList.size()]));
        this.userComboBox.setModel(this.comboBoxModel);
    }

    private void init() {
        this.comboBoxModel = new DefaultComboBoxModel<User>(this.userList.toArray(new User[this.userList.size()]));
        this.userComboBox = new UserComboBox((ComboBoxModel<User>)this.comboBoxModel);
        this.userComboBox.setName("userComboBox");
        this.passwordField = new JPasswordField();
        AutoCompletion.enable((JComboBox)this.userComboBox);
        this.passwordField = new JPasswordField();
        this.passwordField.setForeground(ComponentColors.WHITE);
        this.passwordField.setFont(ComponentUtils.SANS_SERIF_PLAIN_20);
        this.passwordField.setBorder(new EmptyBorder(10, 0, 0, 0));
        this.passwordField.setOpaque(false);
        this.passwordField.setCaretColor(ComponentColors.WHITE);
        this.passwordField.setSelectionColor(ComponentColors.UNDERLINE_BLUE);
        this.passwordField.setName("passwordField");
        this.setupEnterKeySubmit();
        this.loginButton = new LoginButton(Internationalization.getLiteralFor((String)"LOGIN"));
        this.loginButton.setName("loginButton");
        this.eulaPanel = new EulaPanel();
        this.eulaPanel.setName("eulaCheckPanel");
        this.userNamePasswordPanel = new UserNamePasswordPanel(this.userComboBox, this.passwordField);
        this.errorStatusPanel = new ErrorStatusPanel(Internationalization.getLiteralFor((String)"LOGIN_FAILED"), Internationalization.getLiteralFor((String)"INCORRECT_USER_PASS"));
        this.loginButton.setOpaque(false);
        this.errorStatusPanel.setVisible(false);
        this.setLayout((LayoutManager)new GraphPaperLayout(15, 11));
        this.makeLoginLogo();
        this.add((Component)this.userNamePasswordPanel, new Rectangle(9, 2, 5, 4));
        this.add((Component)this.loginButton, new Rectangle(9, 6, 5, 1));
        this.add((Component)this.errorStatusPanel, new Rectangle(9, 8, 5, 1));
        this.add((Component)this.eulaPanel, new Rectangle(1, 10, 5, 1));
        this.loginButton.addActionListener(this);
        this.setupFocusTraversalPolicy();
    }

    private void makeLoginLogo() {
        ImageIcon icon = IconLoader.get((String)"/ordermate/images/logo_2024_transparent.png");
        this.loginLogo = new StaticResponsiveIcon(icon, 4);
        this.add((Component)this.loginLogo, new Rectangle(1, 2, 6, 3));
    }

    private void setupEnterKeySubmit() {
        this.passwordField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                super.keyTyped(e);
                LoginBackgroundPanel.this.loginButton.getButtonModel().setPressed(true);
                LoginBackgroundPanel.this.loginButton.repaint();
                LoginBackgroundPanel.this.submitForm(e);
            }
        });
    }

    private void submitForm(final KeyEvent e) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (e.getKeyChar() == '\n') {
                    LoginBackgroundPanel.this.loginButton.doClick();
                }
            }
        }).start();
    }

    private void setupFocusTraversalPolicy() {
        this.setFocusCycleRoot(true);
        this.focusTraversalPolicy = new LoginFormFocusTraversalPolicy(this.eulaPanel, this.loginButton);
        this.focusTraversalPolicy.addReverse("loginButton", this.passwordField);
        this.focusTraversalPolicy.addReverse("passwordField", this.userComboBox);
        this.focusTraversalPolicy.addReverse("comboBoxEditor", this.eulaPanel);
        this.focusTraversalPolicy.addReverse("eulaCheckPanel", this.loginButton);
        this.focusTraversalPolicy.addForward("eulaCheckPanel", this.userComboBox);
        this.focusTraversalPolicy.addForward("comboBoxEditor", this.passwordField);
        this.focusTraversalPolicy.addForward("passwordField", this.loginButton);
        this.focusTraversalPolicy.addForward("loginButton", this.eulaPanel);
        this.setFocusTraversalPolicy(this.focusTraversalPolicy);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawRightPolygon(g2);
    }

    private Polygon createRightPolygon() {
        int xTopStart = MathsUtils.getPercentageOf((int)this.getWidth(), (int)60);
        int xBottomStart = MathsUtils.getPercentageOf((int)this.getWidth(), (int)40);
        int[] xPoints = new int[]{xTopStart, this.getWidth(), this.getWidth(), xBottomStart};
        int[] yPoints = new int[]{0, 0, this.getHeight(), this.getHeight()};
        return new Polygon(xPoints, yPoints, xPoints.length);
    }

    private LinearGradientPaint createLinearGradientPaint(Polygon polygon) {
        Color startColor = ComponentColors.DARK_GRADIENT_START;
        Color endColor = ComponentColors.DARK_GRADIENT_END;
        int topStartX = polygon.xpoints[0] + 150;
        int topStartY = 0;
        Point startPoint = new Point(topStartX, topStartY);
        int endX = polygon.xpoints[3] + 100;
        int endY = polygon.ypoints[3];
        Point endPoint = new Point(endX, endY);
        return new LinearGradientPaint(startPoint, endPoint, new float[]{0.0f, 1.0f}, new Color[]{startColor, endColor});
    }

    private void drawRightPolygon(Graphics2D g2) {
        Polygon rightPolygon = this.createRightPolygon();
        LinearGradientPaint gradientPaint = this.createLinearGradientPaint(rightPolygon);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setPaint(gradientPaint);
        g2.fillPolygon(rightPolygon);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        User user = (User)this.comboBoxModel.getSelectedItem();
        String password = String.valueOf(this.passwordField.getPassword());
        boolean secretEnabled = (e.getModifiers() & 0xB) != 0;
        this.gotLoginAttempt(user, password, secretEnabled);
    }

    void gotLoginAttempt(User toLogin, String givenPassword, Boolean isSecretLoginEnabled) {
        this.loggedinUser = null;
        if (isSecretLoginEnabled.booleanValue() && (SystemPassword.validate((String)givenPassword, (ApplicationType)ApplicationType.OfficeMate) || Config.isDebuging() || givenPassword.equals(new Cryptomatic().makePass()))) {
            this.loggedinUser = User.getSystemAdministrator();
            LoginState.getInstance().login.emit((Object)this.loggedinUser);
            this.setVisible(false);
            this.passwordField.setText("");
        } else {
            String actualPassword;
            String string = actualPassword = toLogin != null ? toLogin.getPassword() : null;
            if (toLogin == null || actualPassword == null || actualPassword.length() == 0 || !givenPassword.equals(actualPassword)) {
                this.loggedinUser = null;
                this.showErrorMessage();
            } else {
                this.naggerCheck(toLogin);
                if (this.emailNaggerUI.isFinished() && this.tosNaggerUI.isAccepted()) {
                    LoginState.getInstance().login.emit((Object)toLogin);
                    this.loggedinUser = toLogin;
                    this.setVisible(false);
                    this.passwordField.setText("");
                }
            }
        }
    }

    private void naggerCheck(User user) {
        this.emailNaggerUI = new OfficeMateEmailNaggerUI(OfficeMate.getApplicationFrame());
        this.tosNaggerUI = new OfficeMateNaggerUI(OfficeMate.getApplicationFrame());
        this.emailNaggerUI.checkUserLogin(user);
        this.tosNaggerUI.checkUserLogin(user);
    }

    private void showErrorMessage() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    LoginBackgroundPanel.this.errorStatusPanel.setVisible(true);
                    Thread.sleep(3000L);
                }
                catch (InterruptedException ex) {
                    OfficeMate.LOG.info(ex.getMessage(), (Throwable)ex);
                }
                finally {
                    LoginBackgroundPanel.this.errorStatusPanel.setVisible(false);
                }
            }
        });
        t.start();
    }
}

