/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.reports.closedaccounts;

import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.Price;
import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.columnformats.DiscountColumnFormat;
import officemate.adminkit.columnformats.FinanceTransactionColumnFormat;
import officemate.adminkit.columnformats.SalesItemColumnFormat;
import officemate.adminkit.columnformats.SurchargeColumnFormat;
import officemate.components.table.PersistentObjectTable;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.misc.SystemProperty;
import ordermate.database.queries.reports.AdjustmentsReportQueries;
import ordermate.database.reports.AdjustmentsReport;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.AbstractTakeawayAccount;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.SalesOption;

public class AccountSummaryPanel
extends JPanel {
    private JLabel headerLabel;
    private JLabel itemTotalLabel;
    private JLabel itemDueLabel;
    private JLabel transTotalLabel;
    private JLabel surchargeTotalLabel;
    private JLabel discountTotalLabel;
    private Account currentAccount;
    private EventList itemsList;
    private EventList transactionList;
    private EventList surchargeList;
    private EventList discountList;
    private PersistentObjectTable transactionTable;
    private PersistentObjectTable itemsTable;
    private PersistentObjectTable surchargeTable;
    private PersistentObjectTable discountTable;

    public AccountSummaryPanel() {
        super(new BorderLayout());
        this.setupComponents();
    }

    private void setupComponents() {
        JPanel headerPanel = new JPanel();
        this.headerLabel = new JLabel();
        headerPanel.add(this.headerLabel);
        this.add((Component)headerPanel, "North");
        JPanel centerHolder = new JPanel();
        centerHolder.setLayout((LayoutManager)new GraphPaperLayout(1, 6));
        JPanel itemsPanel = new JPanel(new BorderLayout());
        itemsPanel.setBorder(new TitledBorder("Items"));
        this.itemsList = new BasicEventList();
        this.itemsTable = new PersistentObjectTable(this.itemsList, new SalesItemColumnFormat());
        itemsPanel.add((Component)this.itemsTable, "Center");
        JPanel totalsPanel = new JPanel(new FlowLayout(2, 5, 0));
        totalsPanel.add(new JLabel("Total:"));
        this.itemTotalLabel = new JLabel("-");
        totalsPanel.add(this.itemTotalLabel);
        totalsPanel.add(new JLabel("Due:"));
        this.itemDueLabel = new JLabel("-");
        totalsPanel.add(this.itemDueLabel);
        itemsPanel.add((Component)totalsPanel, "South");
        JPanel transPanel = new JPanel(new BorderLayout());
        transPanel.setBorder(new TitledBorder("Transactions"));
        this.transactionList = new BasicEventList();
        this.transactionTable = new PersistentObjectTable(this.transactionList, new FinanceTransactionColumnFormat());
        transPanel.add((Component)this.transactionTable, "Center");
        totalsPanel = new JPanel(new FlowLayout(2, 5, 0));
        totalsPanel.add(new JLabel("Transaction Total:"));
        this.transTotalLabel = new JLabel("-");
        totalsPanel.add(this.transTotalLabel);
        transPanel.add((Component)totalsPanel, "South");
        JPanel surchargePanel = new JPanel(new BorderLayout());
        surchargePanel.setBorder(new TitledBorder("Surcharges"));
        this.surchargeList = new BasicEventList();
        this.surchargeTable = new PersistentObjectTable(this.surchargeList, new SurchargeColumnFormat());
        surchargePanel.add((Component)this.surchargeTable, "Center");
        totalsPanel = new JPanel(new FlowLayout(2, 0, 0));
        totalsPanel.add(new JLabel("Surcharge Total: $"));
        this.surchargeTotalLabel = new JLabel("0.00");
        totalsPanel.add(this.surchargeTotalLabel);
        surchargePanel.add((Component)totalsPanel, "South");
        JPanel discountPanel = new JPanel(new BorderLayout());
        discountPanel.setBorder(new TitledBorder("Discounts"));
        this.discountList = new BasicEventList();
        this.discountTable = new PersistentObjectTable(this.discountList, new DiscountColumnFormat());
        discountPanel.add((Component)this.discountTable, "Center");
        totalsPanel = new JPanel(new FlowLayout(2, 0, 0));
        totalsPanel.add(new JLabel("Discount Total: $"));
        this.discountTotalLabel = new JLabel("0.00");
        totalsPanel.add(this.discountTotalLabel);
        discountPanel.add((Component)totalsPanel, "South");
        centerHolder.add((Component)itemsPanel, new Rectangle(0, 0, 1, 3));
        centerHolder.add((Component)surchargePanel, new Rectangle(0, 3, 1, 1));
        centerHolder.add((Component)discountPanel, new Rectangle(0, 4, 1, 1));
        centerHolder.add((Component)transPanel, new Rectangle(0, 5, 1, 1));
        this.add((Component)centerHolder, "Center");
        this.itemsTable.setName("items");
        this.itemTotalLabel.setName("itemTotal");
        this.itemDueLabel.setName("itemDue");
        this.transactionTable.setName("transactions");
        this.transTotalLabel.setName("transTotal");
    }

    private void processOptions(SalesComponent salesComponent) {
        if (!salesComponent.hasOption()) {
            return;
        }
        for (SalesOption salesOption : salesComponent.getCurrentOptions()) {
            this.itemsList.add((Object)salesOption);
        }
    }

    private void processPluses(SalesComponent salesComponent) {
        if (!salesComponent.hasPlusses()) {
            return;
        }
        for (SalesAdd salesAdd : salesComponent.getCurrentPluses()) {
            this.itemsList.add((Object)salesAdd);
        }
    }

    private void processMinus(SalesComponent salesComponent) {
        if (!salesComponent.hasMinuses()) {
            return;
        }
        for (AbstractSalesRemove abstractSalesRemove : salesComponent.getCurrentMinuses()) {
            this.itemsList.add((Object)abstractSalesRemove);
        }
    }

    private void processSalesItem(SalesItem salesItem) {
        for (SalesComponent salesComponent : salesItem.getComponentList()) {
            this.processOptions(salesComponent);
            this.processPluses(salesComponent);
            this.processMinus(salesComponent);
        }
    }

    private void processSalesLineItem(SalesLineItem salesLineItem) {
        this.itemsList.add((Object)salesLineItem);
        for (SalesItem salesItem : salesLineItem.getSalesItems()) {
            this.processSalesItem(salesItem);
        }
    }

    private void processItemsForComponents(Account newAccount) {
        this.itemsList.clear();
        this.surchargeList.clear();
        this.discountList.clear();
        this.surchargeTotalLabel.setText("0.00");
        this.discountTotalLabel.setText("0.00");
        List allItems = newAccount.getAllItems();
        for (SalesLineItem salesLineItem : allItems) {
            this.processSalesLineItem(salesLineItem);
        }
    }

    private void processForItemDiscounts(Account account) {
        List adjustmentsReports = PersistenceManager.getObjectList(AdjustmentsReport.class, (String)AdjustmentsReportQueries.getItemLevelAdjustmentForAccount((Account)account, (PriceAdjustmentDirection)PriceAdjustmentDirection.DISCOUNT).toString(), null);
        for (AdjustmentsReport adjustmentsReport : adjustmentsReports) {
            this.discountList.add((Object)adjustmentsReport);
            this.addToDiscountTotal(adjustmentsReport.getSavedTotal());
        }
    }

    private void processForItemSurcharges(Account account) {
        List adjustmentsReports = PersistenceManager.getObjectList(AdjustmentsReport.class, (String)AdjustmentsReportQueries.getItemLevelAdjustmentForAccount((Account)account, (PriceAdjustmentDirection)PriceAdjustmentDirection.SURCHARGE).toString(), null);
        for (AdjustmentsReport adjustmentsReport : adjustmentsReports) {
            this.surchargeList.add((Object)adjustmentsReport);
            this.addToSurchargeTotal(adjustmentsReport.getSavedTotal());
        }
    }

    private void addToDiscountTotal(Price savedTotal) {
        BigDecimal bigDecimal = new BigDecimal(this.discountTotalLabel.getText());
        bigDecimal = bigDecimal.add(savedTotal.toBigDecimal().abs());
        this.discountTotalLabel.setText(bigDecimal.toString());
    }

    private void addToSurchargeTotal(Price savedTotal) {
        BigDecimal bigDecimal = new BigDecimal(this.surchargeTotalLabel.getText());
        bigDecimal = bigDecimal.add(savedTotal.toBigDecimal().abs());
        this.surchargeTotalLabel.setText(bigDecimal.toString());
    }

    private void processPriceAdjustments(Account account) {
        this.processForItemDiscounts(account);
        this.processForItemSurcharges(account);
        List adjustments = account.getPriceAdjustments();
        for (SalesPriceAdjustment spa : adjustments) {
            this.processForAccountDiscount(spa);
            this.processForAccountSurcharge(spa);
        }
    }

    private void processForAccountDiscount(SalesPriceAdjustment spa) {
        if (!spa.getDirection().equals((Object)PriceAdjustmentDirection.DISCOUNT)) {
            return;
        }
        this.discountList.add((Object)spa);
        this.addToDiscountTotal(spa.getSavedValue());
    }

    private void processForAccountSurcharge(SalesPriceAdjustment spa) {
        if (!spa.getDirection().equals((Object)PriceAdjustmentDirection.SURCHARGE)) {
            return;
        }
        this.surchargeList.add((Object)spa);
        this.addToSurchargeTotal(spa.getSavedValue());
    }

    public void setAccount(Account newAccount) {
        this.currentAccount = newAccount;
        this.processItemsForComponents(newAccount);
        this.processPriceAdjustments(newAccount);
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.transactionList, newAccount.getFinanceTransactions());
        this.headerLabel.setText(this.getHeaderLabelForAccount(newAccount));
        this.itemTotalLabel.setText(this.currentAccount.getTotal().toString(true));
        this.itemDueLabel.setText(this.currentAccount.getDue().toString(true));
        this.transTotalLabel.setText(this.currentAccount.getPaid().toString(true));
    }

    private String getHeaderLabelForAccount(Account account) {
        if (!SystemProperty.getInstance().isShowAccId() && (AccountType.driveThruType.equals((Object)account.getAccountType()) || AccountType.takeawayType.equals((Object)account.getAccountType()))) {
            return ((AbstractTakeawayAccount)account).getLabelNoInternalOrderNumber();
        }
        return account.getLabel();
    }
}

