/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.reports.closedaccounts;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.search.pager.Pager;
import au.com.ordermate.search.pager.PagerModel;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import officemate.adminkit.state.reports.closedaccounts.AccountPropertySearch;
import officemate.adminkit.state.reports.closedaccounts.AccountSummaryPanel;
import officemate.adminkit.state.reports.closedaccounts.ClosedAccountsTotalsPanel;
import officemate.adminkit.state.reports.closedaccounts.actions.DownloadTaxInvoiceAction;
import officemate.adminkit.state.reports.closedaccounts.actions.OfficeMateEmailTaxInvoiceAction;
import officemate.adminkit.state.reports.closedaccounts.actions.TrainingModeAction;
import officemate.components.OfficeMateObjectSearch;
import officemate.components.table.AbstractTableState;
import officemate.components.table.PersistentObjectTable;
import officemate.components.table.TableStateCentralArea;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.PropertyAccessorListColumnFormat;
import ordermate.OrderMate;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceUnit;
import ordermate.database.misc.SystemProperty;
import ordermate.database.sales.AbstractTakeawayAccount;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountType;
import ordermate.database.searchers.sales.AccountSearcher;
import ordermate.database.users.Permission;
import ordermate.gui.binding.ColumnVisibilityHelper;
import ordermate.integration.cloudback.nudge.NudgeUtil;
import ordermate.reports.table.AbstractColumnFormat;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class ClosedAccountsReportState
extends AbstractTableState<Account> {
    private AccountSummaryPanel summaryPanel;
    private ClosedAccountsTotalsPanel totalsPanel;
    private final AccountSearcher searcher;
    private JDialog summaryDialog;
    private AccountPropertySearch search;
    private final PagerModel listPager = new PagerModel(10000);

    public ClosedAccountsReportState(AccountSearcher theSearcher, Permission permission) {
        super("Closed Accounts", permission, "Search and filter closed accounts");
        this.searcher = theSearcher;
        this.searcher.setAccountOpen(false);
    }

    @Override
    protected OfficeMateObjectSearch createSearchPanelFactory() {
        this.search = new AccountPropertySearch(this.searcher, (Refreshable)this);
        this.searcher.setAccountOpen(false);
        this.search.usePagedObjectQueryRefreshStrategy((Pager)this.listPager);
        return this.search;
    }

    @Override
    protected void init() {
        if (this.initCalled) {
            return;
        }
        super.init();
        this.totalsPanel = new ClosedAccountsTotalsPanel(this.getObjectList(), this.getCentralArea().getTable());
        this.addStatusComponent(this.totalsPanel, "East");
        if (SystemProperty.getInstance().isTrainingModeEnabled()) {
            this.addSelectionDependentAction((Action)((Object)new TrainingModeAction(this)));
        }
        this.addSelectionDependentAction((Action)((Object)new DownloadTaxInvoiceAction(this)));
        this.addSelectionDependentAction((Action)((Object)new OfficeMateEmailTaxInvoiceAction(this, new NudgeUtil())));
        this.addPageControl(this.listPager);
    }

    protected ColumnFormat[] getColumnFormat() {
        ArrayList<ColumnFormat> columnFormat = new ArrayList<ColumnFormat>(){
            {
                if (SystemProperty.getInstance().isShowAccId()) {
                    this.add(new PropertyColumnFormat("Receipt #", Account.Properties.ID));
                }
                this.add(new PropertyColumnFormat("Date", Account.Properties.CREATION_DATE_TIME).setFormatter((Format)new SimpleDateFormat("dd/MM/yyyy")));
                this.add(new PropertyColumnFormat("Time", (PropertiedObject.Property)Account.Properties.CREATION_TIME).setFormatter((Format)new SimpleDateFormat("HH:mm")));
                this.add(new PropertyColumnFormat("Opened By", Account.Properties.OPENING_USER));
                this.add(new PropertyColumnFormat("Closed By", Account.Properties.CLOSING_USER));
                this.add(new PropertyColumnFormat(Account.Properties.ACCOUNT_TYPE));
                if (SystemProperty.getInstance().isShowAccId()) {
                    this.add(new PropertyColumnFormat("Description", (PropertiedObject.Property)Account.Properties.RENDERER_LABEL));
                } else {
                    this.add(new AbstractColumnFormat("Description", String.class){

                        public Object resolveColumnValue(Object baseObject) {
                            Account account = (Account)baseObject;
                            if (AccountType.takeawayType.equals((Object)account.getAccountType())) {
                                return account.getAccountType().getLabel();
                            }
                            if (AccountType.driveThruType.equals((Object)account.getAccountType())) {
                                return ((AbstractTakeawayAccount)account).getLabelNoInternalOrderNumber();
                            }
                            return account.getRendererLabel();
                        }
                    });
                }
                this.add(new AbstractColumnFormat("Order Source", String.class){

                    public Object resolveColumnValue(Object baseObject) {
                        Account account = (Account)baseObject;
                        return account.getSource();
                    }
                });
                this.add(new AbstractColumnFormat("Voucher Activity", String.class){

                    public Object resolveColumnValue(Object baseObject) {
                        Account account = (Account)baseObject;
                        List vTxns = account.getVoucherTxns();
                        if (vTxns != null && !vTxns.isEmpty()) {
                            return "Yes";
                        }
                        return "No";
                    }
                });
                this.add(new PropertyColumnFormat("Total", Account.Properties.SAVED_TOTAL));
                this.add(new PropertyAccessorListColumnFormat("Payment Type", new PropertiedObject.Property[]{Account.Properties.ALL_FINANCE_TRANSACTIONS, FinanceTransaction.Properties.SUB_TYPE, FinanceUnit.Properties.LABEL}, null){

                    public Object resolveColumnValue(Object baseObject) {
                        List transactions;
                        ArrayList<String> result = new ArrayList<String>();
                        if (baseObject instanceof Account && (transactions = ((Account)baseObject).getFinanceTransactions()) != null && !transactions.isEmpty()) {
                            for (FinanceTransaction ta : transactions) {
                                if (!"ACTIVE".equals(ta.getSystemState()) || ta.getSubType() == null || result.contains(ta.getSubType().getLabel())) continue;
                                result.add(ta.getSubType().getLabel());
                            }
                        }
                        return result;
                    }
                });
                this.add(new PropertyColumnFormat(Account.Properties.CUSTOMER));
                this.add(new PropertyAccessorListColumnFormat("Terminal", new PropertiedObject.Property[]{Account.Properties.ALL_FINANCE_TRANSACTIONS, FinanceTransaction.Properties.TERMINAL}, null));
                this.add(new PropertyAccessorListColumnFormat("Cashdrawer", new PropertiedObject.Property[]{Account.Properties.ALL_FINANCE_TRANSACTIONS, FinanceTransaction.Properties.CASH_DRAWER}, null));
            }
        };
        ColumnFormat[] format = columnFormat.toArray(new ColumnFormat[0]);
        return format;
    }

    @Override
    protected TableStateCentralArea createCentralArea() {
        PropertiedObject.Property[] hiddenProps = new PropertiedObject.Property[]{FinanceTransaction.Properties.TERMINAL, FinanceTransaction.Properties.CASH_DRAWER, FinanceUnit.Properties.LABEL, Account.Properties.CUSTOMER};
        ColumnFormat[] colFormat = this.getColumnFormat();
        PersistentObjectTable centralArea = new PersistentObjectTable(this.getObjectList(), new ColumnTableFormat(colFormat), hiddenProps);
        ColumnVisibilityHelper showCustomerCheckHelper = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{Account.Properties.CUSTOMER}, new JCheckBox("Show Customers"), centralArea.getTable());
        ColumnVisibilityHelper showTerminalCheckHelper = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{FinanceTransaction.Properties.TERMINAL, FinanceTransaction.Properties.CASH_DRAWER}, new JCheckBox("Show Terminal, CashDrawer"), centralArea.getTable());
        ColumnVisibilityHelper showPaymentType = new ColumnVisibilityHelper((Object[])new PropertiedObject.Property[]{FinanceUnit.Properties.LABEL}, new JCheckBox("Show Payment Type"), centralArea.getTable());
        ColumnVisibilityHelper showOrderSource = new ColumnVisibilityHelper((Object[])new String[]{"Order Source"}, new JCheckBox("Show Order Source"), centralArea.getTable());
        ColumnVisibilityHelper showVoucherActivity = new ColumnVisibilityHelper((Object[])new String[]{"Voucher Activity"}, new JCheckBox("Show Voucher Activity"), centralArea.getTable());
        JPanel helperPanel = new JPanel(new FlowLayout(2));
        helperPanel.add(showCustomerCheckHelper.getCheckBox());
        helperPanel.add(showTerminalCheckHelper.getCheckBox());
        helperPanel.add(showPaymentType.getCheckBox());
        helperPanel.add(showOrderSource.getCheckBox());
        helperPanel.add(showVoucherActivity.getCheckBox());
        this.getControlPanel().add((Component)helperPanel, "South");
        return centralArea;
    }

    @Override
    protected Class getDisplayingType() {
        return Account.class;
    }

    @Override
    public void gotObjectDoubleClicked(Account toEdit) {
        if (toEdit == null) {
            OrderMate.LOG.warn("Got null object to edit in closedAccountReportState", (Throwable)new Exception());
            return;
        }
        this.showSummaryDialog(toEdit);
    }

    private void showSummaryDialog(Account toEdit) {
        if (this.summaryPanel == null) {
            this.summaryPanel = new AccountSummaryPanel();
            this.summaryDialog = new JDialog(GuiApp.getAppComplex().getApplicationFrame().getFrame());
            this.summaryDialog.setPreferredSize(new Dimension(640, GuiApp.getAppComplex().getApplicationFrame().getFrame().getHeight()));
            this.summaryDialog.add((Component)this.summaryPanel, "Center");
            this.summaryDialog.setModal(true);
            JPanel butPanel = new JPanel(new FlowLayout(2));
            JButton okBut = new JButton(IconLoader.get((String)"/ordermate/images/button_ok.png"));
            butPanel.add(okBut);
            okBut.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ClosedAccountsReportState.this.summaryDialog.setVisible(false);
                }
            });
            this.summaryDialog.add((Component)butPanel, "South");
        }
        this.summaryPanel.setAccount(toEdit);
        if (!SystemProperty.getInstance().isShowAccId() && (AccountType.driveThruType.equals((Object)toEdit.getAccountType()) || AccountType.takeawayType.equals((Object)toEdit.getAccountType()))) {
            this.summaryDialog.setTitle(((AbstractTakeawayAccount)toEdit).getLabelNoInternalOrderNumber() + " Summary");
        } else {
            this.summaryDialog.setTitle(toEdit.toString() + " Summary");
        }
        this.summaryDialog.pack();
        this.summaryDialog.setLocationRelativeTo(GuiApp.getAppComplex().getApplicationFrame().getFrame());
        this.summaryDialog.setVisible(true);
    }

    @Override
    public void refresh() {
        if (this.totalsPanel != null) {
            this.totalsPanel.clearTotals();
        }
        if (this.search != null) {
            this.search.reaquireSearchOptions();
        }
        super.refresh();
    }

    @Override
    protected void postRefresh() {
        super.postRefresh();
        this.getCentralArea().getTable().clearSelection();
        this.totalsPanel.updateTotals();
    }

    public AccountSearcher getSearcher() {
        return this.searcher;
    }
}

