/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.reports.closedaccounts.actions;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.PermissibleAction;
import au.com.ordermate.message.Email;
import au.com.ordermate.util.HtmlUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import officemate.OfficeMate;
import officemate.adminkit.dialogs.DefaultOkCancelDialogHandler;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.adminkit.state.login.LoginState;
import officemate.components.table.AbstractTableState;
import ordermate.OrderMate;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.sales.Account;
import ordermate.database.sales.ItemGroup;
import ordermate.database.users.AllPermissions;
import ordermate.gui.FieldPanelBuilder;
import ordermate.integration.cloudback.nudge.NudgeUtil;
import ordermate.integration.nudgeback.EmailBuilder;
import ordermate.reports.printing.InvoiceReport;

public class OfficeMateEmailTaxInvoiceAction
extends PermissibleAction {
    private final AbstractTableState<Account> refreshableState;
    private final NudgeUtil nudgeUtil;
    private boolean guard = true;
    private static final int TEXT_FIELD_COLUMNS = 35;
    private static final int TEXT_FIELD_ROWS = 7;

    public OfficeMateEmailTaxInvoiceAction(AbstractTableState<Account> state, NudgeUtil nudgeUtil) {
        super("Email Tax Invoice", AllPermissions.EMAIL_TAX_INVOICES, LoginState.getInstance().login, (Icon)IconLoader.get((String)"/ordermate/images/print_icon22.png"), "Emails a PDF copy of the account tax invoice(s)", GuiApp.getAppComplex().getApplicationSecurity().getUser());
        this.refreshableState = state;
        this.nudgeUtil = nudgeUtil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        AbstractTableState<Account> abstractTableState = this.refreshableState;
        synchronized (abstractTableState) {
            boolean isEnabled = this.isEnabled();
            this.setEnabled(false);
            if (this.guard && isEnabled) {
                this.guard = false;
                this.createAndSendInvoiceEmail(this.refreshableState.getCentralArea().getAllSelectedObjects());
            }
            this.guard = true;
        }
    }

    private void createAndSendInvoiceEmail(List<Account> selectedAccounts) {
        EmailBuilder emailBuilder = this.getBaseEmailFromDialog(selectedAccounts);
        if (emailBuilder == null) {
            return;
        }
        List<File> createdFiles = this.generateTemporaryInvoices(selectedAccounts);
        Email email = emailBuilder.addAttachments(createdFiles).build();
        boolean emailSuccess = this.nudgeUtil.sendEmail(email);
        if (emailSuccess) {
            Dialogs.showMessageDialog("Email tax invoices...", "Success!");
        } else {
            Dialogs.showMessageDialog("Email tax invoices...", "Failed!");
        }
    }

    private EmailBuilder getBaseEmailFromDialog(List<Account> selectedAccounts) {
        JTextField recipientsTextField = new JTextField(35);
        JTextField subjectTextField = new JTextField(this.createDefaultSubjectText(selectedAccounts), 35);
        JTextArea bodyTextArea = this.getEmailBodyTextArea();
        JScrollPane scrollPane = new JScrollPane(bodyTextArea);
        scrollPane.setVerticalScrollBarPolicy(20);
        OkCancelDialogBuilder dialogBuilder = this.getEmailDialog(recipientsTextField, subjectTextField, bodyTextArea, selectedAccounts);
        boolean okConfirmed = dialogBuilder.doShow();
        if (!okConfirmed) {
            return null;
        }
        return new EmailBuilder(subjectTextField.getText(), bodyTextArea.getText(), true, recipientsTextField.getText());
    }

    private List<File> generateTemporaryInvoices(List<Account> selectedAccounts) {
        ArrayList<String> createdFileNames = new ArrayList<String>();
        for (Account account : selectedAccounts) {
            try {
                String businessNameNoSpaces = BusinessInfo.getInstance().getName().replace(' ', '_');
                String fileName = String.format("C:\\Temp\\%s-Tax_Invoice-%s.pdf", businessNameNoSpaces, account.getID());
                InvoiceReport invoiceReport = new InvoiceReport((ItemGroup)account, "/ordermate/reports/printing/InvoiceReportA4.jrxml", "Invoice Report A4 Path");
                invoiceReport.generate();
                JasperPrintManager.printReportToPdfFile((JasperPrint)invoiceReport.getReport(), (String)fileName);
                createdFileNames.add(fileName);
            }
            catch (JRException ex) {
                OrderMate.LOG.error("Failed to generate InvoiceReport or print InvoiceReport to PDF for Account " + account.getID(), (Throwable)ex);
            }
        }
        ArrayList<File> files = new ArrayList<File>();
        for (String fileName : createdFileNames) {
            File file = new File(fileName);
            file.deleteOnExit();
            files.add(file);
        }
        return files;
    }

    private OkCancelDialogBuilder getEmailDialog(JTextField recipientsField, JTextField subjectField, JTextArea bodyArea, List<Account> selectedAccounts) {
        String header = this.generateHeaderText(selectedAccounts);
        JPanel body = new JPanel();
        body.setLayout(new BoxLayout(body, 1));
        body.add(new FieldPanelBuilder(4, 10).addRow("Subject", (Component)subjectField).addRow("To", (Component)recipientsField).addRow("", (Component)new JLabel("<html>HINT: separate multiple email addresses with a semicolon (<b>;</b>)</html>")).addRow("Body", (Component)bodyArea).getPanel());
        return Dialogs.getOkCancelDialogBuilder(body).setTitle("Email Tax Invoice...").setHtmlHeader(header).setIsResizable(false).setHandler(new DefaultOkCancelDialogHandler()).doPack();
    }

    private JTextArea getEmailBodyTextArea() {
        JTextArea textArea = new JTextArea(7, 35);
        textArea.setWrapStyleWord(true);
        textArea.setLineWrap(true);
        textArea.setFont(UIManager.getFont("Label.font"));
        textArea.setText(this.createDefaultBodyText());
        return textArea;
    }

    private String generateHeaderText(List<Account> selectedAccounts) {
        StringBuilder sbPre = new StringBuilder();
        sbPre.append("Sending Tax Invoice(s) ");
        for (int i = 0; i < selectedAccounts.size(); ++i) {
            sbPre.append(selectedAccounts.get(i).getID().toString());
            if (i >= selectedAccounts.size() - 1) continue;
            sbPre.append(", ");
        }
        StringBuilder sbPost = new StringBuilder();
        sbPost.append(HtmlUtils.boldColor((String)sbPre.toString(), (String)"black"));
        sbPost.append(HtmlUtils.newline((int)2));
        sbPost.append("The tax invoice will be attached. Enter email body text below (optional).");
        return HtmlUtils.html((String)sbPost.toString());
    }

    private String createDefaultSubjectText(List<Account> accounts) {
        StringBuilder stringBuilder = new StringBuilder("Tax invoices for accounts ");
        for (int i = 0; i < accounts.size(); ++i) {
            stringBuilder.append(accounts.get(i).getID());
            if (i >= accounts.size() - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private String createDefaultBodyText() {
        return "Please find tax invoice(s) attached.\n\nRegards,\n\n" + OfficeMate.getInstance().getEventContext().getUser().getName() + "\n" + BusinessInfo.getInstance().getName() + "\n\n(Powered by OrderMate)\n";
    }
}

