/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.reports.closedaccounts.actions;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.actions.PermissibleAction;
import au.com.ordermate.guicore.Refreshable;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.login.LoginState;
import officemate.adminkit.state.reports.closedaccounts.OfficeMateSaveAccount;
import officemate.components.table.AbstractTableState;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.sales.Account;
import ordermate.database.users.AllPermissions;

public class TrainingModeAction
extends PermissibleAction {
    private final AbstractTableState<Account> refreshableState;
    private boolean guard = true;

    public TrainingModeAction(AbstractTableState<Account> state) {
        super("Assign to Training", AllPermissions.TRAINING_MODE, LoginState.getInstance().login, (Icon)IconLoader.get((String)"/officemate/images/trainingmode24.png"), "Assigns the selected accounts to training", GuiApp.getAppComplex().getApplicationSecurity().getUser());
        this.refreshableState = state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        AbstractTableState<Account> abstractTableState = this.refreshableState;
        synchronized (abstractTableState) {
            boolean isEnabled = this.isEnabled();
            this.setEnabled(false);
            if (this.guard && isEnabled) {
                this.guard = false;
                this.trainingModeSelected();
            }
            this.guard = true;
        }
    }

    private void trainingModeSelected() {
        if (!SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Was expecting EDT");
        }
        List<Account> accounts = this.refreshableState.getCentralArea().getAllSelectedObjects();
        if (accounts.size() < 200 || GuiApp.getAppComplex().getApplicationSecurity().getUser().isSystemAdministrator()) {
            if (accounts.size() >= 200 && !Dialogs.showChoiceDialog("Selected a lot of accounts", "Warning: You have selected " + accounts.size() + " to assign to training, this could take a long time.  Are you sure you want to continue?")) {
                return;
            }
            JProgressBar bar = new JProgressBar();
            bar.setIndeterminate(true);
            JDialog dialog = new JDialog((Frame)GuiApp.getAppComplex().getApplicationFrame().getFrame(), "Allocating to training");
            dialog.setSize(150, 50);
            dialog.setLocationRelativeTo(GuiApp.getAppComplex().getApplicationFrame().getFrame());
            dialog.getContentPane().add(bar);
            dialog.pack();
            dialog.setVisible(true);
            if (!OfficeMateSaveAccount.getInstance().assignToTraining(accounts, new EventContext(Terminal.getServerMateTerminal(), GuiApp.getAppComplex().getApplicationSecurity().getUser()), dialog, (Refreshable)this.refreshableState)) {
                dialog.dispose();
            }
        } else {
            Dialogs.showWarningDialog("Cannot allocate that many accounts", "Too many accounts were selected for training, please selected fewer accounts");
        }
    }
}

