/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.statebuilder;

import au.com.ordermate.application.ApplicationNavigator;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.ApplicationStructure;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.application.StateType;
import au.com.ordermate.guicore.task.AbstractTask;
import au.com.ordermate.guicore.task.GUIStateI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.CompositeGuiState;
import officemate.adminkit.state.GUIState;
import officemate.adminkit.state.statebuilder.OfficeMateBlueprint;
import officemate.adminkit.state.statebuilder.OfficeMateBlueprintArchitecture;
import officemate.screens.OfficeMateComplex;
import ordermate.OrderMate;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class DefaultApplicationNavigator
implements ApplicationNavigator {
    private final Signal<ApplicationStateBlueprint, ?, ?, ?, ?> goTo = Signals.createSignal(ApplicationStateBlueprint.class, (String)"chosenState");
    private final ApplicationStructure currentStructure;
    private boolean shouldResolve = false;

    public DefaultApplicationNavigator(ApplicationStructure structure) {
        this.currentStructure = structure;
    }

    public void navigateTo(Class<? extends GUIStateI> clazzToNavTo) {
        this.navigateTo(clazzToNavTo.getName());
    }

    public void navigateTo(String stateKey) {
        final GUIStateI foundState = this.getState(stateKey);
        if (foundState == null) {
            OrderMate.LOG.error(stateKey + " was not found within the ApplicationStructure. No state change will be called.");
            return;
        }
        if (!this.checkStateIsAccessible(foundState)) {
            OrderMate.LOG.error(stateKey + " cannot be accessed by this user. No state change will be called.");
            return;
        }
        Dialogs.createProgressDialog(new AbstractTask(){

            protected int getTotalSubTasks() {
                return 1;
            }

            protected void performTask() throws Exception {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GUIStateI stateUI = foundState;
                        DefaultApplicationNavigator.this.createMissingState(stateUI.getStateKey());
                        if (DefaultApplicationNavigator.this.checkStateIsAccessible(stateUI)) {
                            if ((stateUI = DefaultApplicationNavigator.this.getLeafState(stateUI.getStateKey())) == null) {
                                stateUI = foundState;
                            }
                            DefaultApplicationNavigator.this.goTo.emit((Object)GuiApp.getAppComplex().getApplicationStructure().getArchitecture().getBlueprint(stateUI.getStateKey()));
                        }
                    }
                });
            }

            public String getName() {
                return "Loading " + foundState.getName();
            }
        }).start();
    }

    private void createMissingState(String stateKey) {
        ((OfficeMateComplex)GuiApp.getAppComplex()).createStateIfNeeded(stateKey);
    }

    private String getRootStateKey(String stateKey) {
        OfficeMateBlueprint blueprint = this.getBlueprint(stateKey);
        if (blueprint == null) {
            return null;
        }
        while (blueprint.getParentStateKey() != null) {
            blueprint = this.getBlueprint(blueprint.getParentStateKey());
        }
        return blueprint.getKey();
    }

    private OfficeMateBlueprint getBlueprint(String stateKey) {
        OfficeMateBlueprintArchitecture archi = (OfficeMateBlueprintArchitecture)GuiApp.getAppComplex().getApplicationStructure().getArchitecture();
        OfficeMateBlueprint bluePrint = archi.getBlueprint(stateKey);
        return bluePrint;
    }

    public void shouldResolve() {
        this.shouldResolve = true;
    }

    protected boolean checkStateIsAccessible(GUIStateI state) {
        return GuiApp.getAppComplex().getApplicationSecurity().stateIsAccessable(state, GuiApp.getAppComplex().getApplicationSecurity().getUser());
    }

    public boolean canNavigateTo(ApplicationStateBlueprint blueprint) {
        GUIStateI foundState = this.currentStructure.getState(blueprint.getKey());
        if (foundState != null) {
            return this.currentStructure.canNavigateTo(blueprint.getKey());
        }
        return GuiApp.getAppComplex().getApplicationSecurity().stateIsAccessable(blueprint.getKey(), GuiApp.getAppComplex().getApplicationSecurity().getUser());
    }

    public GUIStateI getState(String stateKey) {
        if (this.currentStructure == null) {
            throw new IllegalStateException("Cannot find a state without a OfficeMateStructure!");
        }
        ApplicationStateBlueprint blueprint = GuiApp.getAppComplex().getApplicationStructure().getArchitecture().getBlueprint(stateKey);
        if (blueprint == null) {
            OrderMate.LOG.error("Cannot find state for key:" + stateKey);
            return null;
        }
        GUIStateI foundState = this.currentStructure.getState(blueprint.getKey(), this.shouldResolve);
        if (foundState == null) {
            this.createMissingState(blueprint.getKey());
            foundState = this.currentStructure.getState(blueprint.getKey(), this.shouldResolve);
        }
        return foundState;
    }

    public GUIStateI getState(Class<? extends GUIStateI> clazzToGet) {
        return this.getState(clazzToGet.getName());
    }

    public List<String> getMenuPathState(GUIStateI requiredState) {
        ApplicationStateBlueprint requiredBlueprint = this.currentStructure.getArchitecture().getBlueprint(requiredState.getStateKey());
        ArrayList<String> allNames = new ArrayList<String>();
        while (requiredBlueprint != null) {
            GUIStateI state;
            if (!requiredBlueprint.getStateType().equals((Object)StateType.TABBED_STATE) && (state = this.currentStructure.getState(requiredBlueprint.getKey())) != null) {
                allNames.add(state.getName());
            }
            requiredBlueprint = this.currentStructure.getArchitecture().getBlueprint(requiredBlueprint.getParentStateKey());
        }
        Collections.reverse(allNames);
        return allNames;
    }

    public boolean isTab(String requiredStateKey) {
        return StateType.TABBED_STATE.equals((Object)this.currentStructure.getArchitecture().getBlueprint(requiredStateKey).getStateType());
    }

    public Signal<ApplicationStateBlueprint, ?, ?, ?, ?> getNavigationSignal() {
        return this.goTo;
    }

    public GUIStateI getLeafState(String key) {
        if (key == null) {
            OrderMate.LOG.error(key + " is not allowed! returning null state.");
            return null;
        }
        GUIStateI currState = this.getState(key);
        if (currState == null) {
            OrderMate.LOG.error(key + " was not found within the ApplicationStructure.");
            return null;
        }
        if (currState.hasSubStates() && !(currState instanceof CompositeGuiState)) {
            if (currState instanceof BasicOfficeMateState) {
                ((BasicOfficeMateState)currState).chooseValidDefaultSubState();
            }
            if (currState instanceof GUIState) {
                currState = ((GUIState)currState).getDefaultSubState();
            }
            return this.getLeafState(currState.getStateKey());
        }
        if (currState.getParentState() != null && currState.getParentState() instanceof CompositeGuiState) {
            CompositeGuiState parentState = (CompositeGuiState)currState.getParentState();
            parentState.startState();
            parentState.setSelectedTabState(currState);
            return parentState;
        }
        return currState;
    }
}

