/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.statebuilder;

import au.com.ordermate.application.StateBuildCondition;
import au.com.ordermate.application.StateType;
import au.com.ordermate.util.Pair;
import au.com.ordermate.util.image.IconLoader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.CompositeGuiState;
import officemate.adminkit.state.login.LoginState;
import officemate.adminkit.state.reports.closedaccounts.ClosedAccountsCompositeState;
import officemate.adminkit.state.statebuilder.OfficeMateBlueprintArchitecture;
import officemate.adminkit.state.statebuilder.statebuildcondition.AccountingStateBuildCondition;
import officemate.adminkit.state.statebuilder.statebuildcondition.EftposStateBuildCondition;
import officemate.adminkit.state.statebuilder.statebuildcondition.LiquorFileStateBuildCondition;
import officemate.adminkit.state.statebuilder.statebuildcondition.StockControlStateBuildCondition;
import officemate.adminkit.state.users.UsersState;
import officemate.adminkit.state.users.permission.SetupPermissionsState;
import officemate.adminkit.state.users.users.UsersSetupState;
import officemate.adminkit.state.welcome.WelcomeState;
import officemate.components.table.AbstractTableState;
import officemate.screens.customers.CustomerCategoryState;
import officemate.screens.customers.CustomerLoyaltyFunctionsState;
import officemate.screens.customers.CustomersState;
import officemate.screens.customers.LoyaltyPointsState;
import officemate.screens.dailytasks.ItemCountState;
import officemate.screens.dailytasks.accounting.AccountingExportState;
import officemate.screens.debtor.debtorgroups.DebtorGroupState;
import officemate.screens.debtor.debtors.DebtorsState;
import officemate.screens.debtor.debtorsales.DebtorSalesState;
import officemate.screens.favorites.FavoritesState;
import officemate.screens.maintainstock.adjust.StockAdjustmentCompositeState;
import officemate.screens.maintainstock.invoice.StockInvoiceState;
import officemate.screens.maintainstock.preprod.PreprodState;
import officemate.screens.maintainstock.stocktake.StockTakeCompositeState;
import officemate.screens.maintainstock.suggested.SuggestedOrderingReportState;
import officemate.screens.maintainstock.transfer.StockTransferCompositState;
import officemate.screens.maintainstock.waste.StockWastageCompositeState;
import officemate.screens.maintenance.advanced.contest.ContestSetupState;
import officemate.screens.maintenance.advanced.humpback.HumpSyncState;
import officemate.screens.maintenance.advanced.permission.StoreSyncState;
import officemate.screens.maintenance.advanced.unknown.linking.SalesUnknownLinkingState;
import officemate.screens.maintenance.advanced.unknown.unlinking.SalesUnknownUnlinkingState;
import officemate.screens.messaging.sms.SmsActivatedPhoneNumbersState;
import officemate.screens.messaging.sms.SmsHistoryState;
import officemate.screens.messaging.sms.SmsMessagingState;
import officemate.screens.messaging.sms.SmsScheduledTableState;
import officemate.screens.reports.accountType.AccountTypeCompositeState;
import officemate.screens.reports.adjustments.AdjustmentsReportSearchState;
import officemate.screens.reports.adjustments.configurable.ConfigurableDiscountReportState;
import officemate.screens.reports.adjustments.configurable.ConfigurableSurchargeReportState;
import officemate.screens.reports.adjustments.periods.DailyDiscountsReportState;
import officemate.screens.reports.adjustments.periods.DailySurchargesReportState;
import officemate.screens.reports.adjustments.periods.MonthlyDiscountsReportState;
import officemate.screens.reports.adjustments.periods.MonthlySurchargesReportState;
import officemate.screens.reports.adjustments.periods.QuarterlyDiscountsReportState;
import officemate.screens.reports.adjustments.periods.QuarterlySurchargesReportState;
import officemate.screens.reports.adjustments.periods.WeeklyDiscountsReportState;
import officemate.screens.reports.adjustments.periods.WeeklySurchargesReportState;
import officemate.screens.reports.adjustments.periods.YearlyDiscountsReportState;
import officemate.screens.reports.adjustments.periods.YearlySurchargesReportState;
import officemate.screens.reports.cogs.COGSJasperState;
import officemate.screens.reports.cogs.COGSReportState;
import officemate.screens.reports.combos.ComboSoldReportCompositeState;
import officemate.screens.reports.combos.ComboSoldReportSearchState;
import officemate.screens.reports.combos.DailyComboReportCompositeState;
import officemate.screens.reports.combos.MonthlyComboReportCompositeState;
import officemate.screens.reports.combos.QuarterlyComboReportCompositeState;
import officemate.screens.reports.combos.WeeklyComboReportCompositeState;
import officemate.screens.reports.combos.YearlyComboReportCompositeState;
import officemate.screens.reports.coupon.CouponReportState;
import officemate.screens.reports.covers.CoversReportSearchState;
import officemate.screens.reports.covers.substates.DailyCoversReportState;
import officemate.screens.reports.covers.substates.DayOfWeekCoversReportState;
import officemate.screens.reports.covers.substates.MonthlyCoversReportState;
import officemate.screens.reports.covers.substates.WeeklyCoversReportState;
import officemate.screens.reports.custom.CustomReportStateHelper;
import officemate.screens.reports.custom.FormalCustomReportState;
import officemate.screens.reports.dailysales.DailySalesReportSearchState;
import officemate.screens.reports.dailysales.DailySalesReportState;
import officemate.screens.reports.dailysummary.DailySummaryByAccountTypeReportState;
import officemate.screens.reports.dailysummary.DailySummaryByCategoryReportState;
import officemate.screens.reports.dailysummary.DailySummaryByLocationReportState;
import officemate.screens.reports.dailysummary.DailySummaryReportState;
import officemate.screens.reports.dailysummary.DailySummaryTotalReportState;
import officemate.screens.reports.debtor.DebtorSalesItemReportState;
import officemate.screens.reports.debtor.DebtorSalesItemTableState;
import officemate.screens.reports.debtortransaction.DebtorTransactionSummaryReportSearchState;
import officemate.screens.reports.debtortransaction.DebtorTransactionSummaryReportState;
import officemate.screens.reports.driver.DriverManifestReportState;
import officemate.screens.reports.events.EventsCompositeState;
import officemate.screens.reports.feedback.FeedbackReportState;
import officemate.screens.reports.feedback.FeedbackTableState;
import officemate.screens.reports.finance.DenominationReportState;
import officemate.screens.reports.futureorder.FutureOrderState;
import officemate.screens.reports.futureorder.FutureOrderTableState;
import officemate.screens.reports.hourlysales.HourlySalesByCategoryState;
import officemate.screens.reports.hourlysales.HourlySalesByItemState;
import officemate.screens.reports.hourlysales.HourlySalesBySectionState;
import officemate.screens.reports.hourlysales.HourlySalesByUserState;
import officemate.screens.reports.hourlysales.HourlySalesReportTableState;
import officemate.screens.reports.itemgp.ItemGPCompositeState;
import officemate.screens.reports.itemssold.substates.adhocreport.AdhocItemSoldReportState;
import officemate.screens.reports.itemssold.substates.adhocreport.ItemSoldReportSearchState;
import officemate.screens.reports.itemssold.substates.composites.DailyItemSoldCompositeState;
import officemate.screens.reports.itemssold.substates.composites.MonthlyItemSoldCompositeState;
import officemate.screens.reports.itemssold.substates.composites.QuarterlyItemsSoldCompositeState;
import officemate.screens.reports.itemssold.substates.composites.WeeklyItemSoldCompositeState;
import officemate.screens.reports.itemssold.substates.composites.YearlyItemSoldCompositeState;
import officemate.screens.reports.itemssold.substates.summary.SummaryReportViewSubState;
import officemate.screens.reports.itemsunsold.ItemUnsoldReportCompositeState;
import officemate.screens.reports.jasper.JasperReportState;
import officemate.screens.reports.kts.DailyKTSReportState;
import officemate.screens.reports.kts.KTSReportSearchState;
import officemate.screens.reports.kts.MonthlyKTSReportState;
import officemate.screens.reports.kts.QuarterlyKTSReportState;
import officemate.screens.reports.kts.WeeklyKTSReportState;
import officemate.screens.reports.kts.YearlyKTSReportState;
import officemate.screens.reports.options.DailyOptionsReportCompositeState;
import officemate.screens.reports.options.MonthlyOptionsReportCompositeState;
import officemate.screens.reports.options.OptionsReportCompositeState;
import officemate.screens.reports.options.OptionsReportSearchState;
import officemate.screens.reports.options.QuarterlyOptionsReportCompositeState;
import officemate.screens.reports.options.WeeklyOptionsReportCompositeState;
import officemate.screens.reports.options.YearlyOptionsReportCompositeState;
import officemate.screens.reports.periodstock.PeriodStockReportCompositeState;
import officemate.screens.reports.periodtrend.DailyPeriodTrendReportState;
import officemate.screens.reports.periodtrend.MonthlyPeriodTrendReportState;
import officemate.screens.reports.periodtrend.QuarterlyPeriodTrendReportState;
import officemate.screens.reports.periodtrend.WeeklyPeriodTrendReportState;
import officemate.screens.reports.periodtrend.YearlyPeriodTrendReportState;
import officemate.screens.reports.pluses.DailyPlusesReportCompositeState;
import officemate.screens.reports.pluses.MonthlyPlusesReportCompositeState;
import officemate.screens.reports.pluses.PlusesReportCompositeState;
import officemate.screens.reports.pluses.PlusesReportSearchState;
import officemate.screens.reports.pluses.QuarterlyPlusesReportCompositeState;
import officemate.screens.reports.pluses.WeeklyPlusesReportCompositeState;
import officemate.screens.reports.pluses.YearlyPlusesReportCompositeState;
import officemate.screens.reports.productivity.ProductivityReportSearchState;
import officemate.screens.reports.productivity.ProductivityReportState;
import officemate.screens.reports.reconciliation.ReconciliationState;
import officemate.screens.reports.reconciliation.pettycash.PettyCashJasperState;
import officemate.screens.reports.reconciliation.pettycash.PettyCashReportState;
import officemate.screens.reports.reconciliation.pettycash.PettyCashReportTableState;
import officemate.screens.reports.reconciliation.report.ReconciliationReportState;
import officemate.screens.reports.refunds.DailyRefundReportState;
import officemate.screens.reports.refunds.MonthlyRefundReportState;
import officemate.screens.reports.refunds.QuarterlyRefundReportState;
import officemate.screens.reports.refunds.RefundReportCompositeState;
import officemate.screens.reports.refunds.RefundReportSearchState;
import officemate.screens.reports.refunds.WeeklyRefundReportState;
import officemate.screens.reports.refunds.YearlyRefundReportState;
import officemate.screens.reports.reservation.DailyReservationState;
import officemate.screens.reports.reservation.ReservationsReportSearchState;
import officemate.screens.reports.salesbyarea.SalesByAreaCompositeState;
import officemate.screens.reports.salesbydaypart.ComboSalesByDayPartReportState;
import officemate.screens.reports.salesbydaypart.ComprehensiveSalesByDayPartReportState;
import officemate.screens.reports.salesbydaypart.ItemSalesByDayPartReportState;
import officemate.screens.reports.salesbydaypart.MenuSectionSalesByDayPartReportState;
import officemate.screens.reports.salesbydaypart.OptionSalesByDayPartReportState;
import officemate.screens.reports.salesbydaypart.PlusSalesByDayPartReportState;
import officemate.screens.reports.saleshistory.SalesHistoryReportSearchState;
import officemate.screens.reports.saleshistory.substates.DailySalesHistoryReportCompositeState;
import officemate.screens.reports.saleshistory.substates.MonthlySalesHistoryReportCompositeState;
import officemate.screens.reports.saleshistory.substates.QuarterlySalesHistoryReportCompositeState;
import officemate.screens.reports.saleshistory.substates.WeeklySalesHistoryReportCompositeState;
import officemate.screens.reports.saleshistory.substates.YearlySalesHistoryReportCompositeState;
import officemate.screens.reports.salestotakings.SalesToTakingsReportState;
import officemate.screens.reports.salesyearonyear.SalesYearOnYearCompositeReportState;
import officemate.screens.reports.salesyearonyear.SalesYearOnYearSearchState;
import officemate.screens.reports.sata.SATAJasperState;
import officemate.screens.reports.sata.SATATableState;
import officemate.screens.reports.satr.SATRJasperState;
import officemate.screens.reports.satr.SATRTableState;
import officemate.screens.reports.snapshot.SnapshotTotalReportState;
import officemate.screens.reports.staff.category.StaffCategoryReportState;
import officemate.screens.reports.staff.combo.StaffComboReportState;
import officemate.screens.reports.staff.contest.ContestReportState;
import officemate.screens.reports.staff.deletion.StaffDeletionReportState;
import officemate.screens.reports.staff.deletion.StaffDeletionReportTableState;
import officemate.screens.reports.staff.group.StaffGroupReportState;
import officemate.screens.reports.staff.item.StaffItemReportState;
import officemate.screens.reports.stockhistory.StockHistoryReportState;
import officemate.screens.reports.stockonhand.StockOnHandCompositeState;
import officemate.screens.reports.takings.TakingsSummaryReportState;
import officemate.screens.reports.tax.TaxReportCompositeState;
import officemate.screens.reports.timesheet.FinanceTimesheetState;
import officemate.screens.reports.tips.TipsReportCompositeState;
import officemate.screens.reports.transaction.FinanceTransactionReportCompositeState;
import officemate.screens.reports.usage.StockUsageCompositeState;
import officemate.screens.reports.vouchers.audit.VoucherAuditCompositeState;
import officemate.screens.reports.vouchers.summary.VoucherCompositeState;
import officemate.screens.reports.vouchers.transactions.VoucherTransactionCompositeState;
import officemate.screens.reports.weekdaysales.WeekdaySalesByHourReportSearchState;
import officemate.screens.reports.weekdaysales.WeekdaySalesByHourReportState;
import officemate.screens.setup.configuration.accounting.AccountingConfigurationState;
import officemate.screens.setup.configuration.accounting.AccountingCustomerAccountState;
import officemate.screens.setup.configuration.accounting.AccountingInvoiceState;
import officemate.screens.setup.configuration.accounting.AccountingQuickbooksSetupState;
import officemate.screens.setup.configuration.accounting.AccountingSalesSetupState;
import officemate.screens.setup.configuration.accounting.GLAccountLinkSetupState;
import officemate.screens.setup.configuration.accounting.GLAccountSetupState;
import officemate.screens.setup.configuration.actions.ConfigActionSetupState;
import officemate.screens.setup.configuration.advanced.BarcodePrefixState;
import officemate.screens.setup.configuration.advanced.BusinessInfoState;
import officemate.screens.setup.configuration.advanced.CompositeAdvancedPropertyState;
import officemate.screens.setup.configuration.advanced.ExperimentalFeatureState;
import officemate.screens.setup.configuration.advanced.FailoverSetupState;
import officemate.screens.setup.configuration.advanced.GroovyConsoleState;
import officemate.screens.setup.configuration.advanced.HOConfigState;
import officemate.screens.setup.configuration.advanced.PermissionGroupState;
import officemate.screens.setup.configuration.advanced.SchedulerSetupState;
import officemate.screens.setup.configuration.advanced.StoreGroupSetupState;
import officemate.screens.setup.configuration.advanced.appconfig.ApplicationConfigState;
import officemate.screens.setup.configuration.advanced.backup.ConfigBackupState;
import officemate.screens.setup.configuration.advanced.cloudback.CloudBackConfigState;
import officemate.screens.setup.configuration.advanced.customparameters.CustomParametersState;
import officemate.screens.setup.configuration.advanced.custompermission.CustomOfficeMateStatePermissionState;
import officemate.screens.setup.configuration.advanced.custompermission.CustomReportPermissionState;
import officemate.screens.setup.configuration.advanced.diamondback.DiamondReportConfigState;
import officemate.screens.setup.configuration.advanced.diff.VersionDiffState;
import officemate.screens.setup.configuration.advanced.drivertracking.DriverTrackingConfigState;
import officemate.screens.setup.configuration.advanced.exportsales.SalesExportFilterState;
import officemate.screens.setup.configuration.advanced.financeunit.FinanceUnitState;
import officemate.screens.setup.configuration.advanced.messaging.MailState;
import officemate.screens.setup.configuration.advanced.messaging.SmsState;
import officemate.screens.setup.configuration.advanced.piggy.PiggyConfigState;
import officemate.screens.setup.configuration.advanced.salesexport.SalesExportIntegrationState;
import officemate.screens.setup.configuration.advanced.stylesheet.ConfigStyleSheetSetupState;
import officemate.screens.setup.configuration.advanced.taxcode.TaxCodeState;
import officemate.screens.setup.configuration.advanced.webresource.WebResourceIntegrationState;
import officemate.screens.setup.configuration.advanced.webresource.WebResourceLogConfigState;
import officemate.screens.setup.configuration.advanced.webresource.WebResourcePropertyState;
import officemate.screens.setup.configuration.advanced.webresource.WebResourceState;
import officemate.screens.setup.configuration.advanced.webresource.WebResourceUserState;
import officemate.screens.setup.configuration.adyen.AdyenIntegrationConfigState;
import officemate.screens.setup.configuration.bartabs.BarTabsConfigurationState;
import officemate.screens.setup.configuration.cards.CustomerCardState;
import officemate.screens.setup.configuration.courses.CoursesState;
import officemate.screens.setup.configuration.dayparts.DayPartState;
import officemate.screens.setup.configuration.deliveryzones.ConfigureZonesState;
import officemate.screens.setup.configuration.deliveryzones.StreetZoningState;
import officemate.screens.setup.configuration.departments.DepartmentState;
import officemate.screens.setup.configuration.discountreasons.DiscountReasonState;
import officemate.screens.setup.configuration.docket.grouping.DocketGroupingState;
import officemate.screens.setup.configuration.docket.sorting.DocketSortingState;
import officemate.screens.setup.configuration.docketimage.DocketImageState;
import officemate.screens.setup.configuration.feedback.AckState;
import officemate.screens.setup.configuration.feedback.AnswersState;
import officemate.screens.setup.configuration.feedback.QuestionsState;
import officemate.screens.setup.configuration.giftvoucher.GiftVoucherConfigurationSetupState;
import officemate.screens.setup.configuration.integrations.PosIntegrationsState;
import officemate.screens.setup.configuration.internationalization.InternationalizationState;
import officemate.screens.setup.configuration.invoices.InvoiceIntegrationSetupState;
import officemate.screens.setup.configuration.labour.LabourIntegrationState;
import officemate.screens.setup.configuration.locations.LocationsState;
import officemate.screens.setup.configuration.locations.SalesLocationState;
import officemate.screens.setup.configuration.loyalty.LoyaltyIntegrationState;
import officemate.screens.setup.configuration.menulog.PrintOnlyOnlineConfigurationState;
import officemate.screens.setup.configuration.onlineintegration.OnlineConfigurationSetupState;
import officemate.screens.setup.configuration.onlineintegration.OnlineIntegrationETASetupState;
import officemate.screens.setup.configuration.onlineintegration.WebResourceLogState;
import officemate.screens.setup.configuration.onlineterminalmap.OnlineTerminalMapState;
import officemate.screens.setup.configuration.opay.OpaySettingsConfigState;
import officemate.screens.setup.configuration.opay.OpayTippingConfigState;
import officemate.screens.setup.configuration.printergroup.PrinterGroupState;
import officemate.screens.setup.configuration.printing.DebtorPrintingConfigState;
import officemate.screens.setup.configuration.printing.DocketTemplateState;
import officemate.screens.setup.configuration.report.ReportPropertyState;
import officemate.screens.setup.configuration.report.config.ReportConfigState;
import officemate.screens.setup.configuration.report.config.schedule.ReportConfigScheduleState;
import officemate.screens.setup.configuration.report.custom.CustomReportSetupState;
import officemate.screens.setup.configuration.restaurantdiary.RDConfigState;
import officemate.screens.setup.configuration.shift.ShiftState;
import officemate.screens.setup.configuration.systemproperty.SystemPropertyState;
import officemate.screens.setup.configuration.table.LogicalTableStateSetupState;
import officemate.screens.setup.configuration.table.TableSectionState;
import officemate.screens.setup.configuration.waitermateproperty.configcolor.ConfigColourState;
import officemate.screens.setup.configuration.waitermateproperty.quicksalenavinfo.QuickSaleNavInfoState;
import officemate.screens.setup.configuration.waitermateproperty.screenlayouts.ScreenLayoutState;
import officemate.screens.setup.configuration.webpayment.WebPaymentState;
import officemate.screens.setup.configuration.workflow.WorkflowSetupState;
import officemate.screens.setup.devices.calleridunit.CallerIDUnitState;
import officemate.screens.setup.devices.camera.CameraState;
import officemate.screens.setup.devices.cashdrawer.CashdrawerState;
import officemate.screens.setup.devices.customerdisplay.CustomerDisplayState;
import officemate.screens.setup.devices.eftpos.EftposState;
import officemate.screens.setup.devices.kts.KTSDocketPrinterState;
import officemate.screens.setup.devices.payoffprinter.PayoffPrinterState;
import officemate.screens.setup.devices.physicalprinter.PhysicalPrinterState;
import officemate.screens.setup.devices.poledisplay.PoleDisplayState;
import officemate.screens.setup.devices.printerlocations.PrinterLocationsState;
import officemate.screens.setup.devices.proximity.ProximityState;
import officemate.screens.setup.devices.receiptprinters.ReceiptPrinterState;
import officemate.screens.setup.devices.scales.ScalesState;
import officemate.screens.setup.devices.terminal.TerminalState;
import officemate.screens.setup.devices.virtualprinter.VirtualPrinterState;
import officemate.screens.setup.menu.addremoves.AddRemoveState;
import officemate.screens.setup.menu.adjustments.DiscountState;
import officemate.screens.setup.menu.adjustments.SurchargeState;
import officemate.screens.setup.menu.categories.CategoriesState;
import officemate.screens.setup.menu.combosetup.ComboState;
import officemate.screens.setup.menu.coupon.CouponSetupState;
import officemate.screens.setup.menu.coupon.admin.CouponAdministrationState;
import officemate.screens.setup.menu.menuimport.ImportExportMenuState;
import officemate.screens.setup.menu.menuimport.XMLImportExportState;
import officemate.screens.setup.menu.menuitemsetup.MenuItemSetupState;
import officemate.screens.setup.menu.menusection.MenuSectionsState;
import officemate.screens.setup.menu.options.InventoryOptionState;
import officemate.screens.setup.menu.pluses.InventoryAddGroupState;
import officemate.screens.setup.menu.pricelevels.PriceLevelsLoyaltyState;
import officemate.screens.setup.menu.pricelevels.PriceLevelsSetupState;
import officemate.screens.setup.menu.prices.PriceState;
import officemate.screens.setup.menu.profiles.ProfileLinkingState;
import officemate.screens.setup.menu.profiles.ProfilesState;
import officemate.screens.setup.menu.sectionimport.SectionImportState;
import officemate.screens.setup.menu.sizes.InventorySizeState;
import officemate.screens.setup.menu.triggers.TriggersState;
import officemate.screens.setup.menu.upsell.UpsellTableState;
import officemate.screens.setup.stock.SetupStockParLevelsState;
import officemate.screens.setup.stock.areas.SetupStockAreasState;
import officemate.screens.setup.stock.items.SetupStockItemsState;
import officemate.screens.setup.stock.liquorfile.LiquorfileSetupState;
import officemate.screens.setup.stock.liquorfile.PriceBookState;
import officemate.screens.setup.stock.liquorfile.PricebookLinkingState;
import officemate.screens.setup.stock.liquorfile.ScandataExportState;
import officemate.screens.setup.stock.options.OptionsUsageState;
import officemate.screens.setup.stock.suppliers.SetupSuppliersState;
import officemate.screens.setup.stock.units.UnitsUsageState;
import ordermate.OrderMate;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.reports.config.custom.CustomReport;
import ordermate.database.searchers.reports.YearOnYearPeriod;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.Permission;

public class OfficeMateArchitect {
    private OfficeMateBlueprintArchitecture architectPlans = new OfficeMateBlueprintArchitecture();

    public OfficeMateArchitect() {
        this.buildArchitecture();
    }

    public OfficeMateBlueprintArchitecture getBlueprintArchitecture() {
        return this.architectPlans;
    }

    private void buildArchitecture() {
        OfficeMateBlueprintArchitecture plans = this.getBlueprintArchitecture();
        plans.addBlueprint("Welcome", WelcomeState.class, (String)null).setStateIcon(IconLoader.get((String)"/officemate/images/home.png"));
        this.buildDailyTasks(plans);
        this.buildMaintenance(plans);
        this.buildCustomersAndDebtors(plans);
        this.buildReports(plans);
        plans.addBlueprint("Favourites", FavoritesState.class, (String)null).setStateTitle("My Favourites").setStateTooltip("View your favourite screens").setStateIcon(IconLoader.get((String)"/officemate/images/favourite.png"));
        this.buildSetup(plans);
        plans.addBlueprint("Logout", LoginState.class, (String)null).setStateIcon(IconLoader.get((String)"/officemate/images/exit.png"));
    }

    private void buildDailyTasks(OfficeMateBlueprintArchitecture plans) {
        boolean stockEnabled = StockControlProperty.getInstance().isStockControlEnabled();
        String rootKey = "Daily Tasks";
        plans.addBranch(rootKey, null).setStateTitle("Daily Tasks").setStateTooltip("Various tasks that are performed on a daily basis").setStateIcon(IconLoader.get((String)"/officemate/images/daily_tasks.png"));
        plans.addBlueprint(FinanceTimesheetState.class, rootKey).setStateTitle("Timesheets").setStatePermission(AllPermissions.EDIT_TIMESHEET);
        plans.addBlueprint("Reconciliation", ReconciliationState.class, rootKey).setStatePermission(AllPermissions.MYTILLS_RECONCILIATION);
        plans.addBlueprint("Item Count", ItemCountState.class, rootKey);
        if (stockEnabled) {
            plans.addBlueprint("Invoices", StockInvoiceState.class, rootKey).setStatePermission(AllPermissions.ACCESS_INVOICES_SCREEN);
            plans.addBlueprint("Suggested Ordering", SuggestedOrderingReportState.class, rootKey).setStatePermission(AllPermissions.ACCESS_SUGGESTED_ORDER_SCREEN);
            plans.addBlueprint("Stocktakes", StockTakeCompositeState.class, rootKey).setStateTitle("Stocktakes").setStateTooltip("StockTake and filter Stock Items").setStatePermission(AllPermissions.ACCESS_STOCKTAKES_SCREEN);
            plans.addBlueprint("Stock on Hand Adjustments", StockAdjustmentCompositeState.class, rootKey).setStatePermission(AllPermissions.ACCESS_ADJUSTMENT_SCREEN);
            plans.addBlueprint("Transfers", StockTransferCompositState.class, rootKey).setStatePermission(AllPermissions.ACCESS_TRANSFER_SCREEN);
            plans.addBlueprint("Wastage", StockWastageCompositeState.class, rootKey).setStatePermission(AllPermissions.ACCESS_WASTAGES_SCREEN);
            plans.addBlueprint("Pre Production", PreprodState.class, rootKey).setStatePermission(AllPermissions.ACCESS_PRE_PRODUCTION_SCREEN);
        }
        plans.addBlueprint("Accounting Export", AccountingExportState.class, rootKey).setStatePermission(AllPermissions.CONFIG_INTEGRATIONS).addConditions(new StateBuildCondition[]{new AccountingStateBuildCondition()});
    }

    private void buildMaintenance(OfficeMateBlueprintArchitecture plans) {
        String rootKey = "Maintenance";
        plans.addBranch("Maintenance", null).setStateTitle("Maintenance").setStateTooltip("Perform tasks to create and manage the various menu/stock/business components").setStateIcon(IconLoader.get((String)"/officemate/images/maintenance.png"));
        this.buildMaintenanceMenu(plans, "MenuState", "Maintenance");
        this.buildStockMenu(plans, "StockState", "Maintenance");
        this.buildGeneralMenu(plans, "GeneralState", "Maintenance");
        this.buildAdvancedMaintananceMenu(plans, "AdvancedMaintenanceState", "Maintenance");
    }

    private void buildMaintenanceMenu(OfficeMateBlueprintArchitecture plans, String menuStateName, String parentClassKey) {
        plans.addBranch(menuStateName, parentClassKey).setStateTitle("Menu").setStateTooltip("Configure various menu items").setStatePermission(AllPermissions.MENU_SECTION_EDIT);
        String profilesKey = "ProfilesState";
        plans.addCompositeState(profilesKey, menuStateName).setStateTitle("Profiles").setStatePermission(AllPermissions.ACCESS_MENU_PROFILES).setStateTooltip("View, create and modify menu profiles and link them to terminals");
        plans.addBlueprint("Profiles", ProfilesState.class, profilesKey).setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.ACCESS_MENU_PROFILES);
        plans.addBlueprint("Profiles Linking", ProfileLinkingState.class, profilesKey).setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.ACCESS_MENU_PROFILES);
        plans.addBlueprint("Categories", CategoriesState.class, menuStateName).setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint("Sizes", InventorySizeState.class, menuStateName);
        plans.addBlueprint("Sections", MenuSectionsState.class, menuStateName).setStatePermission(AllPermissions.MENU_SECTION_EDIT);
        plans.addBlueprint("Advanced Add/Removes", AddRemoveState.class, menuStateName).setStatePermission(AllPermissions.INVENTORY_SIZES);
        plans.addBlueprint("Plus Groups", InventoryAddGroupState.class, menuStateName).setStatePermission(AllPermissions.INVENTORY_ADDS);
        plans.addBlueprint("Options", InventoryOptionState.class, menuStateName).setStatePermission(AllPermissions.INVENTORY_OPTIONS);
        plans.addCompositeState("Inventory Item State", menuStateName).setStateTitle("Items").setStateTooltip("Modify your menu items, pricing and specials.");
        plans.addBlueprint(MenuItemSetupState.class, "Inventory Item State").setStateTitle("Items").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.EDIT_PRICES);
        plans.addBlueprint(PriceState.class, "Inventory Item State").setStateTitle("Item Prices").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.VIEW_PRICES);
        plans.addCompositeState("Price Level State", menuStateName).setStateTitle("Price Levels").setStatePermission(AllPermissions.VIEW_PRICE_LEVELS).setStateTooltip("View, create and modify price levels.");
        plans.addBlueprint(PriceLevelsSetupState.class, "Price Level State").setStateTitle("Price Levels").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.VIEW_PRICE_LEVELS);
        plans.addBlueprint(PriceLevelsLoyaltyState.class, "Price Level State").setStateTitle("Price Level Loyalty").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.VIEW_PRICE_LEVELS);
        plans.addBlueprint("Combos", ComboState.class, menuStateName).setStateTitle("Combos").setStatePermission(AllPermissions.VIEW_COMBOS);
        plans.addCompositeState("Menu Import Export", menuStateName).setStatePermission(AllPermissions.IMPORT_MENU).setStateTitle("Menu Import/Export").setStateTooltip("Import/Export the menu from/to external files");
        plans.addBlueprint(ImportExportMenuState.class, "Menu Import Export").setStateTitle("CSV Menu Import/Export").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.IMPORT_MENU);
        plans.addBlueprint(XMLImportExportState.class, "Menu Import Export").setStateTitle("XML Menu Import / Export").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.IMPORT_MENU);
        plans.addBlueprint(SectionImportState.class, menuStateName).setStateTitle("Section Import").setStatePermission(AllPermissions.IMPORT_MENU);
        if (PersistentLicenseManager.getInstance().getBoolean(LicenseType.CouponsIntegrationEnabled)) {
            plans.addBlueprint("Setup Coupons", CouponSetupState.class, menuStateName).setStatePermission(AllPermissions.ACCESS_COUPONS_SCREEN).setStateTitle("Coupons");
            plans.addBlueprint("Setup Coupons Admin", CouponAdministrationState.class, menuStateName).setStatePermission(AllPermissions.ACCESS_COUPONS_SCREEN).setStateTitle("Coupons Admin");
        }
    }

    private void buildStockMenu(OfficeMateBlueprintArchitecture plans, String stockSetupName, String parentClassKey) {
        if (!StockControlProperty.getInstance().isStockControlEnabled()) {
            return;
        }
        plans.addBranch(stockSetupName, parentClassKey).setStateTitle("Stock").setStateTooltip("Setup your site to use stock control").addConditions(new StateBuildCondition[]{new StockControlStateBuildCondition()});
        plans.addBlueprint("Stock Suppliers", SetupSuppliersState.class, stockSetupName).setStatePermission(AllPermissions.ACCESS_SUPPLIERS_SCREEN);
        plans.addBlueprint("Stock Areas", SetupStockAreasState.class, stockSetupName).setStatePermission(AllPermissions.ACCESS_STOCK_AREAS_SCREEN);
        plans.addBlueprint("Stock Items", SetupStockItemsState.class, stockSetupName).setStatePermission(AllPermissions.ACCESS_STOCK_ITEMS_SCREEN);
        plans.addCompositeState("Ingredients", stockSetupName).setStateTooltip("View the setup state for item and option ingredients");
        plans.addBlueprint("Item Ingredients", UnitsUsageState.class, "Ingredients").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.ACCESS_ITEM_INGREDIENTS_SCREEN);
        plans.addBlueprint("Option Ingredients", OptionsUsageState.class, "Ingredients").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.ACCESS_OPTION_INGREDIENTS_SCREEN);
        plans.addBlueprint("Stock Par Levels", SetupStockParLevelsState.class, stockSetupName).setStatePermission(AllPermissions.ACCESS_STOCK_CONTROL_OPTIONS);
        String liqFileKey = "LiquorFile";
        plans.addBranch(liqFileKey, stockSetupName).setStateTitle("LiquorFile").setStateTooltip("LMGM Liquor File management").addConditions(new StateBuildCondition[]{new LiquorFileStateBuildCondition()});
        plans.addBlueprint(LiquorfileSetupState.class, liqFileKey).setStateTitle("Liquor File").addConditions(new StateBuildCondition[]{new LiquorFileStateBuildCondition()}).setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(PriceBookState.class, liqFileKey).setStateTitle("PriceBook").addConditions(new StateBuildCondition[]{new LiquorFileStateBuildCondition()}).setStatePermission(AllPermissions.PRICEBOOK_LINKING);
        plans.addBlueprint(PricebookLinkingState.class, liqFileKey).setStateTitle("Linking").addConditions(new StateBuildCondition[]{new LiquorFileStateBuildCondition()}).setStatePermission(AllPermissions.PRICEBOOK_LINKING);
        plans.addBlueprint(ScandataExportState.class, liqFileKey).setStateTitle("Scandata Export").addConditions(new StateBuildCondition[]{new LiquorFileStateBuildCondition()}).setStatePermission(AllPermissions.SCANDATA_EXPORT);
    }

    private void buildGeneralMenu(OfficeMateBlueprintArchitecture plans, String generalSetupName, String parentClassKey) {
        plans.addBranch(generalSetupName, parentClassKey).setStateTitle("General").setStateTooltip("General Maintenance");
        plans.addBlueprint("Users", UsersState.class, generalSetupName);
        plans.addBlueprint("Staff Users", UsersSetupState.class, "Users").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.ACCESS_USERS_SCREEN);
        plans.addBlueprint("Permission Group", SetupPermissionsState.class, "Users").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.ACCESS_PERMISSIONS_SCREEN);
        plans.addBlueprint("Discounts", DiscountState.class, generalSetupName).setStatePermission(AllPermissions.PRICE_ADJUSTMENTS);
        plans.addBlueprint("Surcharges", SurchargeState.class, generalSetupName).setStatePermission(AllPermissions.PRICE_ADJUSTMENTS);
        plans.addBlueprint("Upsells", UpsellTableState.class, generalSetupName).setStatePermission(AllPermissions.EDIT_UPSELLS);
        plans.addBlueprint(TriggersState.class, generalSetupName).setStateTitle("Triggers").setStatePermission(AllPermissions.VIEW_TRIGGERS);
    }

    private void buildAdvancedMaintananceMenu(OfficeMateBlueprintArchitecture plans, String advancedSetupName, String parentClassKey) {
        plans.addBranch(advancedSetupName, parentClassKey).setStateTitle("Advanced").setStateTooltip("Advanced Maintenance");
        plans.addBlueprint("Contests", ContestSetupState.class, advancedSetupName).setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(SmsMessagingState.class, advancedSetupName).setStateTitle("SMS Messaging").setStatePermission(AllPermissions.MESSAGING).setStateTooltip("Send and schedule SMS.");
        plans.addBlueprint(SmsScheduledTableState.class, SmsMessagingState.class).setStateTitle("Scheduled SMS Messaging").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.MESSAGING);
        plans.addBlueprint(SmsActivatedPhoneNumbersState.class, SmsMessagingState.class).setStateTitle("Activated Phone Numbers").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.MESSAGING);
        plans.addBlueprint(SmsHistoryState.class, SmsMessagingState.class).setStateTitle("SMS History").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.MESSAGING);
        String unknowns = "unknowns";
        plans.addCompositeState("unknowns", advancedSetupName).setStateTitle("Online Menu Mapping").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS);
        plans.addBlueprint(SalesUnknownLinkingState.class, "unknowns").setStateType(StateType.TABBED_STATE).setStateTitle("New & Unlinked").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS);
        plans.addBlueprint(SalesUnknownUnlinkingState.class, "unknowns").setStateType(StateType.TABBED_STATE).setStateTitle("Already Linked").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS);
        plans.addBlueprint("HumpBack Sync", HumpSyncState.class, advancedSetupName).setStatePermission(AllPermissions.ACCESS_MENU_PROFILES);
        plans.addBlueprint("Store Sync", StoreSyncState.class, advancedSetupName).setStatePermission(AllPermissions.ACCESS_MENU_PROFILES);
    }

    private void buildCustomersAndDebtors(OfficeMateBlueprintArchitecture plans) {
        String rootKey = "CustomersAndDebtorsState";
        plans.addBranch(rootKey, null).setStateTitle("Customers and Debtors").setStateTooltip("View, edit and report on customers and debtors").setStateIcon(IconLoader.get((String)"/officemate/images/customer.png"));
        plans.addBlueprint(DebtorsState.class, rootKey).setStateTitle("Debtors").setStatePermission(AllPermissions.DEBTOR_EDIT_DETAILS);
        plans.addBlueprint(DebtorSalesState.class, rootKey).setStateTitle("Debtor Sales").setStatePermission(AllPermissions.DEBTOR_ORDER_DETAILS);
        plans.addBlueprint(DebtorGroupState.class, rootKey).setStateTitle("Debtor Groups").setStatePermission(AllPermissions.DEBTOR_EDIT_DETAILS);
        plans.addCompositeState("Customers", rootKey).setStateTitle("Customers").setStatePermission(AllPermissions.CUSTOMER_ADMIN).setStateTooltip("View and manage your customers.");
        plans.addBlueprint(CustomersState.class, "Customers").setStateTitle("Customers").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.CUSTOMER_ADMIN);
        plans.addBlueprint(LoyaltyPointsState.class, "Customers").setStateTitle("Loyalty Points").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.CUSTOMER_ADMIN);
        plans.addBlueprint(CustomerLoyaltyFunctionsState.class, "Customers").setStateTitle("Customer Loyalty Functions").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.CUSTOMER_ADMIN);
        plans.addBlueprint("Customer Category", CustomerCategoryState.class, rootKey).setStatePermission(AllPermissions.CUSTOMER_ADMIN);
    }

    private void buildReports(OfficeMateBlueprintArchitecture plans) {
        String rootKey = "Reports";
        plans.addBranch(rootKey, null).setStateTitle("Reports").setStateTooltip("View and print system reports").setStateIcon(IconLoader.get((String)"/officemate/images/reports.png"));
        plans.setCreateFavorites(true);
        this.buildConsolidated(plans, "Consolidated", rootKey);
        this.buildSalesAndTakings(plans, "SalesAndTakings", rootKey);
        this.buildStock(plans, "StockReports", rootKey);
        this.buildGeneral(plans, "General", rootKey);
        this.buildAudit(plans, "Audit", rootKey);
        this.buildVouchers(plans, "Vouchers", rootKey);
        plans.setCreateFavorites(false);
        this.buildCustomReports(plans, "Custom", rootKey);
        this.buildReportScheduling(plans, "reportSchedulingKey", rootKey);
    }

    private void buildConsolidated(OfficeMateBlueprintArchitecture plans, String consolidatedReportClassName, String parentClass) {
        plans.addBranch(consolidatedReportClassName, parentClass).setStateTitle("Consolidated").setStateTooltip("Reports that join and merge a variety of data to form a unique report");
        plans.addBlueprint(DailySummaryReportState.class, consolidatedReportClassName).setStateTitle("Daily Summary");
        plans.addBlueprint(DailySummaryByCategoryReportState.class, DailySummaryReportState.class).setStateTitle("Daily Summary By Category").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(DailySummaryTotalReportState.class, DailySummaryByCategoryReportState.class).setStateTitle("Daily Summary Total By Category Report").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(DailySummaryByLocationReportState.class, DailySummaryByCategoryReportState.class).setStateTitle("Daily Summary By Category Report").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(DailySummaryByAccountTypeReportState.class, DailySummaryReportState.class).setStateTitle("Daily Summary By Account Type").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(DailySummaryTotalReportState.class, DailySummaryByAccountTypeReportState.class).setStateTitle("Daily Summary Total By Account Type Report").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(DailySummaryByLocationReportState.class, DailySummaryByAccountTypeReportState.class).setStateTitle("Daily Summary By Account Type Report").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(SnapshotTotalReportState.class, consolidatedReportClassName).setStateTitle("Snapshot").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
    }

    private void buildSalesAndTakings(OfficeMateBlueprintArchitecture plans, String salesAndTakingsReportName, String parentName) {
        plans.addBranch(salesAndTakingsReportName, parentName).setStateTitle("Sales And Takings").setStateTooltip("Reports on Sales and Takings");
        String takingsReportKey = "TakingsReport";
        plans.addBranch(takingsReportKey, salesAndTakingsReportName).setStateTitle("Takings Report").setStateTooltip("Takings summary per cashdrawer and a certain period.").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(TakingsSummaryReportState.class, takingsReportKey).setStateTitle("Takings Summary Report").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint("Finance Transactions", FinanceTransactionReportCompositeState.class, takingsReportKey).setStateTitle("Finance Transactions").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint("Tips Report", TipsReportCompositeState.class, takingsReportKey).setStateTitle("Tips Report").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        String salesReportKey = "SalesReport";
        plans.addBranch(salesReportKey, salesAndTakingsReportName).setStateTitle("Sales Report").setStateTooltip("View the sales reports for the items sold").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        this.layoutHandledCompositeState(plans, AdhocItemSoldReportState.class, salesReportKey, "Item Sold Report", ItemSoldReportSearchState.class, JasperReportState.class, SummaryReportViewSubState.class);
        plans.addBlueprint(DailyItemSoldCompositeState.class, salesReportKey).setStateTitle("Daily Items Sold").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(WeeklyItemSoldCompositeState.class, salesReportKey).setStateTitle("Weekly Items Sold").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(MonthlyItemSoldCompositeState.class, salesReportKey).setStateTitle("Monthly Items Sold").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(QuarterlyItemsSoldCompositeState.class, salesReportKey).setStateTitle("Quarterly Items Sold").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(YearlyItemSoldCompositeState.class, salesReportKey).setStateTitle("Yearly Items Sold").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(ItemUnsoldReportCompositeState.class, salesReportKey).setStateTitle("Unsold Items").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        String periodTrendKey = "PeriodTrend";
        plans.addBranch(periodTrendKey, salesAndTakingsReportName).setStateTitle("Period Trend").setStateTooltip("Sales broken down by period and time block.").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(DailyPeriodTrendReportState.class, periodTrendKey).setStateTitle("Daily Period Trend").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(WeeklyPeriodTrendReportState.class, periodTrendKey).setStateTitle("Weekly Period Trend").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(MonthlyPeriodTrendReportState.class, periodTrendKey).setStateTitle("Monthly Period Trend").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(QuarterlyPeriodTrendReportState.class, periodTrendKey).setStateTitle("Quarterly Period Trend").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(YearlyPeriodTrendReportState.class, periodTrendKey).setStateTitle("Yearly Period Trend").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBranch("Staff Sales", salesAndTakingsReportName).setStateTitle("Staff Sales").setStateTooltip("Sales broken down by user.").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint("Items Sold", StaffItemReportState.class, "Staff Sales");
        plans.addBlueprint("Combo Sold", StaffComboReportState.class, "Staff Sales");
        plans.addBlueprint("Menu Section Sales", StaffGroupReportState.class, "Staff Sales");
        plans.addBlueprint("Category Sales", StaffCategoryReportState.class, "Staff Sales");
        plans.addBlueprint("Contest Reports", ContestReportState.class, "Staff Sales");
        String optionsReportKey = "OptionsReport";
        plans.addBranch(optionsReportKey, salesAndTakingsReportName).setStateTitle("Options Report").setStateTooltip("Report on Options Sold").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        this.buildStandardReport(plans, optionsReportKey, OptionsReportSearchState.class, new Pair(OptionsReportCompositeState.class, (Object)"Options Report"), new Pair(DailyOptionsReportCompositeState.class, (Object)"Daily Options Sold Report"), new Pair(WeeklyOptionsReportCompositeState.class, (Object)"Weekly Options Sold Report"), new Pair(MonthlyOptionsReportCompositeState.class, (Object)"Monthly Options Sold Report"), new Pair(QuarterlyOptionsReportCompositeState.class, (Object)"Quarterly Options Sold Report"), new Pair(YearlyOptionsReportCompositeState.class, (Object)"Yearly Options Sold Report"));
        String plussesReportKey = "PlussesReport";
        plans.addBranch(plussesReportKey, salesAndTakingsReportName).setStateTitle("Pluses Sold Report").setStateTooltip("Additional items added to sold items.").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        this.buildStandardReport(plans, plussesReportKey, PlusesReportSearchState.class, new Pair(PlusesReportCompositeState.class, (Object)"Pluses Sold Report"), new Pair(DailyPlusesReportCompositeState.class, (Object)"Daily Pluses Sold Report"), new Pair(WeeklyPlusesReportCompositeState.class, (Object)"Weekly Pluses Sold Report"), new Pair(MonthlyPlusesReportCompositeState.class, (Object)"Monthly Pluses Sold Report"), new Pair(QuarterlyPlusesReportCompositeState.class, (Object)"Quarterly Pluses Sold Report"), new Pair(YearlyPlusesReportCompositeState.class, (Object)"Yearly Pluses Sold Report"));
        plans.addBranch("Combos Sold", salesAndTakingsReportName).setStateTitle("Combos Sold Report").setStateTooltip("View report on combos sold.").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        this.buildStandardReport(plans, "Combos Sold", ComboSoldReportSearchState.class, new Pair(ComboSoldReportCompositeState.class, (Object)"Combos Sold Report"), new Pair(DailyComboReportCompositeState.class, (Object)"Daily Combos Sold Report"), new Pair(WeeklyComboReportCompositeState.class, (Object)"Weekly Combos Sold Report"), new Pair(MonthlyComboReportCompositeState.class, (Object)"Monthly Combos Sold Report"), new Pair(QuarterlyComboReportCompositeState.class, (Object)"Quarterly Combos Sold Report"), new Pair(YearlyComboReportCompositeState.class, (Object)"Yearly Combos Sold Report"));
        String dollarsPerHeadKey = "DollarsPerHead";
        plans.addBranch(dollarsPerHeadKey, salesAndTakingsReportName).setStateTitle("Dollars per head").setStateTooltip("View and search for dollars per head report.").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        this.buildStandardReport(plans, dollarsPerHeadKey, CoversReportSearchState.class, new Pair(DailyCoversReportState.class, (Object)"Daily Covers"), new Pair(DayOfWeekCoversReportState.class, (Object)"Day of week Covers"), new Pair(WeeklyCoversReportState.class, (Object)"Weekly Covers"), new Pair(MonthlyCoversReportState.class, (Object)"Monthly Covers"));
        String salesHistoryKey = "SalesHistoryReport";
        plans.addBranch(salesHistoryKey, salesAndTakingsReportName).setStateTitle("Sales History Reports").setStateTooltip("Summary of daily, weekly, monthly, quarterly or yearly sales across any given period.").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        this.buildStandardReport(plans, salesHistoryKey, SalesHistoryReportSearchState.class, new Pair(DailySalesHistoryReportCompositeState.class, (Object)"Sales History by Day"), new Pair(WeeklySalesHistoryReportCompositeState.class, (Object)"Sales History by Week"), new Pair(MonthlySalesHistoryReportCompositeState.class, (Object)"Sales History by Month"), new Pair(QuarterlySalesHistoryReportCompositeState.class, (Object)"Sales History by Quarter"), new Pair(YearlySalesHistoryReportCompositeState.class, (Object)"Sales History by Year"));
        String salesYOYReportKey = "SalesYearOnYearReport";
        plans.addBranch("SalesYearOnYearReport", salesAndTakingsReportName).setStateTitle("Year on Year Report").setStateTooltip("View comparison year on year reports").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        Constructor<?> salesYOYConst = SalesYearOnYearCompositeReportState.class.getConstructors()[0];
        String suffixSearch = " (Search)";
        String suffixPDF = " (PDF)";
        String keyByDay = "SalesYearOnYearReportByDay";
        plans.addBlueprint("SalesYearOnYearReportByDay", SalesYearOnYearCompositeReportState.class, "SalesYearOnYearReport").setConstructor(salesYOYConst).setStateTitle("Report by Day").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateTooltip("Year on year daily comparison reports").addExtraParams(new Object[]{YearOnYearPeriod.DAY});
        plans.addBlueprint("Report by Day (Search)", SalesYearOnYearSearchState.class, "SalesYearOnYearReportByDay").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateType(StateType.TABBED_STATE);
        plans.addBlueprint("Report by Day (PDF)", JasperReportState.class, "SalesYearOnYearReportByDay").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateType(StateType.TABBED_STATE);
        String keyByWeek = "SalesYearOnYearReportByWeek";
        plans.addBlueprint("SalesYearOnYearReportByWeek", SalesYearOnYearCompositeReportState.class, "SalesYearOnYearReport").setConstructor(salesYOYConst).setStateTitle("Report by Week").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateTooltip("Year on year week comparison reports").addExtraParams(new Object[]{YearOnYearPeriod.WEEK});
        plans.addBlueprint("Report by Week (Search)", SalesYearOnYearSearchState.class, "SalesYearOnYearReportByWeek").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateType(StateType.TABBED_STATE);
        plans.addBlueprint("Report by Week (PDF)", JasperReportState.class, "SalesYearOnYearReportByWeek").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateType(StateType.TABBED_STATE);
        String keyByMonth = "SalesYearOnYearReportByMonth";
        plans.addBlueprint("SalesYearOnYearReportByMonth", SalesYearOnYearCompositeReportState.class, "SalesYearOnYearReport").setConstructor(salesYOYConst).setStateTitle("Report by Month").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateTooltip("Year on year month comparison reports").addExtraParams(new Object[]{YearOnYearPeriod.MONTH});
        plans.addBlueprint("Report by Month (Search)", SalesYearOnYearSearchState.class, "SalesYearOnYearReportByMonth").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateType(StateType.TABBED_STATE);
        plans.addBlueprint("Report by Month (PDF)", JasperReportState.class, "SalesYearOnYearReportByMonth").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateType(StateType.TABBED_STATE);
        String keyByQuarter = "SalesYearOnYearReportByQuarter";
        plans.addBlueprint("SalesYearOnYearReportByQuarter", SalesYearOnYearCompositeReportState.class, "SalesYearOnYearReport").setConstructor(salesYOYConst).setStateTitle("Report by Quarter").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateTooltip("Year on year quarter comparison reports").addExtraParams(new Object[]{YearOnYearPeriod.QUARTER});
        plans.addBlueprint("Report by Quarter (Search)", SalesYearOnYearSearchState.class, "SalesYearOnYearReportByQuarter").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateType(StateType.TABBED_STATE);
        plans.addBlueprint("Report by Quarter (PDF)", JasperReportState.class, "SalesYearOnYearReportByQuarter").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateType(StateType.TABBED_STATE);
        String hourlySalesReportKey = "HourlySalesReport";
        plans.addBranch(hourlySalesReportKey, salesAndTakingsReportName).setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateTitle("Hourly Sales").setStateTooltip("Sales broken down by hour");
        this.buildStandardReport(plans, hourlySalesReportKey, HourlySalesReportTableState.class, new Pair(HourlySalesByUserState.class, (Object)"Sales By Hour By User"), new Pair(HourlySalesBySectionState.class, (Object)"Sales By Hour By Section"), new Pair(HourlySalesByCategoryState.class, (Object)"Sales By Hour By Category"), new Pair(HourlySalesByItemState.class, (Object)"Sales By Hour By Item"));
        plans.addCompositeState("Sales & Takings Analysis", salesAndTakingsReportName).setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateTooltip("View a daily Book Keeping overview");
        plans.addBlueprint("Sales & Takings Analysis", SATATableState.class, "Sales & Takings Analysis").setStateTitle("Book Keeping").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint("Sales & Takings Analysis", SATAJasperState.class, "Sales & Takings Analysis").setStateTitle("Report").setStateType(StateType.TABBED_STATE);
        plans.addCompositeState("Sales & Takings Rundown", salesAndTakingsReportName).setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateTooltip("View sales and takings by day parts and locations");
        plans.addBlueprint("Sales & Takings Rundown", SATRTableState.class, "Sales & Takings Rundown").setStateTitle("Rundown").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint("Sales & Takings Rundown", SATRJasperState.class, "Sales & Takings Rundown").setStateTitle("Report").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(SalesToTakingsReportState.class, salesAndTakingsReportName).setStateTitle("Sales To Takings").setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateTooltip("View Sales To Takings Breakdown");
        plans.addBranch("Sales by Day Part Report", salesAndTakingsReportName);
        plans.addBlueprint(MenuSectionSalesByDayPartReportState.class, "Sales by Day Part Report").setStateTitle("Menu Section Sales").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(ItemSalesByDayPartReportState.class, "Sales by Day Part Report").setStateTitle("Item Sales").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(ComboSalesByDayPartReportState.class, "Sales by Day Part Report").setStateTitle("Combo Sales").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(OptionSalesByDayPartReportState.class, "Sales by Day Part Report").setStateTitle("Option Sales").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(PlusSalesByDayPartReportState.class, "Sales by Day Part Report").setStateTitle("Plus Sales").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint(ComprehensiveSalesByDayPartReportState.class, "Sales by Day Part Report").setStateTitle("Comprehensive Report").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        this.layoutHandledCompositeState(plans, DailySalesReportState.class, salesAndTakingsReportName, "Half Hourly Sales Breakdown", DailySalesReportSearchState.class, JasperReportState.class);
        this.layoutHandledCompositeState(plans, WeekdaySalesByHourReportState.class, salesAndTakingsReportName, "Weekday Sales By Hour", WeekdaySalesByHourReportSearchState.class, JasperReportState.class);
        this.layoutHandledCompositeState(plans, ProductivityReportState.class, salesAndTakingsReportName, "User Tables", ProductivityReportSearchState.class, JasperReportState.class);
        plans.addBlueprint("Account sales", AccountTypeCompositeState.class, salesAndTakingsReportName).setStateTitle("Account sales").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        plans.addBlueprint("Tax Report", TaxReportCompositeState.class, salesAndTakingsReportName).setStateTitle("Tax Report").setStatePermission(AllPermissions.ACCESS_SALES_REPORT);
        this.layoutHandledCompositeState(plans, DebtorSalesItemReportState.class, salesAndTakingsReportName, "Debtor Sales Items", AllPermissions.DEBTOR_REPORT, DebtorSalesItemTableState.class);
        this.layoutHandledCompositeState(plans, DebtorTransactionSummaryReportState.class, salesAndTakingsReportName, "Debtor Transaction Summary", DebtorTransactionSummaryReportSearchState.class, JasperReportState.class);
    }

    private void buildStock(OfficeMateBlueprintArchitecture plans, String stockKey, String rootKey) {
        if (!StockControlProperty.getInstance().isStockControlEnabled()) {
            return;
        }
        StockControlStateBuildCondition stockCond = new StockControlStateBuildCondition();
        plans.addBranch(stockKey, rootKey).setStateTitle("Stock").setStateTooltip("Reports for viewing Stock figures").addConditions(new StateBuildCondition[]{stockCond});
        plans.addBlueprint("Stock On Hand", StockOnHandCompositeState.class, stockKey).setStateTitle("Stock On Hand").setStatePermission(AllPermissions.ACCESS_STOCK_ON_HAND_REPORT).addConditions(new StateBuildCondition[]{stockCond});
        plans.addBlueprint("Period Stock", PeriodStockReportCompositeState.class, stockKey).setStateTitle("Period Stock").setStatePermission(AllPermissions.ACCESS_PERIOD_STOCK_REPORT).addConditions(new StateBuildCondition[]{stockCond});
        plans.addCompositeState("COGS Report", stockKey).setStatePermission(AllPermissions.ACCESS_COGS_REPORT).addConditions(new StateBuildCondition[]{stockCond}).setStateTooltip("View the Cost of Goods Sold Report");
        plans.addBlueprint(COGSReportState.class, "COGS Report").setStateTitle("COGS").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(COGSJasperState.class, "COGS Report").setStateTitle("COGS Report").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint("Sales By Area", SalesByAreaCompositeState.class, stockKey).setStateTitle("Sales By Area").setStatePermission(AllPermissions.ACCESS_SALES_BY_AREA_REPORT).addConditions(new StateBuildCondition[]{stockCond});
        plans.addBlueprint("Stock Usage", StockUsageCompositeState.class, stockKey).setStateTitle("Stock Usage").setStatePermission(AllPermissions.ACCESS_STOCK_USAGE_REPORT).addConditions(new StateBuildCondition[]{stockCond});
        plans.addBlueprint("Item GP", ItemGPCompositeState.class, stockKey).setStateTitle("Item GP").setStatePermission(AllPermissions.ACCESS_ITEM_GP_REPORT).addConditions(new StateBuildCondition[]{stockCond});
        plans.addBlueprint("Stock Item History", StockHistoryReportState.class, stockKey).setStateTitle("Stock Item History").setStatePermission(AllPermissions.ACCESS_COGS_REPORT).addConditions(new StateBuildCondition[]{stockCond});
    }

    private void buildGeneral(OfficeMateBlueprintArchitecture plans, String generalKey, String rootKey) {
        plans.addBranch(generalKey, rootKey).setStateTitle("General").setStateTooltip("General Reports in OfficeMate");
        this.layoutHandledCompositeState(plans, FeedbackReportState.class, generalKey, "Feedback", FeedbackTableState.class);
        String reservationReportKey = "ReservationReport";
        plans.addBranch(reservationReportKey, generalKey).setStateTitle("Reservation").setStateTooltip("Reports for reservations").setStatePermission(AllPermissions.VIEW_RESERVATIONS);
        this.layoutHandledCompositeState(plans, DailyReservationState.class, reservationReportKey, "Daily Reservation Report", ReservationsReportSearchState.class, JasperReportState.class);
        String ktsReportKey = "ktsReport";
        plans.addBranch(ktsReportKey, generalKey).setStatePermission(AllPermissions.ACCESS_SALES_REPORT).setStateTitle("KTS Reports").setStateTooltip("KTS Reports for periods.");
        this.buildStandardReport(plans, ktsReportKey, KTSReportSearchState.class, new Pair(DailyKTSReportState.class, (Object)"Daily KTS Report"), new Pair(WeeklyKTSReportState.class, (Object)"Weekly KTS Report"), new Pair(MonthlyKTSReportState.class, (Object)"Monthly KTS Report"), new Pair(QuarterlyKTSReportState.class, (Object)"Quarterly KTS Report"), new Pair(YearlyKTSReportState.class, (Object)"Yearly KTS Report"));
        this.layoutHandledCompositeState(plans, DriverManifestReportState.class, generalKey, "Driver Manifest", DriverManifestReportState.class, JasperReportState.class);
        this.layoutHandledCompositeState(plans, FutureOrderState.class, generalKey, "Open Orders", FutureOrderTableState.class, JasperReportState.class);
        if (PersistentLicenseManager.getInstance().getBoolean(LicenseType.CouponsIntegrationEnabled)) {
            plans.addBlueprint("Coupon Report", CouponReportState.class, generalKey);
        }
    }

    private void buildAudit(OfficeMateBlueprintArchitecture plans, String auditKey, String rootKey) {
        plans.addBranch(auditKey, rootKey).setStateTitle("Audit").setStateTooltip("Reports to evaluate the perfomrance of the business");
        plans.addBlueprint("Closed Accounts", ClosedAccountsCompositeState.class, auditKey).setStateTitle("Closed Accounts").setStateTooltip("Search and filter closed accounts").setStatePermission(AllPermissions.VIEW_CLOSED_ACCOUNTS);
        String discountReportKey = "discountReport";
        plans.addBranch(discountReportKey, auditKey).setStateTitle("Discounts Reports").setStateTooltip("Discounts Reports for periods.");
        this.buildStandardReport(plans, discountReportKey, new Class[]{AdjustmentsReportSearchState.class, JasperReportState.class, JasperReportState.class}, new Pair(ConfigurableDiscountReportState.class, (Object)"Discount Report"), new Pair(DailyDiscountsReportState.class, (Object)"Daily Discount Report"), new Pair(WeeklyDiscountsReportState.class, (Object)"Weekly Discount Report"), new Pair(MonthlyDiscountsReportState.class, (Object)"Monthly Discount Report"), new Pair(QuarterlyDiscountsReportState.class, (Object)"Quarterly Discount Report"), new Pair(YearlyDiscountsReportState.class, (Object)"Yearly Discount Report"));
        String surchargeReportKey = "surchargeReport";
        plans.addBranch(surchargeReportKey, auditKey).setStateTitle("Surcharge Reports").setStateTooltip("Surcharge Reports for periods.");
        this.buildStandardReport(plans, surchargeReportKey, new Class[]{AdjustmentsReportSearchState.class, JasperReportState.class, JasperReportState.class}, new Pair(ConfigurableSurchargeReportState.class, (Object)"Surcharge Report"), new Pair(DailySurchargesReportState.class, (Object)"Daily Surcharge Report"), new Pair(WeeklySurchargesReportState.class, (Object)"Weekly Surcharge Report"), new Pair(MonthlySurchargesReportState.class, (Object)"Monthly Surcharge Report"), new Pair(QuarterlySurchargesReportState.class, (Object)"Quarterly Surcharge Report"), new Pair(YearlySurchargesReportState.class, (Object)"Yearly Surcharge Report"));
        String refundsReportKey = "refundsReport";
        plans.addBranch(refundsReportKey, auditKey).setStateTitle("Refunds Reports").setStateTooltip("Refunds Reports for periods.");
        this.buildStandardReport(plans, refundsReportKey, RefundReportSearchState.class, new Pair(RefundReportCompositeState.class, (Object)"Refunds Report"), new Pair(DailyRefundReportState.class, (Object)"Daily Refund Report"), new Pair(WeeklyRefundReportState.class, (Object)"Weekly Refund Report"), new Pair(MonthlyRefundReportState.class, (Object)"Monthly Refund Report"), new Pair(QuarterlyRefundReportState.class, (Object)"Quarterly Refund Report"), new Pair(YearlyRefundReportState.class, (Object)"Yearly Refund Report"));
        this.layoutHandledCompositeState(plans, StaffDeletionReportState.class, auditKey, "Items Deleted", StaffDeletionReportTableState.class, JasperReportState.class);
        plans.addBlueprint(ReconciliationReportState.class, auditKey).setStateTitle("Reconciliation Report").setStatePermission(AllPermissions.MYTILLS_RECONCILIATION);
        plans.addBlueprint(DenominationReportState.class, auditKey).setStateTitle("Denomination Report").setStatePermission(AllPermissions.MYTILLS_RECONCILIATION);
        this.layoutHandledCompositeState(plans, PettyCashReportState.class, auditKey, "Petty Cash Report", PettyCashReportTableState.class, PettyCashJasperState.class);
        plans.addBlueprint(EventsCompositeState.class, auditKey).setStateTitle("Transaction Journal").setStatePermission(AllPermissions.VIEW_TRANSACTION_JOURNAL);
    }

    private void buildVouchers(OfficeMateBlueprintArchitecture plans, String voucherKey, String rootKey) {
        plans.addBranch(voucherKey, rootKey).setStateTitle("Vouchers").setStateTooltip("Reports for Vouchers");
        plans.addBlueprint("Voucher Summary", VoucherCompositeState.class, voucherKey).setStatePermission(AllPermissions.VOUCHER_REPORTS);
        plans.addBlueprint("Voucher Audit", VoucherAuditCompositeState.class, voucherKey).setStatePermission(AllPermissions.VOUCHER_REPORTS);
        plans.addBlueprint("Voucher Transaction Summary", VoucherTransactionCompositeState.class, voucherKey).setStatePermission(AllPermissions.VOUCHER_REPORTS);
    }

    private void buildCustomReports(OfficeMateBlueprintArchitecture plans, String customReportKey, String rootKey) {
        ArrayList<CustomReport> customReports = new ArrayList<CustomReport>();
        customReports.addAll(CustomReportStateHelper.getAllTransientCustomReports());
        customReports.addAll(CustomReportStateHelper.getAllTopLevelCustomReports());
        if (customReports.isEmpty()) {
            return;
        }
        Constructor stateConstructor = null;
        try {
            stateConstructor = FormalCustomReportState.class.getConstructor(CustomReport.class);
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Required constructor missing for FormalCustomReportState!", (Throwable)e);
        }
        if (stateConstructor != null) {
            plans.addBranch(customReportKey, rootKey).setStateTitle("Custom");
            for (CustomReport report : customReports) {
                String uniqueKey = "_DYNAMIC_";
                uniqueKey = report.isPersistent() ? uniqueKey + report.getID() + "_" + report.getTitle() : uniqueKey + "_TRANSIENT_" + customReports.indexOf(report) + "_" + report.getTitle();
                plans.addBlueprint(uniqueKey, FormalCustomReportState.class, customReportKey).setStateTitle(report.getTitle()).setConstructor(stateConstructor).addExtraParams(new Object[]{report});
            }
        }
    }

    private void buildSetup(OfficeMateBlueprintArchitecture plans) {
        String rootKey = "Setup";
        plans.addBranch(rootKey, null).setStateTitle("Setup").setStateTooltip("Setup the system").setStateIcon(IconLoader.get((String)"/officemate/images/settings.png"));
        this.buildConfiguration(plans, "Configuration", rootKey);
        this.buildDevices(plans, "Devices", rootKey);
    }

    private void buildConfiguration(OfficeMateBlueprintArchitecture plans, String configKey, String rootKey) {
        plans.addBranch(configKey, rootKey).setStateTitle("Configuration").setStateTooltip("Configure System Settings").setStatePermission(AllPermissions.ALL_DEVICES).setStateIcon(IconLoader.get((String)"/officemate/images/system_settings.png"));
        plans.addBlueprint(CoursesState.class, configKey).setStateTitle("Courses").setStatePermission(AllPermissions.ACCESS_COURSES);
        String printingOptionsKey = "printingOptionsKey";
        plans.addBranch(printingOptionsKey, configKey).setStatePermission(AllPermissions.PRINTING_OPTIONS).setStateTitle("Printing Options").setStateTooltip("Configure the print options").setStateIcon(IconLoader.get((String)"/ordermate/images/printerSmall.png"));
        plans.addBlueprint(DebtorPrintingConfigState.class, printingOptionsKey).setStateTitle("Debtor print options").setStatePermission(AllPermissions.PRINTING_OPTIONS);
        plans.addBlueprint(DocketTemplateState.class, printingOptionsKey).setStateTitle("Docket Templates");
        plans.addBlueprint(PrintOnlyOnlineConfigurationState.class, printingOptionsKey).setStateTitle("Print Only Online Ordering").addConditions(new StateBuildCondition[]{new StateBuildCondition(){

            public boolean checkBuildCondition() {
                return SystemProperty.getInstance().isOnlineIntegrationPrintDocketOnly();
            }
        }});
        plans.addBlueprint(PrinterGroupState.class, configKey).setStateTitle("Printer Groups").setStatePermission(AllPermissions.EDIT_PRINTER_GROUPS);
        plans.addBlueprint(SystemPropertyState.class, configKey).setStateTitle("Ordermate Properties").setStatePermission(AllPermissions.ORDERMATE_PROPERTIES);
        String displayPropsKey = "displayPropsKey";
        plans.addCompositeState(displayPropsKey, configKey).setStateTitle("Display Properties").setStateTooltip("Adjust properties specific to Waitermate and PocketMate terminals");
        plans.addBlueprint(ScreenLayoutState.class, displayPropsKey).setStateTitle("Screen Layouts").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.ACCESS_QUICK_SALE_NAV_INFO);
        plans.addBlueprint(QuickSaleNavInfoState.class, displayPropsKey).setStateTitle("Quick Sale Nav Bar").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.ACCESS_QUICK_SALE_NAV_INFO);
        plans.addBlueprint(ConfigColourState.class, displayPropsKey).setStateTitle("Configurable Colours").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.CONFIG_COLOURS);
        plans.addBlueprint(DiscountReasonState.class, configKey).setStateTitle("Discount Reasons").setStatePermission(AllPermissions.DISCOUNT_REASONS);
        plans.addBlueprint(DepartmentState.class, configKey).setStateTitle("Departments");
        String deliveryZoneKey = "DeliveryZones";
        plans.addCompositeState(deliveryZoneKey, configKey).setStateTitle("Configure Zones").setStateTooltip("Create zones and assign their delivery policy").setStatePermission(AllPermissions.DELIVERY_ZONES).addConditions(new StateBuildCondition[]{new StateBuildCondition(){

            public boolean checkBuildCondition() {
                return SystemProperty.getInstance().isUseDeliveryZones();
            }
        }});
        plans.addBlueprint(StreetZoningState.class, deliveryZoneKey).setStateTitle("Street Zoning").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(ConfigureZonesState.class, deliveryZoneKey).setStateTitle("Configure Zones").setStateType(StateType.TABBED_STATE);
        plans.addCompositeState("Online Config", configKey).setStateTitle("Online Integration").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS).setStateTooltip("Configure online integrations").addConditions(new StateBuildCondition[]{new StateBuildCondition(){

            public boolean checkBuildCondition() {
                return SystemProperty.getInstance().isOnlineIntegrationFull();
            }
        }});
        plans.addBlueprint(OnlineConfigurationSetupState.class, "Online Config").setStateTitle("Online Integration").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(OnlineIntegrationETASetupState.class, "Online Config").setStateTitle("ETA Setup").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(WebResourceLogState.class, "Online Config").setStateTitle("Web Logs").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(OnlineTerminalMapState.class, "Online Config").setStateTitle("Online Terminal Map").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(CustomerCardState.class, configKey).setStateTitle("Customer Card").setStatePermission(AllPermissions.ASSIGN_LOYALTY_CARD).setStateTooltip("Register, activate and deactivate customer cards.");
        plans.addBlueprint(GiftVoucherConfigurationSetupState.class, configKey).setStateTitle("Voucher Schemes").setStatePermission(AllPermissions.CONFIG_GIFT_VOUCHERS);
        plans.addBlueprint(PosIntegrationsState.class, configKey).setStateTitle("Integrations").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS);
        plans.addBlueprint(ShiftState.class, configKey).setStateTitle("Shifts").setStatePermission(AllPermissions.EDIT_SHIFTS);
        plans.addBlueprint(OpayTippingConfigState.class, configKey).setStateTitle("Opay Tipping Defaults");
        plans.addBlueprint(OpaySettingsConfigState.class, configKey).setStateTitle("Opay Settings");
        plans.addBlueprint(DayPartState.class, configKey).setStateTitle("Day Parts").setStatePermission(AllPermissions.DAY_PARTS);
        plans.addBlueprint(WorkflowSetupState.class, configKey).setStateTitle("Workflow").setStatePermission(AllPermissions.PRINTING_OPTIONS);
        plans.addBlueprint(InvoiceIntegrationSetupState.class, configKey).setStateTitle("Invoice Integration").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS);
        plans.addBlueprint(LocationsState.class, configKey).setStateTitle("Terminal Locations").setStatePermission(AllPermissions.LOCATIONS);
        plans.addBlueprint(SalesLocationState.class, configKey).setStateTitle("Sales Locations").setStatePermission(AllPermissions.LOCATIONS);
        plans.addBlueprint(LogicalTableStateSetupState.class, configKey).setStateTitle("Table States").setStatePermission(AllPermissions.MOVE_TABLE);
        plans.addBlueprint(TableSectionState.class, configKey).setStateTitle("Table Sections").setStatePermission(AllPermissions.MOVE_TABLE);
        plans.addBlueprint("Setup Web Payment", WebPaymentState.class, configKey);
        if (PersistentLicenseManager.getInstance().getLicenseValue(LicenseType.MYOBIntegrationEnabled) == 1) {
            this.buildAccountingIntegration(plans, "accountingIntegrationKey", configKey);
        }
        plans.addBlueprint("Bar Tab Integration", BarTabsConfigurationState.class, configKey);
        plans.addBlueprint("Tax Codes", TaxCodeState.class, configKey).setStatePermission(AllPermissions.EDIT_PRICES);
        plans.addBlueprint("Payment Types", FinanceUnitState.class, configKey).setStatePermission(AllPermissions.PAYMENT_TYPE);
        plans.addBlueprint("Action Setup", ConfigActionSetupState.class, configKey).setStatePermission(AllPermissions.ORDERMATE_PROPERTIES);
        plans.addBlueprint("Docket Images", DocketImageState.class, configKey);
        plans.addBlueprint("Docket Grouping", DocketGroupingState.class, configKey);
        plans.addBlueprint("Docket Sorting", DocketSortingState.class, configKey);
        this.buildAdvanced(plans, "advancedConfigKey", configKey);
    }

    private void buildAccountingIntegration(OfficeMateBlueprintArchitecture plans, String accountingIntkey, String configKey) {
        plans.addBranch(accountingIntkey, configKey).setStatePermission(AllPermissions.CONFIG_INTEGRATIONS).setStateTitle("Accounting Integration").setStateTooltip("Configure Accounting Integration.").addConditions(new StateBuildCondition[]{new AccountingStateBuildCondition()});
        plans.addBlueprint(AccountingConfigurationState.class, accountingIntkey).setStateTitle("Accounting Integration").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS);
        plans.addBlueprint(GLAccountLinkSetupState.class, accountingIntkey).setStateTitle("GL Account Links").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS);
        plans.addBlueprint(GLAccountSetupState.class, accountingIntkey).setStateTitle("GL Account Setup").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS);
        plans.addBlueprint(AccountingSalesSetupState.class, accountingIntkey).setStateTitle("Sales Setup").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS);
        plans.addBlueprint(AccountingInvoiceState.class, accountingIntkey).setStateTitle("Invoice Setup").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS);
        plans.addBlueprint(AccountingCustomerAccountState.class, accountingIntkey).setStateTitle("Customer Account").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS);
        plans.addBlueprint(AccountingQuickbooksSetupState.class, accountingIntkey).setStateTitle("QuickBooks Setup").setStatePermission(AllPermissions.CONFIG_INTEGRATIONS);
    }

    private void buildReportScheduling(OfficeMateBlueprintArchitecture plans, String reportSchedulingKey, String configKey) {
        plans.addBranch(reportSchedulingKey, configKey).setStatePermission(AllPermissions.ACCOUNT_ADMIN).setStateTitle("Report Scheduling").setStateTooltip("Configure scheduled emailing of reports.").setStateIcon(IconLoader.get((String)"/officemate/images/clock.png"));
        plans.addBlueprint("Report Config", ReportConfigState.class, reportSchedulingKey);
        plans.addBlueprint("Report Schedule", ReportConfigScheduleState.class, reportSchedulingKey);
    }

    private void buildAdvanced(OfficeMateBlueprintArchitecture plans, String advancedConfigKey, String configKey) {
        plans.addBranch(advancedConfigKey, configKey).setStatePermission(AllPermissions.GOD_ONLY).setStateTitle("Advanced Config").setStateTooltip("Configure advanced settings").setStateIcon(IconLoader.get((String)"/ordermate/images/ordermate_icon.png"));
        plans.addBlueprint(BusinessInfoState.class, advancedConfigKey).setStateTitle("Business Info").setStatePermission(AllPermissions.ACCESS_BUSINESS_INFO);
        plans.addBlueprint(CompositeAdvancedPropertyState.class, advancedConfigKey).setStateTitle("Ordermate Properties").setStatePermission(AllPermissions.ACCESS_ADVANCED_ORDERMATE_PROPERTIES);
        plans.addBlueprint(InternationalizationState.class, advancedConfigKey).setStateTitle("Internationalization").setStatePermission(AllPermissions.GOD_ONLY).setStateIcon(IconLoader.get((String)"/officemate/images/locale16.png"));
        plans.addBlueprint("Custom Parameters", CustomParametersState.class, advancedConfigKey).setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(StoreGroupSetupState.class, advancedConfigKey).setStateTitle("Group Setup").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(SchedulerSetupState.class, advancedConfigKey).setStateTitle("Schedule").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(ApplicationConfigState.class, advancedConfigKey).setStateTitle("Application Config").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(BarcodePrefixState.class, advancedConfigKey).setStateTitle("Barcode Prefix").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(HOConfigState.class, advancedConfigKey).setStateTitle("Head Office Configuration").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(LoyaltyIntegrationState.class, advancedConfigKey).setStateTitle("Loyalty Integration").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(RDConfigState.class, advancedConfigKey).setStateTitle("Restaurant Diary").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(GroovyConsoleState.class, advancedConfigKey).setStateTitle("Dev Console").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(ExperimentalFeatureState.class, advancedConfigKey).setStateTitle("Experimental Features").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(LabourIntegrationState.class, advancedConfigKey).setStateTitle("Labour Integration").setStatePermission(AllPermissions.GOD_ONLY);
        String salesExportKey = "SalesExportConfigurationState";
        plans.addCompositeState(salesExportKey, advancedConfigKey).setStateTitle("Sales Export Integration").setStateTooltip("Configure custom permissions to OfficeMate screens and custom reports.").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(SalesExportIntegrationState.class, salesExportKey).setStateTitle("Sales Export Integration").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(SalesExportFilterState.class, salesExportKey).setStateTitle("Export Mapping").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(ReportPropertyState.class, advancedConfigKey).setStateTitle("Report Properties").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(CloudBackConfigState.class, advancedConfigKey).setStateTitle("Cloud Server Connections").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(DriverTrackingConfigState.class, advancedConfigKey).setStateTitle("Driver Tracking").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(PiggyConfigState.class, advancedConfigKey).setStateTitle("Property Management Integration").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(DiamondReportConfigState.class, advancedConfigKey).setStateTitle("DiamondBack Report").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(ConfigBackupState.class, advancedConfigKey).setStateTitle("Backup Configuration").setStatePermission(AllPermissions.GOD_ONLY);
        String webResource = "webResource";
        plans.addBranch(webResource, advancedConfigKey).setStateTitle("Web Resources").setStateTooltip("Enable Web Resources and Users");
        plans.addBlueprint(WebResourceIntegrationState.class, webResource).setStateTitle("Config").setStatePermission(AllPermissions.GOD_ONLY);
        String webResourcesDetail = "webResourcesDetail";
        plans.addCompositeState(webResourcesDetail, webResource).setStateTitle("Resources").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(WebResourceState.class, webResourcesDetail).setStateTitle("Resources").setStatePermission(AllPermissions.GOD_ONLY).setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(WebResourceLogConfigState.class, webResourcesDetail).setStateTitle("Log Levels").setStatePermission(AllPermissions.GOD_ONLY).setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(WebResourcePropertyState.class, webResource).setStateTitle("Properties").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(WebResourceUserState.class, webResource).setStateTitle("Users").setStatePermission(AllPermissions.GOD_ONLY);
        String feedbackKey = "feedbackKey";
        plans.addCompositeState(feedbackKey, advancedConfigKey).setStateTitle("Feedback").setStateTooltip("Modify Feedback questions").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(QuestionsState.class, feedbackKey).setStateTitle("Questions").setStatePermission(AllPermissions.GOD_ONLY).setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(AnswersState.class, feedbackKey).setStateTitle("Answers").setStatePermission(AllPermissions.GOD_ONLY).setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(AckState.class, feedbackKey).setStateTitle("Acknowledgement").setStatePermission(AllPermissions.GOD_ONLY).setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(PermissionGroupState.class, advancedConfigKey).setStateTitle("Permission Groups").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(FailoverSetupState.class, advancedConfigKey).setStateTitle("Failover").setStatePermission(AllPermissions.GOD_ONLY);
        String messagingKey = "MessagingState";
        plans.addCompositeState(messagingKey, advancedConfigKey).setStateTitle("Messaging").setStateTooltip("Configure messaging parameters (SMS, e-mail, etc.)").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(MailState.class, messagingKey).setStateTitle("E-Mail Servers").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint(SmsState.class, messagingKey).setStateTitle("SMS Provider Settings").setStateType(StateType.TABBED_STATE);
        plans.addBlueprint("Setup Custom Reports", CustomReportSetupState.class, advancedConfigKey).setStatePermission(AllPermissions.GOD_ONLY).setStateTitle("Setup Custom Reports");
        String customPermissionsKey = "CustomPermissionsConfigurationState";
        plans.addCompositeState(customPermissionsKey, advancedConfigKey).setStateTitle("Custom Permissions").setStateTooltip("Configure custom permissions to OfficeMate screens and custom reports.").setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(CustomReportPermissionState.class, customPermissionsKey).setStateTitle("Custom Report Permissions").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint(CustomOfficeMateStatePermissionState.class, customPermissionsKey).setStateTitle("OfficeMate State Permissions").setStateType(StateType.TABBED_STATE).setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint("Style Sheet Setup", ConfigStyleSheetSetupState.class, advancedConfigKey).setStatePermission(AllPermissions.GOD_ONLY);
        plans.addBlueprint("Property Versions", VersionDiffState.class, advancedConfigKey).setStatePermission(AllPermissions.GOD_ONLY);
    }

    private void buildDevices(OfficeMateBlueprintArchitecture plans, String devicesKey, String rootKey) {
        plans.addBranch(devicesKey, rootKey).setStateTitle("Devices").setStateTooltip("Configure Devices").setStatePermission(AllPermissions.ALL_DEVICES);
        plans.addBlueprint(TerminalState.class, devicesKey).setStateTitle("Terminals");
        plans.addBlueprint(PhysicalPrinterState.class, devicesKey).setStateTitle("Physical Printers");
        plans.addBlueprint("Virtual Printer", VirtualPrinterState.class, devicesKey);
        plans.addBlueprint(PrinterLocationsState.class, devicesKey).setStateTitle("Printer Locations");
        plans.addBlueprint("Payoff Printers", PayoffPrinterState.class, devicesKey);
        plans.addBlueprint("Receipt Printers", ReceiptPrinterState.class, devicesKey);
        plans.addBlueprint(CashdrawerState.class, devicesKey).setStateTitle("Cash Drawers");
        plans.addBlueprint(EftposState.class, devicesKey).setStateTitle("EFTPOS").addConditions(new StateBuildCondition[]{new EftposStateBuildCondition()});
        plans.addBlueprint(AdyenIntegrationConfigState.class, devicesKey).setStateTitle("Oolio Integration");
        plans.addBlueprint(CameraState.class, devicesKey).setStateTitle("CCTV Cameras");
        plans.addBlueprint(PoleDisplayState.class, devicesKey).setStateTitle("Pole Displays");
        plans.addBlueprint(ProximityState.class, devicesKey).setStateTitle("Proximity Readers");
        plans.addBlueprint("KTS Docket Printers", KTSDocketPrinterState.class, devicesKey);
        plans.addBlueprint(ScalesState.class, devicesKey).setStateTitle("Scales");
        plans.addBlueprint(CustomerDisplayState.class, devicesKey).setStateTitle("Customer Display");
        plans.addBlueprint("Caller ID", CallerIDUnitState.class, devicesKey);
    }

    private void buildStandardReport(OfficeMateBlueprintArchitecture plans, String parentKey, Class<? extends AbstractTableState> sharedSearchState, Pair<Class<? extends CompositeGuiState>, String> ... statesToBuild) {
        this.buildStandardReport(plans, parentKey, new Class[]{sharedSearchState, JasperReportState.class}, statesToBuild);
    }

    private void buildStandardReport(OfficeMateBlueprintArchitecture plans, String parentKey, Class<? extends BasicOfficeMateState>[] tabbedStates, Pair<Class<? extends CompositeGuiState>, String> ... statesToBuild) {
        for (Pair<Class<? extends CompositeGuiState>, String> pair : statesToBuild) {
            this.layoutHandledCompositeState(plans, (Class)pair.getKey(), parentKey, (String)pair.getValue(), tabbedStates);
        }
    }

    private <D extends CompositeGuiState> void layoutHandledCompositeState(OfficeMateBlueprintArchitecture plans, Class<D> compositeGuiStateClazz, String parentKey, String parentTitle, Class<? extends BasicOfficeMateState> ... tabbedStates) {
        this.layoutHandledCompositeState(plans, compositeGuiStateClazz, parentKey, parentTitle, AllPermissions.ACCESS_SALES_REPORT, tabbedStates);
    }

    private <D extends CompositeGuiState> void layoutHandledCompositeState(OfficeMateBlueprintArchitecture plans, Class<D> compositeGuiStateClazz, String parentKey, String parentTitle, Permission perm, Class<? extends BasicOfficeMateState> ... tabbedStates) {
        plans.addBlueprint(compositeGuiStateClazz, parentKey).setStatePermission(perm).setStateTitle(parentTitle);
    }
}

