/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.statebuilder;

import au.com.ordermate.application.ApplicationStateBlueprint;
import java.util.List;
import officemate.adminkit.state.statebuilder.OfficeMateBlueprint;
import officemate.adminkit.state.statebuilder.OfficeMateBlueprintArchitecture;
import ordermate.database.config.custompermission.CustomPermissionHelper;
import ordermate.database.users.Permission;
import ordermate.database.users.User;

public class OfficeMateBlueprintUtils {
    public static String getAccessLevel(User currentUser, ApplicationStateBlueprint blueprint, OfficeMateBlueprintArchitecture architecture) {
        if (currentUser == null) {
            return "ENABLED";
        }
        String accessLevel = CustomPermissionHelper.getAccessLevelViaKey((String)blueprint.getKey(), (User)currentUser);
        if (accessLevel != null) {
            return accessLevel;
        }
        accessLevel = "ENABLED";
        Permission permission = blueprint.getStatePermission();
        accessLevel = permission != null ? currentUser.getPermissionAccessLevel(permission) : (OfficeMateBlueprintUtils.hasChildBlueprint(blueprint) ? OfficeMateBlueprintUtils.getMostLenientAccessLevel(currentUser, blueprint, architecture) : currentUser.getPermissionAccessLevel(OfficeMateBlueprintUtils.getParentPermission(currentUser, blueprint, architecture)));
        return accessLevel;
    }

    public static String getMostLenientAccessLevel(User currentUser, ApplicationStateBlueprint blueprint, OfficeMateBlueprintArchitecture architecture) {
        String mostLenientChildAccess = "HIDDEN";
        List childKeys = blueprint.getChildStateKeys();
        for (String childKey : childKeys) {
            OfficeMateBlueprint childBlueprint = architecture.getBlueprint(childKey);
            if (childBlueprint == null) continue;
            String childAccess = OfficeMateBlueprintUtils.getAccessLevel(currentUser, childBlueprint, architecture);
            if (childAccess.equals("ENABLED")) {
                mostLenientChildAccess = "ENABLED";
                break;
            }
            if (!childAccess.equals("DISABLED") || !mostLenientChildAccess.equals("HIDDEN")) continue;
            mostLenientChildAccess = "DISABLED";
        }
        return mostLenientChildAccess;
    }

    public static Permission getParentPermission(User currentUser, ApplicationStateBlueprint blueprint, OfficeMateBlueprintArchitecture architecture) {
        if (blueprint.getParentStateKey() != null) {
            OfficeMateBlueprint parentBlueprint = architecture.getBlueprint(blueprint.getParentStateKey());
            return parentBlueprint.getStatePermission() == null ? OfficeMateBlueprintUtils.getParentPermission(currentUser, parentBlueprint, architecture) : parentBlueprint.getStatePermission();
        }
        return null;
    }

    public static boolean hasChildBlueprint(ApplicationStateBlueprint blueprint) {
        return blueprint.getChildStateKeys() != null && blueprint.getChildStateKeys().size() > 0;
    }
}

