/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.statebuilder;

import au.com.ordermate.application.ApplicationBlueprintArchitecture;
import au.com.ordermate.application.ApplicationContext;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.ApplicationStructure;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.application.StateBuildCondition;
import au.com.ordermate.application.StateType;
import au.com.ordermate.guicore.task.GUIStateI;
import au.com.ordermate.util.image.IconLoader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.swing.SwingUtilities;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.CompositeGuiState;
import officemate.adminkit.state.login.LoginState;
import officemate.adminkit.state.reports.closedaccounts.ClosedAccountsReportState;
import officemate.adminkit.state.statebuilder.ApplicationStateBuilder;
import officemate.adminkit.state.statebuilder.ApplicationStateBuilderListener;
import officemate.adminkit.state.statebuilder.OfficeMateBlueprintArchitecture;
import officemate.adminkit.state.statebuilder.OfficeMateStructure;
import officemate.adminkit.state.statebuilder.constructstatestrategy.BasicOfficeMateStateConstructionStrategy;
import officemate.adminkit.state.statebuilder.constructstatestrategy.ClosedAccountsReportStateConstructionStrategy;
import officemate.adminkit.state.statebuilder.constructstatestrategy.CompositeGuiStateConstructionStrategy;
import officemate.adminkit.state.statebuilder.constructstatestrategy.FormalCustomReportStateConstructionStrategy;
import officemate.adminkit.state.statebuilder.constructstatestrategy.GetInstanceConstructionStrategy;
import officemate.adminkit.state.statebuilder.constructstatestrategy.SalesYearOnYearCompositeReportStateConstructionStrategy;
import officemate.adminkit.state.statebuilder.constructstatestrategy.StateConstructionStrategy;
import officemate.screens.favorites.FavoritesData;
import officemate.screens.reports.custom.FormalCustomReportState;
import officemate.screens.reports.salesyearonyear.SalesYearOnYearCompositeReportState;
import ordermate.OrderMate;
import ordermate.database.users.Permission;

public class OfficeMateStateBuilder
implements ApplicationStateBuilder {
    private ApplicationBlueprintArchitecture blueprintArchitecture;
    private ApplicationStructure structure;
    private List<ApplicationStateBuilderListener> myListeners;
    private Map<Class<? extends BasicOfficeMateState>, StateConstructionStrategy> stateConstructionStrategyMap = new HashMap<Class<? extends BasicOfficeMateState>, StateConstructionStrategy>(){
        {
            this.put(BasicOfficeMateState.class, new BasicOfficeMateStateConstructionStrategy());
            this.put(CompositeGuiState.class, new CompositeGuiStateConstructionStrategy());
            this.put(SalesYearOnYearCompositeReportState.class, new SalesYearOnYearCompositeReportStateConstructionStrategy());
            this.put(ClosedAccountsReportState.class, new ClosedAccountsReportStateConstructionStrategy());
            this.put(LoginState.class, new GetInstanceConstructionStrategy());
            this.put(FormalCustomReportState.class, new FormalCustomReportStateConstructionStrategy());
        }
    };

    public OfficeMateStateBuilder(OfficeMateBlueprintArchitecture blueprintArchitecture) {
        if (blueprintArchitecture == null) {
            throw new IllegalStateException("the builder must have an OfficeMateBlueprintArchitecture to build States!");
        }
        this.blueprintArchitecture = blueprintArchitecture;
        this.myListeners = new ArrayList<ApplicationStateBuilderListener>();
    }

    public void addListener(ApplicationStateBuilderListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList<ApplicationStateBuilderListener>();
        }
        this.myListeners.add(listener);
    }

    @Override
    public ApplicationStructure buildStructure() {
        this.structure = new OfficeMateStructure(this.blueprintArchitecture);
        for (String blueprintName : this.blueprintArchitecture.getRootBlueprintKeys()) {
            ((OfficeMateStructure)this.structure).addRootState(blueprintName, this.constructRootState(this.blueprintArchitecture.getBlueprint(blueprintName)));
        }
        LoginState.getInstance().setSmallIcon(IconLoader.get((String)"/officemate/images/exit.png"));
        ((OfficeMateStructure)this.structure).addRootState("Logout", LoginState.getInstance());
        return this.structure;
    }

    private BasicOfficeMateState constructRootState(ApplicationStateBlueprint blueprint) {
        BasicOfficeMateState newState = null;
        if (this.checkAllConditions(blueprint.getStateConditions())) {
            newState = this.constructStateFromBlueprint(blueprint);
            ((OfficeMateStructure)this.structure).addState(blueprint.getKey(), newState);
            List stateKeyList = blueprint.getChildStateKeys();
            if (stateKeyList == null || !stateKeyList.isEmpty()) {
                // empty if block
            }
        }
        return newState;
    }

    public void rebuildStructure(String blueprintKey) {
        ApplicationStateBlueprint blueprint = this.blueprintArchitecture.getBlueprint(blueprintKey);
        this.constructStateIfMissing(blueprint);
        this.rebuildFinished(blueprintKey);
    }

    private void rebuildFinished(String blueprintKey) {
        if (this.myListeners != null) {
            for (ApplicationStateBuilderListener listener : this.myListeners) {
                listener.fireBuildFinished(blueprintKey);
            }
        }
    }

    private BasicOfficeMateState constructStateIfMissing(ApplicationStateBlueprint blueprint) {
        BasicOfficeMateState newState = null;
        if (this.checkAllConditions(blueprint.getStateConditions())) {
            GUIStateI parentState;
            ApplicationStateBlueprint parent = this.blueprintArchitecture.getBlueprint(blueprint.getParentStateKey());
            if (parent != null && parent.isSelfContained() && (parentState = this.structure.resolveBlueprint(parent.getKey())) == null) {
                parentState = this.constructStateIfMissing(parent);
            }
            if ((newState = (BasicOfficeMateState)this.structure.resolveBlueprint(blueprint.getKey())) == null) {
                newState = this.constructStateFromBlueprint(blueprint);
                ((OfficeMateStructure)this.structure).addState(blueprint.getKey(), newState);
                if (blueprint.isSelfContained()) {
                    for (String childKey : blueprint.getChildStateKeys()) {
                        this.addChildState(newState, childKey);
                    }
                }
            }
        }
        return newState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addChildState(BasicOfficeMateState parentState, String childKey) {
        ApplicationStateBlueprint childBlueprint = this.blueprintArchitecture.getBlueprint(childKey);
        childBlueprint.setParentTitle(parentState.getName());
        BasicOfficeMateState childState = this.constructStateIfMissing(childBlueprint);
        if (childState == null) return;
        if (childBlueprint.getStateType().equals((Object)StateType.SUB_STATE)) {
            parentState.addSubState(childState);
        } else {
            if (!childBlueprint.getStateType().equals((Object)StateType.TABBED_STATE)) throw new IllegalStateException("unhandled StateType " + childBlueprint.getStateType());
            if (!(parentState instanceof CompositeGuiState)) throw new IllegalStateException(parentState.getClass().getName() + " is not a CompositeGuiState - don't add tab child states to it.");
            ((CompositeGuiState)parentState).addTabbedSubState(childState);
        }
        childState.setStateKey(childKey);
        ((OfficeMateStructure)this.structure).addState(childKey, childState);
    }

    private boolean checkAllConditions(List<StateBuildCondition> stateConditions) {
        boolean allTrue = true;
        for (StateBuildCondition cond : stateConditions) {
            allTrue &= cond.checkBuildCondition();
        }
        return allTrue;
    }

    private BasicOfficeMateState constructStateFromBlueprint(final ApplicationStateBlueprint blueprint) {
        BasicOfficeMateState toReturn = null;
        if (SwingUtilities.isEventDispatchThread()) {
            try {
                toReturn = this.callStateConstructor(blueprint);
            }
            catch (Exception e) {
                OrderMate.LOG.error("Error Building blueprint for class " + blueprint.getStateClazz().getName(), (Throwable)e);
            }
        } else {
            Callable<BasicOfficeMateState> callable = new Callable<BasicOfficeMateState>(){

                @Override
                public BasicOfficeMateState call() throws Exception {
                    return OfficeMateStateBuilder.this.callStateConstructor(blueprint);
                }
            };
            FutureTask<BasicOfficeMateState> rf = new FutureTask<BasicOfficeMateState>(callable);
            SwingUtilities.invokeLater(rf);
            try {
                toReturn = (BasicOfficeMateState)rf.get();
            }
            catch (Exception e) {
                OrderMate.LOG.error("Error Building blueprint for class " + blueprint.getStateClazz().getName(), (Throwable)e);
            }
        }
        if (toReturn != null) {
            toReturn = this.addAdditionalBlueprintParameters(toReturn, blueprint);
            toReturn.setStateKey(blueprint.getKey());
        }
        return toReturn;
    }

    private BasicOfficeMateState addAdditionalBlueprintParameters(BasicOfficeMateState toReturn, ApplicationStateBlueprint blueprint) {
        if (blueprint.getStatePermission() != null) {
            toReturn.setAccessPermission(blueprint.getStatePermission());
        }
        if (blueprint.getStateTooltip() != null) {
            toReturn.setDescription(blueprint.getStateTooltip());
        }
        if (blueprint.getStateIcon() != null) {
            toReturn.setSmallIcon(blueprint.getStateIcon());
        }
        if (blueprint.getFavoriteStateKey() != null && this.allChildrenAreTabbed(blueprint) && !blueprint.getStateType().equals((Object)StateType.TABBED_STATE)) {
            toReturn.setFavoritesData(new FavoritesData(blueprint.getFavoriteStateKey()));
        }
        if (blueprint.getStateTitle() != null && !blueprint.getStateTitle().contains(".")) {
            toReturn.setName(blueprint.getStateTitle());
        }
        blueprint.setStateTitle(toReturn.getName());
        return toReturn;
    }

    private boolean allChildrenAreTabbed(ApplicationStateBlueprint blueprint) {
        boolean allTabbed = true;
        for (String childKey : blueprint.getChildStateKeys()) {
            ApplicationStateBlueprint childBlue = this.blueprintArchitecture.getBlueprint(childKey);
            allTabbed &= childBlue.getStateType().equals((Object)StateType.TABBED_STATE);
        }
        return allTabbed;
    }

    private BasicOfficeMateState callStateConstructor(ApplicationStateBlueprint blueprint) throws Exception {
        StateConstructionStrategy stratToBuild = this.getConstructionStrategy(blueprint);
        if (stratToBuild != null) {
            return stratToBuild.constructState(blueprint);
        }
        Constructor toConstruct = blueprint.getStateClazzConstructor();
        ArrayList parameterTypes = new ArrayList();
        Collections.addAll(parameterTypes, toConstruct.getParameterTypes());
        if (parameterTypes.size() == 1) {
            if (parameterTypes.contains(ApplicationContext.class)) {
                return (BasicOfficeMateState)toConstruct.newInstance(GuiApp.getAppComplex().getApplicationContext());
            }
            if (parameterTypes.contains(Permission.class)) {
                Object perm = null;
                return (BasicOfficeMateState)toConstruct.newInstance(perm);
            }
        }
        return (BasicOfficeMateState)toConstruct.newInstance(new Object[0]);
    }

    private StateConstructionStrategy getConstructionStrategy(ApplicationStateBlueprint blueprint) {
        return this.stateConstructionStrategyMap.get(blueprint.getStateClazz());
    }
}

