/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.statebuilder;

import au.com.ordermate.application.ApplicationBlueprintArchitecture;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.ApplicationStructure;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.GUIStateI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.CompositeGuiState;
import ordermate.OrderMate;

public class OfficeMateStructure
implements ApplicationStructure {
    private final Map<String, BasicOfficeMateState> allStates = new HashMap<String, BasicOfficeMateState>();
    private List<GUIStateI> rootStates = new ArrayList<GUIStateI>();
    private final ApplicationBlueprintArchitecture architecture;

    public OfficeMateStructure(ApplicationBlueprintArchitecture yourArchitecture) {
        this.architecture = yourArchitecture;
    }

    public void addRootState(String blueprintName, BasicOfficeMateState constructedState) {
        this.rootStates.add(constructedState);
        this.addState(blueprintName, constructedState);
    }

    public void addState(String blueprintName, BasicOfficeMateState constructedState) {
        this.allStates.put(blueprintName, constructedState);
    }

    public List<GUIStateI> getRootStates() {
        return this.rootStates;
    }

    List<BasicOfficeMateState> getAllStates() {
        ArrayList<BasicOfficeMateState> toReturn = new ArrayList<BasicOfficeMateState>(this.allStates.values());
        return Collections.unmodifiableList(toReturn);
    }

    public List<String> getAllStateKeys() {
        ArrayList<String> toReturn = new ArrayList<String>(this.allStates.keySet());
        return Collections.unmodifiableList(toReturn);
    }

    public BasicOfficeMateState getState(String key) {
        return this.getState(key, true);
    }

    public BasicOfficeMateState getState(String key, boolean shouldResolve) {
        BasicOfficeMateState state = this.allStates.get(key);
        if (state == null || state.getStateKey() == null) {
            if (state != null) {
                state.setStateKey(key);
                return state;
            }
            if (shouldResolve) {
                return this.resolveBlueprint(key);
            }
        }
        return state;
    }

    public ApplicationBlueprintArchitecture getArchitecture() {
        return this.architecture;
    }

    public boolean canNavigateTo(String stateKey) {
        ApplicationStateBlueprint blueprint = this.getArchitecture().getBlueprint(stateKey);
        if (blueprint == null) {
            throw new IllegalArgumentException("Unknown key:" + stateKey);
        }
        GUIStateI state = this.allStates.get(blueprint.getKey());
        if (state == null) {
            state = this.allStates.get(blueprint.getParentStateKey());
        }
        if (state == null) {
            OrderMate.LOG.info("Cannot query permission of state, returning false: " + stateKey);
            return false;
        }
        return GuiApp.getAppComplex().getApplicationSecurity().stateIsAccessable(state, GuiApp.getAppComplex().getApplicationSecurity().getUser());
    }

    public BasicOfficeMateState resolveBlueprint(String stateKey) {
        ApplicationStateBlueprint bp = this.architecture.getBlueprint(stateKey);
        if (bp == null) {
            throw new IllegalStateException("Cannot find the blueprint for key " + stateKey);
        }
        String parentKey = bp.getParentStateKey();
        if (parentKey == null) {
            return this.getState(stateKey, false);
        }
        ApplicationStateBlueprint parentBluePrint = this.architecture.getBlueprint(parentKey);
        BasicOfficeMateState parentState = this.getState(parentKey);
        if (parentState instanceof CompositeGuiState) {
            List<BasicOfficeMateState> tabStates = ((CompositeGuiState)parentState).getTabbedStates();
            int index = parentBluePrint.getChildStateKeys().indexOf(stateKey);
            if (index >= 0 && tabStates.size() > index) {
                BasicOfficeMateState realisedState = tabStates.get(index);
                realisedState.setStateKey(stateKey);
                this.allStates.put(stateKey, realisedState);
                OrderMate.LOG.info("Found state " + realisedState + " for " + stateKey);
                return realisedState;
            }
        }
        return this.getState(stateKey, false);
    }
}

