/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.users;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import officemate.adminkit.state.CompositeGuiState;
import officemate.adminkit.state.users.permission.SetupPermissionsState;
import officemate.adminkit.state.users.users.UsersSetupState;
import ordermate.database.stock.StockControlProperty;
import ordermate.database.users.AllPermissions;
import ordermate.database.users.OMApplication;
import ordermate.database.users.Permission;
import ordermate.database.users.User;

public class UsersState
extends CompositeGuiState {
    public UsersState() {
        super("Users", null, "Configure users and permissions");
        this.setupTabbedStates(this.getUserType(), this.setupApplicationPermissions());
    }

    public UsersState(Class<? extends User> userType, Map<OMApplication, Set<Permission>> applicationPermissions) {
        super("Users", null, "Configure users and permissions");
        this.setupTabbedStates(userType, applicationPermissions);
    }

    private void setupTabbedStates(Class<? extends User> userType, Map<OMApplication, Set<Permission>> applicationPermissions) {
        this.addTabbedSubState(new UsersSetupState<User>(userType, AllPermissions.ACCESS_USERS_SCREEN));
        this.addTabbedSubState(new SetupPermissionsState(applicationPermissions, AllPermissions.ACCESS_PERMISSIONS_SCREEN));
    }

    protected Map<OMApplication, Set<Permission>> setupApplicationPermissions() {
        LinkedHashMap<OMApplication, Set<Permission>> appPermissions = new LinkedHashMap<OMApplication, Set<Permission>>();
        for (OMApplication app : AllPermissions.getPermissionsApplications()) {
            if (OMApplication.StockControl.equals((Object)app)) {
                if (!StockControlProperty.getInstance().isStockControlEnabled()) continue;
                appPermissions.put(app, new LinkedHashSet(AllPermissions.getPermissionsForApp((OMApplication)app)));
                continue;
            }
            appPermissions.put(app, new LinkedHashSet(AllPermissions.getPermissionsForApp((OMApplication)app)));
        }
        return appPermissions;
    }

    protected Class<? extends User> getUserType() {
        return User.class;
    }
}

