/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.users.permission;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import ordermate.database.users.Permission;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class PermissionAccessSelector
extends JPanel {
    public final Signal accessLevelSelected = Signals.createSignal(Permission.class, (String)"permission", String.class, (String)"accessLevel");
    private Permission permission;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private AbstractButton enabledButton = new JRadioButton();
    private AbstractButton disabledButton = new JRadioButton();
    private AbstractButton hiddenButton = new JRadioButton();

    public PermissionAccessSelector(Permission perm, int width, int height) {
        this.permission = perm;
        this.setLayout(new GridLayout(1, 3));
        this.setPreferredSize(new Dimension(width, height));
        this.enabledButton.setToolTipText("Enabled");
        this.disabledButton.setToolTipText("Disabled");
        this.hiddenButton.setToolTipText("Hidden");
        this.enabledButton.setSelected(true);
        this.enabledButton.setName(perm + " ENABLED");
        this.disabledButton.setName(perm + " DISABLED");
        this.hiddenButton.setName(perm + " HIDDEN");
        ButtonListener bl = new ButtonListener();
        this.enabledButton.addActionListener(bl);
        this.disabledButton.addActionListener(bl);
        this.hiddenButton.addActionListener(bl);
        this.buttonGroup.add(this.enabledButton);
        this.buttonGroup.add(this.disabledButton);
        this.buttonGroup.add(this.hiddenButton);
        this.add(this.enabledButton);
        this.add(this.disabledButton);
        this.add(this.hiddenButton);
    }

    public void setAccessLevel(String accessLevel) {
        if (accessLevel.equals("ENABLED")) {
            this.enabledButton.setSelected(true);
        } else if (accessLevel.equals("DISABLED")) {
            this.disabledButton.setSelected(true);
        } else if (accessLevel.equals("HIDDEN")) {
            this.hiddenButton.setSelected(true);
        } else {
            throw new IllegalArgumentException("Unrecognised access level: \"" + accessLevel + "\"");
        }
    }

    public Permission getPermission() {
        return this.permission;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.enabledButton.setEnabled(b);
        this.disabledButton.setEnabled(b);
        this.hiddenButton.setEnabled(b);
    }

    public String getAccessLevel() {
        String accessLevel;
        ButtonModel model = this.buttonGroup.getSelection();
        if (model == this.enabledButton.getModel()) {
            accessLevel = "ENABLED";
        } else if (model == this.disabledButton.getModel()) {
            accessLevel = "DISABLED";
        } else if (model == this.hiddenButton.getModel()) {
            accessLevel = "HIDDEN";
        } else {
            throw new IllegalStateException("Unknown permission button selection");
        }
        return accessLevel;
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PermissionAccessSelector.this.accessLevelSelected.emit((Object)PermissionAccessSelector.this.permission, (Object)PermissionAccessSelector.this.getAccessLevel());
        }
    }
}

