/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.users.permission;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JPanel;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class PermissionCategoryAccessSelector
extends JPanel {
    public final Signal accessLevelSelected = Signals.createSignal(List.class, (String)"permissions", String.class, (String)"accessLevel", String.class, (String)"category");
    private String category;
    private List permissions;
    private JComboBox combo;
    private String multipleItem = "(multiple)";
    private String enabledItem = "Enabled";
    private String disabledItem = "Disabled";
    private String hiddenItem = "Hidden";
    private String[] items = new String[]{this.multipleItem, this.enabledItem, this.disabledItem, this.hiddenItem};
    private Icon[] icons = new Icon[]{null, IconLoader.get((String)"/ordermate/images/small_yes16.png"), IconLoader.get((String)"/ordermate/images/disabled.png"), IconLoader.get((String)"/ordermate/images/hidden.png")};
    private final ComboBoxRenderer renderer;
    private final ComboListener comboListener;

    public PermissionCategoryAccessSelector(String permCategory, List permissionList) {
        this.category = permCategory;
        this.permissions = permissionList;
        this.setLayout(new BorderLayout());
        this.combo = new JComboBox<String>(this.items);
        this.comboListener = new ComboListener();
        this.combo.addActionListener(this.comboListener);
        this.renderer = new ComboBoxRenderer();
        this.combo.setRenderer(this.renderer);
        ComponentUtils.setupComboBox((JComboBox)this.combo);
        this.setPreferredSize(new Dimension(120, 20));
        this.add(this.combo);
    }

    public String getCategory() {
        return this.category;
    }

    @Override
    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.renderer.setEnabled(b);
        this.combo.setEnabled(b);
    }

    public void setAccessLevel(String accessLevel) {
        block7: {
            try {
                this.setUpdating(true);
                if (accessLevel == null) {
                    this.combo.setSelectedItem(this.multipleItem);
                    break block7;
                }
                if (accessLevel.equals("ENABLED")) {
                    this.combo.setSelectedItem(this.enabledItem);
                    break block7;
                }
                if (accessLevel.equals("DISABLED")) {
                    this.combo.setSelectedItem(this.disabledItem);
                    break block7;
                }
                if (accessLevel.equals("HIDDEN")) {
                    this.combo.setSelectedItem(this.hiddenItem);
                    break block7;
                }
                throw new IllegalArgumentException("Unrecognised access level: \"" + accessLevel + "\"");
            }
            finally {
                this.setUpdating(false);
            }
        }
    }

    public String getAccessLevel() {
        String accessLevel;
        Object selectedItem = this.combo.getSelectedItem();
        if (selectedItem.equals(this.multipleItem)) {
            return null;
        }
        if (selectedItem.equals(this.enabledItem)) {
            accessLevel = "ENABLED";
        } else if (selectedItem.equals(this.disabledItem)) {
            accessLevel = "DISABLED";
        } else if (selectedItem.equals(this.hiddenItem)) {
            accessLevel = "HIDDEN";
        } else {
            throw new IllegalStateException("Unrecognised seelcte");
        }
        return accessLevel;
    }

    private void setUpdating(boolean isUpdating) {
        this.comboListener.setFireEvents(!isUpdating);
    }

    private class ComboBoxRenderer
    extends DefaultListCellRenderer {
        public ComboBoxRenderer() {
            this.setOpaque(true);
            this.setHorizontalAlignment(2);
            this.setVerticalAlignment(0);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            int selectedIndex;
            int n = selectedIndex = index != -1 ? index : PermissionCategoryAccessSelector.this.combo.getSelectedIndex();
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            if (value == PermissionCategoryAccessSelector.this.multipleItem) {
                this.setForeground(Color.gray);
            }
            this.setText(PermissionCategoryAccessSelector.this.items[selectedIndex]);
            this.setIcon(PermissionCategoryAccessSelector.this.icons[selectedIndex]);
            return this;
        }
    }

    private class ComboListener
    implements ActionListener {
        private boolean fireEvents = true;

        private ComboListener() {
        }

        protected void setFireEvents(boolean fire) {
            this.fireEvents = fire;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.fireEvents) {
                PermissionCategoryAccessSelector.this.accessLevelSelected.emit((Object)PermissionCategoryAccessSelector.this.permissions, (Object)PermissionCategoryAccessSelector.this.getAccessLevel(), (Object)PermissionCategoryAccessSelector.this.category);
            }
        }
    }
}

