/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.users.permission;

import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import ordermate.database.users.OMApplication;
import ordermate.database.users.Permission;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class PermissionTreePanel
extends JPanel
implements TreeSelectionListener {
    private JTree permissionCategoriesTree;
    public final Signal gotPermissionApp = Signals.createSignal(OMApplication.class, (String)"The application to display permissions for");

    public PermissionTreePanel(Map<OMApplication, Set<Permission>> applicationPermissions) {
        super(new BorderLayout());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Permission Categories");
        for (OMApplication app : applicationPermissions.keySet()) {
            root.add(new DefaultMutableTreeNode(app));
        }
        this.permissionCategoriesTree = new JTree(root);
        this.add((Component)this.permissionCategoriesTree, "Center");
        this.permissionCategoriesTree.setName("Permission Categories");
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setLeafIcon(IconLoader.get((String)"/ordermate/images/keys.png"));
        renderer.setOpenIcon(IconLoader.get((String)"/ordermate/images/orange_folder.png"));
        this.permissionCategoriesTree.setCellRenderer(renderer);
        this.permissionCategoriesTree.setSelectionRow(1);
        this.permissionCategoriesTree.getSelectionModel().setSelectionMode(1);
        this.permissionCategoriesTree.addTreeSelectionListener(this);
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.permissionCategoriesTree.getLastSelectedPathComponent();
        if (node == null || node.isRoot()) {
            return;
        }
        this.gotPermissionApp.emit(node.getUserObject());
    }

    public OMApplication getCurrentApplication() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.permissionCategoriesTree.getLastSelectedPathComponent();
        return (OMApplication)node.getUserObject();
    }
}

