/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.users.permission;

import au.com.ordermate.util.image.IconLoader;
import java.util.Map;
import java.util.Set;
import officemate.adminkit.state.BasicOfficeMateState;
import officemate.adminkit.state.users.permission.SetupPermissionsPanel;
import ordermate.OrderMate;
import ordermate.database.users.OMApplication;
import ordermate.database.users.Permission;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.PermissionGroupLink;

public class SetupPermissionsState
extends BasicOfficeMateState {
    private SetupPermissionsPanel panel;
    private Map<OMApplication, Set<Permission>> applicationPermissions;

    public SetupPermissionsState(Map<OMApplication, Set<Permission>> appPermissions, Permission permission) {
        super("Permission Group", permission, "Edit user privileges");
        this.setSmallIcon(IconLoader.get((String)"/ordermate/images/keys.png"));
        this.applicationPermissions = appPermissions;
    }

    private void setupGUI() {
        this.panel = new SetupPermissionsPanel(this.applicationPermissions, PermissionGroup.getUniquePermissionGroups());
        this.panel.accessLevelSelected.connect((Object)this, "gotAccessLevelSelected");
        this.setScreenPanel(this.panel);
    }

    @Override
    protected void init() {
        super.init();
        this.setupGUI();
    }

    @Override
    public void refresh() {
    }

    void gotAccessLevelSelected(PermissionGroup group, Permission permission, String accessLevel) {
        OrderMate.LOG.info(group + " Got access level selected for permission : " + permission + " " + accessLevel + " by user " + this.getUser());
        PermissionGroupLink link = group.getPermissionLink(permission);
        group.setAccessLevel(permission, accessLevel);
        link.saveChild();
        this.setUpdateRequired();
    }
}

