/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.users.users;

import au.com.ordermate.util.Price;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import officemate.adminkit.fieldpanels.PriceFieldPanel;
import officemate.adminkit.types.PriceFieldType;
import ordermate.database.departments.Department;
import ordermate.database.departments.Payrate;
import ordermate.database.queries.department.DepartmentQueries;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;

public class PayrateEditor
extends JPanel {
    private User currentUser;
    private JComboBox deptCombo;
    private ComboBoxModel deptComboModel;
    private PriceFieldPanel payRate;
    private EventList<Department> allDeptList = GlazedLists.eventList((Collection)DepartmentQueries.getAllDepartments());

    public PayrateEditor() {
        this.payRate = new PriceFieldPanel(null);
        this.payRate.setFieldType(new PriceFieldType(0.0, Double.MAX_VALUE, 0.0));
        this.payRate.setName("payRate");
        this.deptComboModel = new EventComboBoxModel(this.allDeptList);
        this.deptCombo = new JComboBox(this.deptComboModel);
        this.deptCombo.setSelectedIndex(0);
        FieldPanelBuilder builder = new FieldPanelBuilder(5);
        builder.addRow("Department", (Component)this.deptCombo);
        builder.addRow("Pay Rate", (Component)this.payRate);
        this.add(builder.getPanel());
    }

    public void setupEditor(User parent, List<Department> unselectedDepartments) {
        this.currentUser = parent;
        this.payRate.setValue(Price.ZERO_DOLLAR);
        this.allDeptList.clear();
        this.allDeptList.addAll(unselectedDepartments);
        this.deptCombo.setSelectedIndex(0);
    }

    public Payrate getPayRate() {
        Payrate rate = new Payrate(this.currentUser, (Department)this.deptCombo.getSelectedItem());
        rate.setPayRate(Price.parsePrice((String)this.payRate.getValue().toString()));
        return rate;
    }
}

