/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.users.users;

import au.com.ordermate.glazedlists.GlazedListUtils;
import au.com.ordermate.gui.actions.BasicAction;
import au.com.ordermate.util.image.IconLoader;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.dialogs.OkCancelDialogBuilder;
import officemate.adminkit.state.users.users.PayrateEditor;
import officemate.components.table.PersistentObjectTable;
import officemate.components.tableformat.ColumnTableFormat;
import officemate.components.tableformat.EditablePropertyColumnFormat;
import ordermate.database.departments.Department;
import ordermate.database.departments.Payrate;
import ordermate.database.queries.department.DepartmentQueries;
import ordermate.database.users.User;
import ordermate.reports.table.ColumnFormat;
import ordermate.reports.table.PropertyColumnFormat;

public class PayratesPanel
extends JPanel
implements ListEventListener {
    private JButton addButton;
    private JButton removeButton;
    private User user;
    private PersistentObjectTable<Payrate> table;
    private EventList<Payrate> payrateEventList;
    private Set<Payrate> addedItems;
    private Set<Payrate> deletedItems;
    private PayrateEditor payrateEditor;

    public PayratesPanel(EventList<Payrate> payrateEvent) {
        super(new BorderLayout());
        this.payrateEventList = payrateEvent;
        this.payrateEventList.addListEventListener((ListEventListener)this);
        this.addedItems = new HashSet<Payrate>();
        this.deletedItems = new HashSet<Payrate>();
        this.payrateEditor = new PayrateEditor();
        this.setupComponents();
    }

    private void setupComponents() {
        this.setPreferredSize(new Dimension(300, 140));
        this.addButton = new JButton((Action)((Object)new AddPayrateAction()));
        this.addButton.setName("add payrate");
        RemovePayrateAction remAction = new RemovePayrateAction();
        this.removeButton = new JButton((Action)((Object)remAction));
        this.removeButton.setName("remove payrate");
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(this.addButton);
        buttonPanel.add(this.removeButton);
        this.add((Component)buttonPanel, "East");
        this.table = new PersistentObjectTable<Payrate>(this.payrateEventList, new ColumnTableFormat(){
            {
                this.addColumn((ColumnFormat)new PropertyColumnFormat(Payrate.Properties.DEPARTMENT));
                this.addColumn(new EditablePropertyColumnFormat(Payrate.Properties.PAY_RATE));
            }
        });
        this.table.setName("departmentTable");
        this.add(this.table, "Center");
        this.table.addSelectionDependentAction((Action)((Object)remAction));
    }

    public void setObject(User user) {
        this.user = user;
        this.table.getTable().getSelectionModel().clearSelection();
    }

    public void save() {
        for (Payrate rate : this.addedItems) {
            this.user.addPayrate(rate);
        }
        for (Payrate payrate : this.deletedItems) {
            this.user.removePayrate(payrate);
        }
        this.addedItems.clear();
        this.deletedItems.clear();
    }

    public void cancel() {
        this.addedItems.clear();
        this.deletedItems.clear();
    }

    public void listChanged(ListEvent listChanges) {
    }

    private class RemovePayrateAction
    extends BasicAction {
        RemovePayrateAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/delete_icon22.png"), "Remove");
        }

        public void actionPerformed(ActionEvent e) {
            if (PayratesPanel.this.table.getAllSelectedObjects().size() < PayratesPanel.this.payrateEventList.size()) {
                PayratesPanel.this.deletedItems.addAll(PayratesPanel.this.table.getAllSelectedObjects());
                GlazedListUtils.removeInList((EventList)PayratesPanel.this.payrateEventList, PayratesPanel.this.table.getAllSelectedObjects());
            } else {
                Dialogs.showInfoDialog("Delete Cancelled", "You must have at least 1 Department Payrate");
            }
        }
    }

    private class AddPayrateAction
    extends BasicAction {
        AddPayrateAction() {
            super("", (Icon)IconLoader.get((String)"/ordermate/images/new_icon22.png"), "Add a group...");
        }

        public void actionPerformed(ActionEvent e) {
            Department defaultDept = DepartmentQueries.getFirstDepartment();
            if (defaultDept == null) {
                throw new IllegalStateException("System does not have any departments to assign payrates to!");
            }
            List<Department> unselectedDepartments = this.filterPayratesUsed((EventList<Payrate>)PayratesPanel.this.payrateEventList);
            if (!unselectedDepartments.isEmpty()) {
                PayratesPanel.this.payrateEditor.setupEditor(PayratesPanel.this.user, unselectedDepartments);
                OkCancelDialogBuilder dialog = Dialogs.getOkCancelDialogBuilder(PayratesPanel.this.payrateEditor);
                dialog.setTitle("Create new Payrate").doPack();
                if (dialog.doShow()) {
                    Payrate newPayrate = PayratesPanel.this.payrateEditor.getPayRate();
                    if (PayratesPanel.this.user != null) {
                        GlazedListUtils.add((EventList)PayratesPanel.this.payrateEventList, (Object)newPayrate);
                        PayratesPanel.this.addedItems.add(newPayrate);
                    }
                }
            } else {
                Dialogs.showErrorDialog("Cannot create new Pay Rate", "There are no more Departments to add a new pay rate to! Either Delete or Edit existing pay rates.");
            }
        }

        private List<Department> filterPayratesUsed(EventList<Payrate> selectedPayrates) {
            List toReturn = DepartmentQueries.getAllDepartments();
            for (Payrate payrateDeptToRemove : selectedPayrates) {
                toReturn.remove(payrateDeptToRemove.getDepartment());
            }
            return toReturn;
        }
    }
}

