/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.users.users;

import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.util.Price;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import com.sun.jersey.api.client.ClientResponse;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.ws.rs.core.Response;
import officemate.adminkit.OfficeMateAdminGuiUtils;
import officemate.adminkit.dialogs.Dialogs;
import officemate.adminkit.state.login.LoginState;
import officemate.adminkit.state.users.users.PayratesPanel;
import officemate.components.AbstractObjectEditor;
import ordermate.OrderMate;
import ordermate.database.departments.Payrate;
import ordermate.database.gui.FavouriteEntryHelper;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.DriverAssignmentSettlementType;
import ordermate.database.users.PermissionGroup;
import ordermate.database.users.User;
import ordermate.gui.FieldPanelBuilder;
import ordermate.gui.binding.converter.PriceToStringConverter;
import ordermate.gui.binding.validators.EmailValidator;
import ordermate.gui.binding.validators.NotEmptyValidator;
import ordermate.gui.binding.validators.ObjectValidator;
import ordermate.gui.binding.validators.PinValidator;
import ordermate.integration.controlcenter.ControlCenterRequest;
import ordermate.integration.controlcenter.ControlCenterSyncFactory;
import ordermate.integration.controlcenter.ControlCentreRequestFactory;
import ordermate.internationalization.Internationalization;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.Converter;
import org.jdesktop.beansbinding.Validator;
import org.jdesktop.swingx.JXDatePicker;

public class UserEditorPanel<T extends User>
extends AbstractObjectEditor<T>
implements ActionListener {
    private List<PermissionGroup> groups;
    private JComboBox groupBox;
    private PinValidator pinValidator;
    private EventList<Payrate> payrateEvent = GlazedLists.eventList(new ArrayList());
    private PayratesPanel payratesPanel;
    private JButton portalAccessButton;
    private JButton passwdResetButton;
    private JTextField emailField;
    private JTextField lastField;
    private EmailValidator emailValidator = new EmailValidator();

    public UserEditorPanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.buildPanel().getPanel(), "Center");
    }

    @Override
    public void saveObject() {
        super.saveObject();
        this.addFavourites();
    }

    private void addFavourites() {
        String ACTIVE = "ACTIVE";
        User user = (User)this.getObject();
        if (!user.isPersistent() && user.isActive() && "ACTIVE".equals(user.getSystemState())) {
            FavouriteEntryHelper.createDefaultFavouritesForUser((User)((User)this.getObject()));
        }
    }

    protected FieldPanelBuilder getBasicPanel() {
        FieldPanelBuilder builder = new FieldPanelBuilder();
        JTextField nameField = new JTextField(20);
        Binding nameBinding = this.getBindings().createBinding(User.Properties.FIRST_NAME.getName(), (Object)nameField, "text");
        nameBinding.setValidator((Validator)new NotEmptyValidator());
        builder.addRow("First Name", (Component)nameField);
        this.lastField = new JTextField(20);
        this.getBindings().createBinding(User.Properties.LAST_NAME.getName(), (Object)this.lastField, "text");
        builder.addRow("Last Name", (Component)this.lastField);
        builder.addRow("Password", (Component)this.setupPasswordField(User.Properties.PASSWORD, 20));
        this.groupBox = new JComboBox();
        this.groupBox.setName("permissionGroup");
        this.groups = new ArrayList<PermissionGroup>();
        Binding groupBinding = this.getBindings().createJComboBoxBinding(User.Properties.PERMISSION_GROUP, this.groupBox, this.groups);
        groupBinding.setValidator((Validator)new ObjectValidator(PermissionGroup.class, false));
        builder.addRow("Permission Group", (Component)this.groupBox);
        ComponentUtils.setupComboBox((JComboBox)this.groupBox);
        return builder;
    }

    protected FieldPanelBuilder buildPanel() {
        FieldPanelBuilder builder = this.getBasicPanel();
        JTextField cardField = new JTextField(20);
        this.getBindings().createBinding(User.Properties.CARD_ID.getName(), (Object)cardField, "text");
        builder.addRow("Card ID", (Component)cardField);
        JPasswordField pinField = new JPasswordField(20);
        Binding pinBinding = this.getBindings().createBinding(User.Properties.PIN.getName(), (Object)pinField, "text");
        builder.addRow("PIN", (Component)pinField);
        this.pinValidator = new PinValidator();
        pinBinding.setValidator((Validator)this.pinValidator);
        JTextField payrollField = new JTextField(20);
        this.getBindings().createBinding(User.Properties.PAYROLL_ID.getName(), (Object)payrollField, "text");
        builder.addRow("Payroll ID", (Component)payrollField);
        if (SystemProperty.getInstance().getDriverAssignmentSettlement() != DriverAssignmentSettlementType.NONE) {
            JTextField perDeliveryField = new JTextField(20);
            Binding perDeliveryBinding = this.getBindings().createBinding(User.Properties.PER_DELIVERY_RATE, (Object)perDeliveryField, "text");
            perDeliveryBinding.setConverter((Converter)new PriceToStringConverter(Price.DEFAULT_ROUND_AMOUNT));
            builder.addRow("Per Delivery Rate " + Internationalization.getLiteralFor((String)"DOLLAR_SIGN"), (Component)perDeliveryField);
        }
        JCheckBox active = new JCheckBox();
        this.getBindings().createBinding(User.Properties.ACTIVE.getName(), (Object)active, "selected");
        builder.addRow("Active", (Component)active);
        if (SystemProperty.getInstance().getDriverAssignmentSettlement() != DriverAssignmentSettlementType.NONE) {
            JCheckBox driverField = new JCheckBox();
            this.getBindings().createBinding(User.Properties.DRIVER.getName(), (Object)driverField, "selected");
            builder.addRow("Delivery Driver", (Component)driverField);
        }
        this.emailField = this.setupTextField(User.Properties.EMAIL, 40, (Validator)new EmailValidator());
        builder.addRow("Email", (Component)this.emailField);
        JTextField mobileField = this.setupTextField(User.Properties.MOBILE, 20);
        builder.addRow("Mobile", (Component)mobileField);
        JXDatePicker dobField = this.setupDatePicker(User.Properties.DATE_OF_BIRTH);
        builder.addRow("Date of Birth", (Component)dobField);
        builder.addSeparator("Pay Rates");
        this.payratesPanel = new PayratesPanel(this.payrateEvent);
        this.payratesPanel.setName("payRatePanel");
        builder.addRow("", (Component)this.payratesPanel);
        this.addPortalComponents(builder);
        return builder;
    }

    private void addPortalComponents(FieldPanelBuilder builder) {
        this.portalAccessButton = new JButton("Portal Access");
        this.portalAccessButton.setName("portalAccess");
        this.portalAccessButton.addActionListener(this);
        this.passwdResetButton = new JButton("Reset Password");
        this.passwdResetButton.setName("Reset Password");
        this.passwdResetButton.addActionListener(this);
        Dimension buttonSize = new Dimension((int)this.passwdResetButton.getPreferredSize().getWidth(), (int)this.passwdResetButton.getPreferredSize().getHeight());
        this.portalAccessButton.setPreferredSize(buttonSize);
        builder.addSeparator("Portal Access");
        builder.addRow(" ", (Component)this.portalAccessButton);
        builder.addRow(" ", (Component)this.passwdResetButton);
    }

    @Override
    public void setObject(T toEdit) {
        T userToEdit = toEdit;
        User currentUser = LoginState.getInstance().getUser();
        boolean adminPermission = this.userHasPermissionToGrantControlCentreAccess();
        this.portalAccessButton.setVisible(adminPermission);
        this.passwdResetButton.setVisible(adminPermission);
        OfficeMateAdminGuiUtils.getInstance().refreshList(this.payrateEvent, userToEdit.getPayrates());
        if (currentUser.getCachedPermissionGroup() == null) {
            throw new IllegalStateException("The current user has no permission level set.");
        }
        if (userToEdit.getCachedPermissionGroup() != null && userToEdit.getCachedPermissionGroup().getLevel() > currentUser.getCachedPermissionGroup().getLevel()) {
            throw new IllegalStateException("The current user cannot change details of this user whose permission are higher");
        }
        this.groups.clear();
        this.groups.addAll(this.getAuthorizedPermissionGroups(currentUser));
        if (this.pinValidator != null) {
            this.pinValidator.setCurrentUser(userToEdit);
        }
        if (this.emailValidator != null) {
            this.emailValidator.setCurrentUser(userToEdit);
        }
        if (this.payratesPanel != null) {
            this.payratesPanel.setObject((User)toEdit);
        }
        super.setObject(toEdit);
    }

    private boolean userHasPermissionToGrantControlCentreAccess() {
        try {
            User currentUser = LoginState.getInstance().getUser();
            return currentUser.getPermissionGroup().getLevel() >= PermissionGroup.getPermissionGroupForName((String)"Administrator").getLevel();
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Couldn't evaluate if the current user can grant CC access, falling back to deny.", (Throwable)e);
            return false;
        }
    }

    private List<PermissionGroup> getAuthorizedPermissionGroups(User user) {
        ArrayList<PermissionGroup> authGroups = null;
        ArrayList<PermissionGroup> allGroups = PermissionGroup.getUniquePermissionGroups();
        if (user.isSystemAdministrator()) {
            authGroups = allGroups;
        } else {
            authGroups = new ArrayList<PermissionGroup>();
            for (int i = 0; i < allGroups.size(); ++i) {
                if (((PermissionGroup)allGroups.get(i)).getLevel() > user.getCachedPermissionGroup().getLevel()) continue;
                authGroups.add((PermissionGroup)allGroups.get(i));
            }
        }
        return authGroups;
    }

    public void setMinPinLength(int value) {
        this.pinValidator.setMinLength(value);
    }

    public void save() {
        if (this.payratesPanel != null) {
            this.payratesPanel.save();
        }
    }

    public void cancel() {
        if (this.payratesPanel != null) {
            this.payratesPanel.cancel();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JButton source = (JButton)e.getSource();
        if (this.portalAccessButton.equals(source)) {
            this.linkUserToStore();
        } else if (this.passwdResetButton.equals(source)) {
            this.resetPassword();
        }
    }

    private void linkUserToStore() {
        String emailId = this.emailField.getText();
        String lastName = this.lastField.getText();
        ControlCenterRequest portalRequest = ControlCentreRequestFactory.getControlCentreRequest();
        boolean pinReceived = false;
        String receivedPin = null;
        Validator.Result result = null;
        result = this.emailValidator.validate(emailId);
        if (result != null) {
            this.emailField.requestFocus();
            Dialogs.showErrorDialog("ERROR", result.getDescription());
            return;
        }
        if (ControlCenterSyncFactory.getControlCenterSync().getStoreId() == 0L) {
            Dialogs.showErrorDialog("ERROR", "Please set the correct store Id");
            return;
        }
        ClientResponse response = portalRequest.requestLinkStore(emailId);
        if (this.isResponseSuccessful(response)) {
            OrderMate.LOG.info("requestLinkStore : successful");
            receivedPin = portalRequest.getPin(response);
            pinReceived = true;
        } else if (response.getStatus() == Response.Status.BAD_REQUEST.getStatusCode()) {
            String errorResponseMsg = (String)response.getEntity(String.class);
            OrderMate.LOG.info("requestLinkStore : bad request " + errorResponseMsg);
            if (errorResponseMsg.contains("NO user for the given email") && (response = portalRequest.linkNewUser(lastName, emailId)).getStatus() / 100 == 2) {
                OrderMate.LOG.info("linkNewUser : successful");
                pinReceived = true;
                receivedPin = portalRequest.getPin(response);
                OrderMate.LOG.info("linkNewUser : obtained pin " + receivedPin);
            }
        }
        if (pinReceived && this.isResponseSuccessful(portalRequest.doLinkStore(emailId, receivedPin))) {
            OrderMate.LOG.info("doLinkStore : Successful : email :" + emailId);
            Dialogs.showInfoDialog("SUCCESS", "User is linked to store successfully");
        } else {
            OrderMate.LOG.info("pinReceived is false :" + emailId);
            Dialogs.showErrorDialog("ERROR", "Linking to store failed");
        }
    }

    private void resetPassword() {
        OrderMate.LOG.info("Requesting for CC password reset.");
        String emailId = this.emailField.getText();
        ControlCenterRequest handler = ControlCentreRequestFactory.getControlCentreRequest();
        try {
            Validator.Result result = this.emailValidator.validate(emailId);
            if (result != null) {
                this.emailField.requestFocus();
                Dialogs.showErrorDialog("ERROR", result.getDescription());
                return;
            }
            ClientResponse response = handler.requestForgotPassword(emailId);
            if (response.getStatus() == Response.Status.OK.getStatusCode()) {
                String OK_MESSAGE = "Request successful. Please check your email inbox.";
                String TITLE = "Request Success";
                Dialogs.showMessageDialog("Request Success", "Request successful. Please check your email inbox.");
            } else {
                String ERROR_MESSAGE = "Error sending request: " + response.getStatus() + " - " + response.getClientResponseStatus() + "\nPlease check the logs.";
                String TITLE = "Request Error";
                Dialogs.showErrorDialog("Request Error", ERROR_MESSAGE);
            }
        }
        catch (Exception e) {
            OrderMate.LOG.error("Error requesting for password: " + e.getMessage());
        }
    }

    private boolean isResponseSuccessful(ClientResponse response) {
        return response != null && response.getStatus() / 100 == 2;
    }
}

