/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.welcome;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.GUIStateI;
import java.awt.Color;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import officemate.OfficeMate;
import officemate.adminkit.state.welcome.MouseClickAdapter;
import officemate.components.controls.RectangleRoundedBorder;
import ordermate.database.gui.FavouritesEntry;

public class FavouriteComponent
extends JLabel {
    private final Color FG_COLOR = new Color(126, 135, 151);
    private final Color BG_COLOR = Color.WHITE;
    private final int ICON_TEXT_GAP = 20;
    private final FavouritesEntry favouritesEntry;
    private GUIStateI state;

    public FavouriteComponent(Icon icon, FavouritesEntry favouritesEntry) {
        super(icon, 2);
        this.setBackground(this.BG_COLOR);
        this.setForeground(this.FG_COLOR);
        this.setAlignmentX(0.5f);
        this.setIconTextGap(20);
        this.setOpaque(true);
        this.setBorder(this.createBorder());
        this.favouritesEntry = favouritesEntry;
        this.loadFavoriteState();
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
            }
        });
        this.addMouseListener(new MouseClickAdapter(""){

            @Override
            public void mouseClicked(MouseEvent e) {
                FavouriteComponent.this.openFavoriteState();
            }
        });
    }

    private Border createBorder() {
        return new RectangleRoundedBorder(Color.WHITE, 0, 10);
    }

    private void loadFavoriteState() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    FavouriteComponent.this.state = GuiApp.getAppComplex().getApplicationStructure().getState(FavouriteComponent.this.favouritesEntry.getFavouritesID());
                    FavouriteComponent.this.setText(FavouriteComponent.this.state.getName());
                    FavouriteComponent.this.setName(FavouriteComponent.this.state.getName());
                }
                catch (Exception ex) {
                    OfficeMate.LOG.error(ex.getMessage(), (Throwable)ex);
                }
            }
        });
    }

    private void openFavoriteState() {
        GuiApp.getAppComplex().getApplicationNavigator().navigateTo(this.state.getStateKey());
    }
}

