/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.welcome;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.GraphPaperLayout;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.guicore.task.GUIStateI;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import officemate.adminkit.state.welcome.KnowledgeBaseArticlePanel;
import officemate.adminkit.state.welcome.YourFavouritesComponent;
import ordermate.database.gui.FavouriteEntryHelper;
import ordermate.database.gui.FavouritesEntry;
import ordermate.database.users.User;
import ordermate.signals.Signal;
import ordermate.signals.Signals;

public class MainWelcomePanel
extends JPanel {
    private ImageIcon backgroundImageIcon = null;
    private Image backgroundImageScaled = null;
    private YourFavouritesComponent yourFavouritesComponent = null;
    private KnowledgeBaseArticlePanel kbPanel = null;
    public final Signal statePressed = Signals.createSignal(GUIStateI.class, (String)"selectedState");
    private List<FavouritesEntry> recentFavourites = null;
    private int FAVOURITE_COUNT = -1;
    private Dimension minimumSize = new Dimension(800, 600);

    public MainWelcomePanel() {
        this.createBackgroundImageIcon();
        this.setName("MainWelcomePanel");
    }

    void init() {
        int oldFavs = this.FAVOURITE_COUNT;
        this.loadFavourites();
        if (oldFavs != this.FAVOURITE_COUNT) {
            this.removeAll();
            this.setLayout((LayoutManager)this.createLayout());
            this.addTitleLabel();
            this.addFavouriteComponent();
            this.addKnowledgebaseArticles();
        }
    }

    private User getCurrentUser() {
        return GuiApp.getAppComplex().getApplicationSecurity().getUser();
    }

    private void loadFavourites() {
        this.recentFavourites = FavouriteEntryHelper.getRecentFavourites((User)this.getCurrentUser(), (int)4);
        this.FAVOURITE_COUNT = this.recentFavourites != null ? this.recentFavourites.size() : 0;
    }

    private GraphPaperLayout createLayout() {
        if (this.FAVOURITE_COUNT > 0) {
            return new GraphPaperLayout(3, 7);
        }
        return new GraphPaperLayout(3, 5);
    }

    private void addTitleLabel() {
        JLabel label = new JLabel("OfficeMate", 0);
        label.setFont(ComponentUtils.SANS_SERIF_BOLD_30);
        this.add((Component)label, new Rectangle(0, 0, 2, 1));
    }

    private void addFavouriteComponent() {
        if (this.FAVOURITE_COUNT > 0) {
            this.yourFavouritesComponent = new YourFavouritesComponent(this.recentFavourites);
            this.add((Component)this.yourFavouritesComponent, new Rectangle(0, 1, 2, 2));
        }
    }

    private void addKnowledgebaseArticles() {
        this.kbPanel = new KnowledgeBaseArticlePanel();
        if (this.FAVOURITE_COUNT > 0) {
            this.add((Component)this.kbPanel, new Rectangle(0, 3, 2, 4));
            return;
        }
        this.add((Component)this.kbPanel, new Rectangle(0, 1, 2, 4));
    }

    private void drawBackgroundImage(Graphics2D g2) {
        g2.drawImage(this.backgroundImageScaled, null, null);
    }

    private void createBackgroundImageIcon() {
        int width = this.getWidth();
        int height = this.getHeight();
        if (width > 0 && height > 0) {
            ImageIcon backgroundIcon = IconLoader.get((String)"/ordermate/images/welcome_background.jpg");
            this.backgroundImageScaled = backgroundIcon.getImage().getScaledInstance(width, height, 4);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawBackgroundImage(g2);
    }

    @Override
    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.createBackgroundImageIcon();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.minimumSize;
    }
}

