/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.welcome;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;

public class RectangleRoundedBorder
extends AbstractBorder {
    private Color borderColor;
    private int borderThickness = 4;
    private int borderRadius = 8;
    private Insets insets = null;
    private BasicStroke stroke = null;
    private int strokePad;
    private RenderingHints hints;

    public RectangleRoundedBorder(Color borderColor, int borderThickness, int borderRadius) {
        this.borderColor = borderColor;
        this.borderThickness = borderThickness;
        this.borderRadius = borderRadius;
        this.stroke = new BasicStroke(borderThickness);
        this.strokePad = borderThickness / 2;
        this.hints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int pad = borderRadius + this.strokePad;
        this.insets = new Insets(pad, pad, pad, pad);
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getBorderInsets(c);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        int bottomLineY = height - this.borderThickness;
        RoundRectangle2D.Double bubble = new RoundRectangle2D.Double(0 + this.strokePad, 0 + this.strokePad, width - this.borderThickness, bottomLineY, this.borderRadius, this.borderRadius);
        Area area = new Area(bubble);
        g2.setRenderingHints(this.hints);
        Container parent = c.getParent();
        if (parent != null) {
            Color bg = parent.getBackground();
            Rectangle rect = new Rectangle(0, 0, width, height);
            Area borderRegion = new Area(rect);
            borderRegion.subtract(area);
            g2.setClip(borderRegion);
            g2.setColor(bg);
            g2.fillRect(0, 0, width, height);
            g2.setClip(null);
        }
        g2.setColor(this.borderColor);
        g2.setStroke(this.stroke);
        g2.draw(area);
    }
}

