/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.welcome;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.GUIStateI;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JButton;
import officemate.adminkit.state.BasicOfficeMateState;

public class WelcomeLinkButton
extends JButton {
    private GUIStateI state;

    public WelcomeLinkButton(GUIStateI guiState) {
        super("<html><font color=\"white\">" + guiState.getName() + "</font></html>");
        this.setContentAreaFilled(false);
        this.setForeground(Color.WHITE);
        this.setFont(new Font("Arial", 0, 20));
        this.setBorder(null);
        this.setBorderPainted(false);
        this.setRolloverEnabled(true);
        this.setHorizontalAlignment(2);
        this.state = guiState;
        this.setIconTextGap(10);
        this.setIcon(new CircleIcon());
        this.setRolloverIcon(new FilledCircleIcon());
        this.setRolloverSelectedIcon(new FilledCircleIcon());
        this.setSelectedIcon(new FilledCircleIcon());
    }

    public void updateSecurityState() {
        if (this.state instanceof BasicOfficeMateState) {
            BasicOfficeMateState adminState = (BasicOfficeMateState)this.state;
            String access = GuiApp.getAppComplex().getApplicationSecurity().getAccessLevel((GUIStateI)adminState);
            this.setEnabled(access.equals("ENABLED"));
            this.setVisible(!access.equals("HIDDEN"));
        }
    }

    public GUIStateI getState() {
        return this.state;
    }

    private static class FilledCircleIcon
    extends CircleIcon {
        static final int OFFSET = 3;

        private FilledCircleIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            super.paintIcon(c, g, x, y);
            g.fillOval(3, c.getHeight() / 2 - 6 + 3, 7, 7);
        }

        @Override
        public int getIconHeight() {
            return 12;
        }

        @Override
        public int getIconWidth() {
            return 12;
        }
    }

    private static class CircleIcon
    implements Icon {
        static final int HEIGHT = 12;
        static final int WIDTH = 12;

        private CircleIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            int bulletX = 0;
            int bulletY = c.getHeight() / 2 - 6;
            g.setColor(c.getForeground());
            g.drawOval(bulletX, bulletY, 12, 12);
        }

        @Override
        public int getIconHeight() {
            return 12;
        }

        @Override
        public int getIconWidth() {
            return 12;
        }
    }
}

