/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.welcome;

import au.com.ordermate.application.GuiApp;
import au.com.ordermate.guicore.task.GUIStateI;
import au.com.ordermate.util.image.IconLoader;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import officemate.adminkit.state.welcome.WelcomeLinkButton;
import ordermate.signals.Signal;
import ordermate.signals.Signals;
import org.jdesktop.swingx.painter.Painter;

public class WelcomePanel
extends JPanel {
    private Color backgroundColor1 = new Color(70, 0, 0);
    private Color backgroundColor2 = new Color(197, 52, 57);
    private Color welcomeTextColor = Color.white;
    private Color applicationNameTextColor = Color.white;
    private Color restaurantTextColor = Color.white;
    private Color descriptionTextColor = Color.white;
    private Font welcomeFont = new Font("Arial", 1, 14);
    private Font applicationNameFont = new Font("Arial", 3, 30);
    private Font restaurantNameFont = new Font("Arial", 1, 20);
    private Font descriptionTextFont = new Font("Arial", 2, 17);
    private String welcomeText = "welcome to";
    private String applicationNameText = "OfficeMate";
    private final String restaurantText;
    private int textMarginFromRight = 30;
    private int textMarginFromTop = 60;
    private int imageMarginFromTop = this.textMarginFromTop + 20;
    private int linkMarginFromTop = this.imageMarginFromTop + 40;
    private int linkMarginFromLeft = 60;
    private int restaurantNameMarginFromLeft = 20;
    private Painter<WelcomePanel> painter = new DefaultPainter();
    public final Signal statePressed = Signals.createSignal(GUIStateI.class, (String)"selectedState");
    private List buttons;
    private JPanel buttonPanel;
    private JLabel descLabel;
    private JLabel locLabel;

    public WelcomePanel(String appName, String locationName, List<GUIStateI> states) {
        super(null, true);
        this.restaurantText = locationName;
        this.applicationNameText = appName;
        RolloverTextMouseListener rolloverListener = new RolloverTextMouseListener();
        this.buttons = new ArrayList(states.size());
        for (GUIStateI state : states) {
            final WelcomeLinkButton button = new WelcomeLinkButton(state);
            button.addMouseMotionListener(rolloverListener);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WelcomePanel.this.statePressed.emit((Object)button.getState());
                }
            });
            this.buttons.add(button);
        }
        this.locLabel = new JLabel(this.restaurantText);
        this.locLabel.setVisible(GuiApp.getAppComplex().getApplicationFrame().getProductName().equals("OfficeMate"));
        this.locLabel.setLocation(this.restaurantNameMarginFromLeft, this.imageMarginFromTop);
        this.locLabel.setSize(500, 40);
        this.locLabel.setOpaque(false);
        this.locLabel.setForeground(this.restaurantTextColor);
        this.locLabel.setFont(this.restaurantNameFont);
        this.add(this.locLabel);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setOpaque(false);
        this.buttonPanel.setBorder(null);
        this.refreshPanel();
        this.addMouseMotionListener(rolloverListener);
        GridLayout layout = new GridLayout(0, 2);
        this.buttonPanel.setLayout(layout);
        layout.setHgap(40);
        layout.setVgap(20);
        this.buttonPanel.setSize(this.buttonPanel.getPreferredSize());
        this.buttonPanel.setLocation(this.linkMarginFromLeft, this.linkMarginFromTop);
        this.add(this.buttonPanel);
        this.descLabel = new JLabel();
        this.descLabel.setLocation(this.restaurantNameMarginFromLeft, 380);
        this.descLabel.setSize(500, 40);
        this.descLabel.setOpaque(false);
        this.descLabel.setForeground(this.descriptionTextColor);
        this.descLabel.setFont(this.descriptionTextFont);
        this.add(this.descLabel);
    }

    public String getRestaurantName() {
        return this.restaurantText;
    }

    public void setPainter(Painter<WelcomePanel> newPainter) {
        if (newPainter == null) {
            throw new IllegalArgumentException("Painter cannot be null.");
        }
        this.painter = newPainter;
    }

    public void refreshPanel() {
        this.buttonPanel.removeAll();
        for (WelcomeLinkButton button : this.buttons) {
            button.updateSecurityState();
            if (!button.isVisible()) continue;
            this.buttonPanel.add(button);
        }
        this.revalidate();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.painter.paint(g2, (Object)this, this.getWidth(), this.getHeight());
    }

    private class DefaultPainter
    implements Painter<WelcomePanel> {
        private DefaultPainter() {
        }

        public void paint(Graphics2D g2, WelcomePanel panel, int width, int height) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Paint storedPaint = g2.getPaint();
            g2.setPaint(new GradientPaint(0.0f, 0.0f, WelcomePanel.this.backgroundColor2, width, height, WelcomePanel.this.backgroundColor1));
            g2.fillRect(0, 0, width, height);
            g2.setPaint(storedPaint);
            g2.setColor(WelcomePanel.this.backgroundColor2);
            for (int y = 0; y < height; y += 6) {
                g2.fillRect(0, y, width, 1);
            }
            g2.drawImage(IconLoader.getImage((String)"/ordermate/images/welcome_background.jpg"), 0, WelcomePanel.this.imageMarginFromTop, panel);
            int welcomeTextWidth = g2.getFontMetrics(WelcomePanel.this.welcomeFont).stringWidth(WelcomePanel.this.welcomeText);
            g2.setColor(WelcomePanel.this.welcomeTextColor);
            g2.setFont(WelcomePanel.this.welcomeFont);
            g2.drawString(WelcomePanel.this.welcomeText, width - welcomeTextWidth - WelcomePanel.this.textMarginFromRight, WelcomePanel.this.textMarginFromTop - 30);
            int applicationNameTextWidth = g2.getFontMetrics(WelcomePanel.this.applicationNameFont).stringWidth(WelcomePanel.this.applicationNameText);
            g2.setColor(WelcomePanel.this.applicationNameTextColor);
            g2.setFont(WelcomePanel.this.applicationNameFont);
            g2.drawString(WelcomePanel.this.applicationNameText, width - applicationNameTextWidth - WelcomePanel.this.textMarginFromRight, WelcomePanel.this.textMarginFromTop);
            g2.setPaint(new GradientPaint(0.0f, 0.0f, new Color(1.0f, 1.0f, 1.0f, 0.0f), width, 0.0f, WelcomePanel.this.applicationNameTextColor));
            g2.fillRect(0, WelcomePanel.this.textMarginFromTop + 5, width - WelcomePanel.this.textMarginFromRight, 3);
            g2.setPaint(storedPaint);
        }
    }

    private class RolloverTextMouseListener
    extends MouseMotionAdapter {
        private RolloverTextMouseListener() {
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            if (e.getSource() instanceof WelcomeLinkButton) {
                WelcomeLinkButton button = (WelcomeLinkButton)e.getSource();
                WelcomePanel.this.descLabel.setText(button.getState().getDescription());
                WelcomePanel.this.descLabel.repaint();
            } else {
                WelcomePanel.this.descLabel.setText("");
                WelcomePanel.this.descLabel.repaint();
            }
            WelcomePanel.this.descLabel.repaint();
        }
    }
}

