/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.state.welcome;

import au.com.ordermate.application.ApplicationNavigator;
import au.com.ordermate.application.ApplicationStateBlueprint;
import au.com.ordermate.application.GuiApp;
import au.com.ordermate.gui.adminkit.ComponentColors;
import au.com.ordermate.gui.adminkit.ComponentUtils;
import au.com.ordermate.util.image.IconLoader;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import officemate.adminkit.state.welcome.FavouriteComponent;
import officemate.adminkit.state.welcome.TopLabelPanel;
import officemate.screens.OfficeMateFrame;
import ordermate.database.gui.FavouriteEntryHelper;
import ordermate.database.gui.FavouritesEntry;
import ordermate.database.users.User;

public class YourFavouritesComponent
extends JPanel {
    private int COMPONENT_COUNT = 4;
    private ImageIcon pinkIcon = IconLoader.get((String)"/ordermate/images/pinkicon.png");
    private JPanel favouritesPanel = new JPanel();
    private List<FavouriteComponent> components = new ArrayList<FavouriteComponent>();
    private List<FavouritesEntry> mostRecentEntries = new ArrayList<FavouritesEntry>();

    public YourFavouritesComponent(List<FavouritesEntry> mostRecentEntries) {
        this.mostRecentEntries = mostRecentEntries;
        this.init();
        this.setOpaque(false);
    }

    private User getCurrentUser() {
        return GuiApp.getAppComplex().getApplicationSecurity().getUser();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.favouritesPanel.setLayout(new GridLayout(2, 2, 15, 15));
        this.favouritesPanel.setOpaque(false);
        this.favouritesPanel.setName("favouritePanel");
        this.addMostRecentFavouriteComponents();
        TopLabelPanel topLeftPanel = new TopLabelPanel("Your Favourites");
        this.add((Component)topLeftPanel, "North");
        this.add((Component)this.favouritesPanel, "Center");
        this.addMoreButton();
    }

    private void addMoreButton() {
        List allEntries = FavouriteEntryHelper.getFavourites((User)this.getCurrentUser());
        if (allEntries.size() > this.COMPONENT_COUNT) {
            JPanel moreButtonPanel = new JPanel();
            moreButtonPanel.setLayout(new FlowLayout(2));
            JLabel moreLabel = new JLabel("more...");
            moreLabel.setName("moreLabel");
            moreLabel.setAlignmentX(4.0f);
            moreLabel.setForeground(ComponentColors.MORE_LABEL_COLOR);
            moreLabel.setBorder(ComponentUtils.MORE_LABEL_BORDER);
            moreLabel.setFont(ComponentUtils.SANS_SERIF_BOLD_12);
            moreButtonPanel.setOpaque(false);
            moreLabel.setOpaque(false);
            moreLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    super.mouseClicked(e);
                    YourFavouritesComponent.this.moreButtonClicked();
                }
            });
            moreButtonPanel.add(moreLabel);
            this.add((Component)moreButtonPanel, "South");
            this.favouritesPanel.setBorder(ComponentUtils.FAVOURITE_WITH_MORE_BORDER);
        } else {
            this.favouritesPanel.setBorder(ComponentUtils.FAVOURITE_WITH_NO_BORDER);
        }
    }

    private void moreButtonClicked() {
        ApplicationNavigator navigator = GuiApp.getAppComplex().getApplicationNavigator();
        navigator.navigateTo("Favourites");
        ApplicationStateBlueprint bluey = GuiApp.getAppComplex().getApplicationStructure().getArchitecture().getBlueprint("Favourites");
        ((OfficeMateFrame)GuiApp.getAppComplex().getApplicationFrame()).getNavigationPanel().setSelectedObject(bluey);
    }

    private FavouriteComponent createFavouriteComponent(FavouritesEntry favouritesEntry) {
        return new FavouriteComponent((Icon)this.pinkIcon, favouritesEntry);
    }

    private void addMostRecentFavouriteComponents() {
        int recentComponentSize = this.mostRecentEntries.size();
        for (int i = 0; i < this.COMPONENT_COUNT; ++i) {
            if (i < recentComponentSize) {
                FavouriteComponent fc = this.createFavouriteComponent(this.mostRecentEntries.get(i));
                fc.repaint();
                this.components.add(fc);
                this.favouritesPanel.add(fc);
                continue;
            }
            JLabel fillerLabel = new JLabel();
            fillerLabel.setOpaque(false);
            this.favouritesPanel.add(fillerLabel);
        }
    }
}

