/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import au.com.ordermate.util.Assert;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import officemate.adminkit.ObjectTemplate;
import officemate.adminkit.filters.ObjectFilter;
import officemate.adminkit.table.ObjectTableModel;
import officemate.adminkit.types.BoolFieldType;
import officemate.adminkit.types.ColorFieldType;
import officemate.adminkit.types.DateFieldType;
import officemate.adminkit.types.DateTimeFieldType;
import officemate.adminkit.types.DoubleFieldType;
import officemate.adminkit.types.EnumFieldType;
import officemate.adminkit.types.FieldType;
import officemate.adminkit.types.IntFieldType;
import officemate.adminkit.types.ObjectRefFieldType;
import officemate.adminkit.types.PriceFieldType;
import officemate.adminkit.types.QuantityFieldType;
import officemate.adminkit.types.StringFieldType;

public class DefaultObjectTableModel
extends ObjectTableModel {
    private ObjectTemplate objTemplate = null;
    private String[] fieldNames = null;
    private TableColumnModel columnModel = new DefaultTableColumnModel(){};

    public DefaultObjectTableModel(ObjectTemplate objTemp) {
        this(objTemp, null, null);
    }

    public DefaultObjectTableModel(ObjectTemplate objTemp, String[] fieldsToDisplay) {
        this(objTemp, fieldsToDisplay, null);
    }

    public DefaultObjectTableModel(ObjectTemplate objTemp, String[] fieldsToDisplay, ObjectFilter objFilter) {
        super(objFilter);
        Assert.isTrue((objTemp != null ? 1 : 0) != 0, (String)"Object template must not be null");
        boolean useAllFields = fieldsToDisplay == null;
        this.objTemplate = objTemp;
        List<String> fieldsToDisplayList = useAllFields ? this.objTemplate.getFields() : Arrays.asList(fieldsToDisplay);
        int count = 0;
        Vector<String> fieldNamesList = new Vector<String>();
        for (String fieldName : fieldsToDisplayList) {
            boolean fieldNameOK;
            FieldType type = this.objTemplate.getFieldType(fieldName);
            boolean bl = fieldNameOK = useAllFields || this.objTemplate.hasField(fieldName);
            if (!this.isAllowableFieldType(type) || !fieldNameOK) continue;
            TableColumn col = new TableColumn(count);
            this.objTemplate.getManager().getObjectList(this.objTemplate.getObjectJavaClass());
            col.setCellEditor(type.getCellEditor(this.objTemplate.getObjectList()));
            col.setHeaderValue(fieldName);
            fieldNamesList.add(fieldName);
            this.columnModel.addColumn(col);
            ++count;
        }
        this.fieldNames = fieldNamesList.toArray(new String[0]);
    }

    @Override
    public boolean addObject(Object obj) {
        Assert.isTrue((boolean)this.objTemplate.objectBelongs(obj), (String)("Object " + obj + " does not belong to template \"" + this.objTemplate + "\""));
        return super.addObject(obj);
    }

    @Override
    public String getColumnName(int col) {
        return this.fieldNames[col];
    }

    public ObjectTemplate getObjectTemplate() {
        return this.objTemplate;
    }

    public Class getColumnClass(int index) {
        String field = this.getFieldForColumn(index);
        return this.objTemplate.getFieldType(field).getJavaClass();
    }

    public boolean isAllowableFieldType(FieldType type) {
        return type instanceof IntFieldType || type instanceof DoubleFieldType || type instanceof BoolFieldType || type instanceof EnumFieldType || type instanceof ObjectRefFieldType || type instanceof StringFieldType || type instanceof PriceFieldType || type instanceof DateFieldType || type instanceof DateTimeFieldType || type instanceof QuantityFieldType || type instanceof ColorFieldType;
    }

    @Override
    public String getFieldForColumn(int col) {
        return this.fieldNames[col];
    }

    @Override
    public Object getValueForField(Object obj, String prop) {
        return this.objTemplate.getObjectProperty(obj, prop);
    }

    @Override
    public void setValueAt(Object newValue, int row, int col) {
        String fieldName = this.getFieldForColumn(col);
        Object obj = this.getObjectForRow(row);
        this.objTemplate.setObjectProperty(obj, fieldName, newValue);
    }

    public int getColumnForName(String name) {
        for (int i = 0; i < this.fieldNames.length; ++i) {
            if (!this.fieldNames[i].equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int getColumnCount() {
        return this.columnModel.getColumnCount();
    }

    @Override
    public TableColumnModel getColumnModel() {
        return this.columnModel;
    }
}

