/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import au.com.ordermate.util.FormatStringifier;
import au.com.ordermate.util.Stringifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import officemate.adminkit.table.GroupedTableModel;

public class GroupedTableCellRenderer
extends DefaultTableCellRenderer {
    public static final Color EVEN_COLOR = new Color(250, 250, 230);
    public static final Color ODD_COLOR = Color.WHITE;
    private Stringifier stringifier;

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        MatteBorder defaultBorder;
        Font existingFont;
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (!isSelected) {
            this.setBackground(row % 2 == 0 ? EVEN_COLOR : ODD_COLOR);
        }
        if (this.stringifier != null) {
            this.setText(this.stringifier.stringify(value));
        }
        if (!(table.getModel() instanceof GroupedTableModel)) {
            return this;
        }
        if (hasFocus && table.getModel().isCellEditable(row, column)) {
            this.setBackground(Color.WHITE);
            this.setForeground(Color.BLACK);
        }
        GroupedTableModel model = (GroupedTableModel)table.getModel();
        int leftBorder = 1;
        if (column == 0) {
            leftBorder = 16;
        }
        MatteBorder totalBorder = null;
        if (model.isTitleRow(row)) {
            existingFont = this.getFont();
            Font boldFont = new Font(existingFont.getName(), 1, existingFont.getSize() + 3);
            this.setFont(boldFont);
            leftBorder = 2;
            this.setSize(100, this.getHeight());
        } else if (model.isTotalRow(row) && model.usesTotals()) {
            totalBorder = BorderFactory.createMatteBorder(1, 0, 0, 0, Color.black);
            existingFont = this.getFont();
            Font boldFont = new Font(existingFont.getName(), 1, existingFont.getSize());
            this.setFont(boldFont);
        }
        MatteBorder borderToUse = defaultBorder = BorderFactory.createMatteBorder(0, leftBorder, 0, 0, this.getBackground());
        if (totalBorder != null) {
            borderToUse = totalBorder;
        }
        this.setBorder(borderToUse);
        return this;
    }

    public void setStringifier(FormatStringifier<Double> formatStringifier) {
        this.stringifier = formatStringifier;
    }
}

