/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.ObjectUtils;

public abstract class GroupedTableModel
extends AbstractTableModel {
    private static final String EMPTY_GROUP = "(Empty)";
    private static final String BLANK = "";
    private AbstractTableModel wrappedModel;
    private String groupCol;
    private String[] totalCols;
    private int numCols;
    private int numRows;
    private Object[][] values;
    private String[] columnNames;
    private List<Integer> titleRows = new ArrayList<Integer>();
    private Set<Integer> totalRows = new LinkedHashSet<Integer>();
    private List<Integer> wrappedTableGroupRows = new LinkedList<Integer>();
    private boolean[] checkTotals;
    private int previousWrappedRowCount;

    public GroupedTableModel(AbstractTableModel wrappedModel, String groupedCol, String[] totalledCols) {
        this.wrappedModel = wrappedModel;
        this.groupCol = groupedCol;
        if (totalledCols == null) {
            this.totalCols = new String[0];
        } else {
            this.totalCols = new String[totalledCols.length];
            for (int i = 0; i < totalledCols.length; ++i) {
                this.totalCols[i] = totalledCols[i];
            }
        }
        this.numCols = this.getExpectedColumnCount();
        this.numRows = wrappedModel.getRowCount();
        this.createTable();
    }

    @Override
    public String getColumnName(int index) {
        return this.columnNames[index];
    }

    public void createTable() {
        this.clearTableModel();
        boolean structureChanged = this.numCols != this.wrappedModel.getColumnCount() - 1;
        this.numCols = this.getExpectedColumnCount();
        this.checkTotals = this.populateColumnNamesAndReturnTotalsColumns();
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Object lastGroupVal = null;
        int wrappedRowCount = this.wrappedModel.getRowCount();
        int groupColIndex = this.getGroupedColumnIndex();
        for (int wrappedRow = 0; wrappedRow < wrappedRowCount + 1; ++wrappedRow) {
            Object groupVal = this.getValueToGroupOn(groupColIndex, wrappedRow);
            if (groupVal == null || !groupVal.equals(lastGroupVal)) {
                if (lastGroupVal != null || groupVal == null) {
                    int totalRowIndex = rows.size();
                    rows.add(new Object[this.numCols]);
                    this.totalRows.add(totalRowIndex);
                    if (groupVal == null) break;
                }
                this.wrappedTableGroupRows.add(wrappedRow);
                lastGroupVal = groupVal;
                Object[] titleRow = new Object[this.numCols];
                Arrays.fill(titleRow, BLANK);
                titleRow[0] = groupVal;
                int titleRowIndex = rows.size();
                rows.add(titleRow);
                this.titleRows.add(titleRowIndex);
            }
            rows.add(new Object[this.numCols]);
        }
        this.numRows = rows.size();
        this.values = new Object[this.numRows][this.numCols];
        for (int r = 0; r < this.numRows; ++r) {
            Object[] row = (Object[])rows.get(r);
            for (int c = 0; c < this.numCols; ++c) {
                this.values[r][c] = row[c];
            }
        }
        this.previousWrappedRowCount = this.wrappedModel.getRowCount();
        this.updateTable();
        if (structureChanged) {
            this.fireTableStructureChanged();
        } else {
            this.fireTableDataChanged();
        }
    }

    void updateTable() {
        Object lastGroupVal = null;
        int wrappedRowCount = this.wrappedModel.getRowCount();
        if (this.previousWrappedRowCount != wrappedRowCount) {
            this.createTable();
            return;
        }
        int groupColIndex = this.getGroupedColumnIndex();
        double[] totals = new double[this.numCols];
        Iterator<Integer> totalRowsIterator = this.totalRows.iterator();
        Iterator<Integer> wrappedTableGroupRowsIterator = this.wrappedTableGroupRows.iterator();
        Iterator<Integer> titleRowsIterator = this.titleRows.iterator();
        int rowCount = 0;
        for (int wrappedRow = 0; wrappedRow < wrappedRowCount + 1; ++wrappedRow) {
            Object groupVal = this.getValueToGroupOn(groupColIndex, wrappedRow);
            if (groupVal == null || !groupVal.equals(lastGroupVal)) {
                Integer expectedWrappedGroupStart;
                if (lastGroupVal != null || groupVal == null) {
                    Object[] totalObjects = new Object[this.numCols];
                    for (int i = 0; i < this.numCols; ++i) {
                        totalObjects[i] = this.checkTotals[i] ? this.createTotalValue(groupVal, totals[i], wrappedRow, i) : BLANK;
                    }
                    Integer totalRowIndex = rowCount;
                    Integer expectedTotalRowIndex = totalRowsIterator.next();
                    if (!expectedTotalRowIndex.equals(totalRowIndex)) {
                        throw new IllegalStateException("Total Row expected " + expectedTotalRowIndex + " but was " + totalRowIndex);
                    }
                    this.values[rowCount] = totalObjects;
                    ++rowCount;
                    if (groupVal == null) break;
                }
                if (!(expectedWrappedGroupStart = wrappedTableGroupRowsIterator.next()).equals(wrappedRow)) {
                    throw new IllegalStateException("Start of group row in backing table model doesn't match same row when populating data\nExpected " + expectedWrappedGroupStart + " but got " + wrappedRow);
                }
                lastGroupVal = groupVal;
                totals = new double[this.numCols];
                Object[] titleRow = new Object[this.numCols];
                Arrays.fill(titleRow, BLANK);
                titleRow[0] = groupVal;
                int titleRowIndex = rowCount++;
                this.values[titleRowIndex] = titleRow;
                Integer expectedTitleRow = titleRowsIterator.next();
                if (!expectedTitleRow.equals(titleRowIndex)) {
                    throw new IllegalStateException("Expected title row at " + expectedTitleRow + " but got at " + titleRowIndex);
                }
            }
            Object[] newRow = this.values[rowCount];
            this.populateRow(newRow, wrappedRow, totals);
            ++rowCount;
        }
    }

    private int getGroupedColumnIndex() {
        return this.wrappedModel.findColumn(this.groupCol);
    }

    private void populateRow(Object[] newRow, int wrappedRowIndex, double[] totals) {
        int groupColIndex = this.getGroupedColumnIndex();
        int n = 0;
        for (int o = 0; o < this.wrappedModel.getColumnCount(); ++o) {
            if (o == groupColIndex) continue;
            Object oldValue = this.wrappedModel.getValueAt(wrappedRowIndex, o);
            newRow[n] = this.createTableValue(oldValue, wrappedRowIndex, n);
            if (this.checkTotals[n] && oldValue != null) {
                int n2 = n;
                totals[n2] = totals[n2] + ((Number)oldValue).doubleValue();
            }
            ++n;
        }
    }

    private Object getValueToGroupOn(int groupColIndex, int rowIdx) {
        Object groupVal = null;
        if (rowIdx < this.wrappedModel.getRowCount() && (groupVal = this.wrappedModel.getValueAt(rowIdx, groupColIndex)) == null) {
            groupVal = EMPTY_GROUP;
        }
        return groupVal;
    }

    private boolean[] populateColumnNamesAndReturnTotalsColumns() {
        this.checkTotals = new boolean[this.numCols];
        this.columnNames = new String[this.numCols];
        int n = 0;
        for (int i = 0; i < this.wrappedModel.getColumnCount(); ++i) {
            String oldColName = this.wrappedModel.getColumnName(i);
            if (oldColName.equals(this.groupCol)) continue;
            for (String totalCol : this.totalCols) {
                if (!totalCol.equals(oldColName)) continue;
                this.checkTotals[n] = true;
                break;
            }
            this.columnNames[n] = oldColName;
            ++n;
        }
        return this.checkTotals;
    }

    private int getExpectedColumnCount() {
        return this.wrappedModel.getColumnCount() - 1;
    }

    public boolean hasStructureChanged() {
        return this.numCols != this.getExpectedColumnCount();
    }

    private void clearTableModel() {
        this.wrappedTableGroupRows.clear();
        this.titleRows.clear();
        this.totalRows.clear();
    }

    public boolean usesTotals() {
        return this.totalCols.length > 0;
    }

    public boolean isTitleRow(int rowIndex) {
        return this.titleRows.contains(rowIndex);
    }

    public boolean isTotalRow(int rowIndex) {
        return this.totalRows.contains(rowIndex);
    }

    @Override
    public int getColumnCount() {
        return this.numCols;
    }

    @Override
    public int getRowCount() {
        return this.numRows;
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.values[row][col];
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (!this.hasOriginalRow(rowIndex) || !this.hasOriginalColumn(columnIndex)) {
            return false;
        }
        int originalRow = this.getOriginalRow(rowIndex);
        int originalCol = this.getOriginalColumn(columnIndex);
        return this.wrappedModel.isCellEditable(originalRow, originalCol);
    }

    @Override
    public void setValueAt(Object val, int row, int col) {
        if (this.hasOriginalRow(row) && this.hasOriginalColumn(col)) {
            int originalRow = this.getOriginalRow(row);
            int originalCol = this.getOriginalColumn(col);
            Object oldValue = this.wrappedModel.getValueAt(originalRow, originalCol);
            if (originalCol >= 0 && originalRow < this.wrappedModel.getRowCount()) {
                this.wrappedModel.setValueAt(val, originalRow, originalCol);
                Object newValue = this.wrappedModel.getValueAt(originalRow, originalCol);
                if (!ObjectUtils.equals((Object)oldValue, (Object)newValue)) {
                    this.values[row][col] = newValue;
                    this.fireTableCellUpdated(row, col);
                }
            }
        }
    }

    protected abstract Object createTableValue(Object var1, int var2, int var3);

    protected abstract Object createTotalValue(Object var1, double var2, int var4, int var5);

    public int getGroupIndexForOriginalTable(int originalTableRow) {
        Integer groupRowObj;
        int groupRow;
        int groupIndex;
        for (groupIndex = 1; groupIndex < this.wrappedTableGroupRows.size() && (groupRow = (groupRowObj = this.wrappedTableGroupRows.get(groupIndex)).intValue()) <= originalTableRow; ++groupIndex) {
        }
        return groupIndex - 1;
    }

    public int getGroupIndexForGroupedTable(int groupedTableRow) {
        Integer titleRowObj;
        int groupRow;
        int groupIndex;
        if (this.isTitleRow(groupedTableRow) || this.isTotalRow(groupedTableRow)) {
            return -1;
        }
        for (groupIndex = 1; groupIndex < this.titleRows.size() && (groupRow = (titleRowObj = this.titleRows.get(groupIndex)).intValue()) <= groupedTableRow; ++groupIndex) {
        }
        return groupIndex - 1;
    }

    public AbstractTableModel getWrappedModel() {
        return this.wrappedModel;
    }

    public int getGroupedRow(int originalTableRow) {
        int groupIndex = this.getGroupIndexForOriginalTable(originalTableRow);
        int groupedRow = originalTableRow + 1 + 2 * groupIndex;
        return groupedRow;
    }

    public int getOriginalRow(int groupedTableRow) {
        int groupIndex = this.getGroupIndexForGroupedTable(groupedTableRow);
        if (groupIndex == -1) {
            return -1;
        }
        int groupedRow = groupedTableRow - 1 - 2 * groupIndex;
        return groupedRow;
    }

    public boolean hasOriginalRow(int groupedTableRow) {
        return this.getOriginalRow(groupedTableRow) != -1;
    }

    public int getOriginalColumn(int groupedTableColumn) {
        String colName = this.getColumnName(groupedTableColumn);
        int oldCol = this.wrappedModel.findColumn(colName);
        return oldCol;
    }

    public boolean hasOriginalColumn(int groupedTableColum) {
        return this.getOriginalColumn(groupedTableColum) != -1;
    }

    public String getGroupedColumn() {
        return this.groupCol;
    }

    public void setGroupedColumn(String newGroup) {
        if (newGroup != null) {
            this.groupCol = newGroup;
            this.createTable();
        }
    }

    public Class getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return super.getColumnClass(0);
        }
        return this.getWrappedModel().getColumnClass(this.getOriginalColumn(columnIndex));
    }
}

