/*
 * Decompiled with CFR 0.152.
 */
package officemate.adminkit.table;

import au.com.ordermate.persistence.PropertiedObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import officemate.adminkit.filters.ObjectFilter;

public abstract class ObjectTableModel
extends AbstractTableModel {
    private List allObjects = new Vector();
    private ArrayList columnEditability = new ArrayList();
    private List objects = new Vector();
    private ObjectFilter filter = null;

    protected ObjectTableModel() {
    }

    public boolean hasObject(Object o) {
        return this.allObjects.contains(o);
    }

    public boolean hasVisibleObject(Object o) {
        return this.objects.contains(o);
    }

    protected ObjectTableModel(ObjectFilter objFilter) {
        this.filter = objFilter;
    }

    public abstract TableColumnModel getColumnModel();

    public abstract String getFieldForColumn(int var1);

    public abstract Object getValueForField(Object var1, String var2);

    public Object getValueForColumn(Object obj, int col) {
        return this.getValueForField(obj, this.getFieldForColumn(col));
    }

    public Object getObjectForRow(int row) {
        return this.objects.get(row);
    }

    public boolean addObject(Object obj) {
        this.allObjects.add(obj);
        if (this.filter == null || this.filter.accept(obj)) {
            this.objects.add(obj);
            int index = this.objects.size() - 1;
            this.fireTableRowsInserted(index, index);
            return true;
        }
        return false;
    }

    void notifyObjectWasEdited() {
        this.updateViews();
        this.fireTableDataChanged();
    }

    public void removeObject(Object obj) {
        int index = this.objects.indexOf(obj);
        this.allObjects.remove(obj);
        this.objects.remove(index);
        this.fireTableRowsDeleted(index, index);
    }

    public List getObjects() {
        return this.allObjects;
    }

    public List getFilteredObjects() {
        ArrayList retval = new ArrayList(this.allObjects.size());
        for (int i = 0; i < this.allObjects.size(); ++i) {
            Object obj = this.allObjects.get(i);
            if (!this.filter.accept(obj)) continue;
            retval.add(obj);
        }
        return retval;
    }

    public void setObjects(List objList) {
        int oldSize = this.objects.size();
        this.allObjects = new Vector(objList);
        if (this.filter == null) {
            this.objects = new Vector(objList);
        } else {
            this.objects = new Vector(objList.size());
            for (int i = 0; i < objList.size(); ++i) {
                Object o = objList.get(i);
                if (!this.filter.accept(o)) continue;
                this.objects.add(o);
            }
        }
        this.fireTableRowsDeleted(0, oldSize);
        this.fireTableRowsInserted(0, this.objects.size());
    }

    @Override
    public abstract int getColumnCount();

    @Override
    public int getRowCount() {
        return this.objects.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object obj = this.objects.get(rowIndex);
        if (obj != null) {
            return this.getValueForColumn(obj, columnIndex);
        }
        return null;
    }

    public ObjectFilter getObjectFilter() {
        return this.filter;
    }

    public void setObjectFilter(ObjectFilter obj) {
        this.filter = obj;
        this.updateViews();
    }

    public void updateViews() {
        this.setObjects(this.allObjects);
    }

    public void setColumnEditable(int columnIndex, boolean editable) {
        if (columnIndex < this.columnEditability.size()) {
            this.columnEditability.set(columnIndex, editable);
        } else {
            this.columnEditability.ensureCapacity(columnIndex + 1);
            for (int i = this.columnEditability.size(); i <= columnIndex; ++i) {
                this.columnEditability.add(Boolean.FALSE);
            }
            this.columnEditability.set(columnIndex, editable);
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (this.columnEditability.size() <= columnIndex) {
            return false;
        }
        Boolean isColumnEditable = (Boolean)this.columnEditability.get(columnIndex);
        if (isColumnEditable != null) {
            return isColumnEditable;
        }
        return false;
    }

    public int findColumn(PropertiedObject.Property property) {
        return super.findColumn(property.getUserVisibleLabel());
    }
}

